/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lastaflute.di.util.LdiDecimalFormatUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiByteConversionUtil {
    protected LdiByteConversionUtil() {
    }

    public static Byte toByte(Object o) {
        return LdiByteConversionUtil.toByte(o, null);
    }

    public static Byte toByte(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof Number) {
            return new Byte(((Number)o).byteValue());
        }
        if (o instanceof String) {
            return LdiByteConversionUtil.toByte((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Byte(new SimpleDateFormat(pattern).format(o));
            }
            return new Byte((byte)((Date)o).getTime());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? new Byte(1) : new Byte(0);
        }
        return LdiByteConversionUtil.toByte(o.toString());
    }

    private static Byte toByte(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return null;
        }
        return new Byte(LdiDecimalFormatUtil.normalize(s));
    }

    public static byte toPrimitiveByte(Object o) {
        return LdiByteConversionUtil.toPrimitiveByte(o, null);
    }

    public static byte toPrimitiveByte(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof String) {
            return LdiByteConversionUtil.toPrimitiveByte((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Byte.parseByte(new SimpleDateFormat(pattern).format(o));
            }
            return (byte)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        return LdiByteConversionUtil.toPrimitiveByte(o.toString());
    }

    private static byte toPrimitiveByte(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return 0;
        }
        return Byte.parseByte(LdiDecimalFormatUtil.normalize(s));
    }
}

