/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.dbcp.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.lastaflute.jta.dbcp.impl.DBXAResourceImpl;

public class XAConnectionImpl
implements XAConnection {
    private Connection connection;
    private final XAResource xaResource;
    private final List<ConnectionEventListener> listeners = new ArrayList<ConnectionEventListener>();

    public XAConnectionImpl(Connection connection) {
        this.connection = connection;
        this.xaResource = this.newDBXAResourceImpl(connection);
    }

    protected DBXAResourceImpl newDBXAResourceImpl(Connection connection) {
        return new DBXAResourceImpl(connection);
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (!this.connection.isClosed()) {
            this.connection.close();
        }
        this.connection = null;
    }

    public String toString() {
        return "xaConnection:{" + this.xaResource + "}@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public XAResource getXAResource() {
        return this.xaResource;
    }
}

