/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.defbuilder;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.annotation.AutoBindingType;
import org.lastaflute.di.core.annotation.Component;
import org.lastaflute.di.core.annotation.InstanceType;
import org.lastaflute.di.core.assembler.AutoBindingDefFactory;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandler;
import org.lastaflute.di.core.factory.defbuilder.ComponentDefBuilder;
import org.lastaflute.di.core.meta.AutoBindingDef;
import org.lastaflute.di.core.meta.InstanceDef;
import org.lastaflute.di.core.meta.impl.ComponentDefImpl;
import org.lastaflute.di.core.meta.impl.InstanceDefFactory;
import org.lastaflute.di.util.LdiStringUtil;

public class PojoComponentDefBuilder
implements ComponentDefBuilder {
    @Override
    public ComponentDef createComponentDef(AnnotationHandler annotationHandler, Class<?> componentClass, InstanceDef defaultInstanceDef, AutoBindingDef defaultAutoBindingDef, boolean defaultExternalBinding) {
        Component component = componentClass.getAnnotation(Component.class);
        if (component == null) {
            return null;
        }
        ComponentDefImpl componentDef = new ComponentDefImpl(componentClass);
        if (!LdiStringUtil.isEmpty(component.name())) {
            componentDef.setComponentName(component.name());
        }
        componentDef.setInstanceDef(this.getInstanceDef(component, defaultInstanceDef));
        componentDef.setAutoBindingDef(this.getAutoBindingDef(component, defaultAutoBindingDef));
        componentDef.setExternalBinding(component.externalBinding());
        return componentDef;
    }

    protected InstanceDef getInstanceDef(Component component, InstanceDef defaultInstanceDef) {
        InstanceType instanceType = component.instance();
        if (instanceType == null || LdiStringUtil.isEmpty(instanceType.getName())) {
            return defaultInstanceDef;
        }
        return InstanceDefFactory.getInstanceDef(instanceType.getName());
    }

    protected AutoBindingDef getAutoBindingDef(Component component, AutoBindingDef defaultAutoBindingDef) {
        AutoBindingType autoBindingType = component.autoBinding();
        if (autoBindingType == null || LdiStringUtil.isEmpty(autoBindingType.getName())) {
            return defaultAutoBindingDef;
        }
        return AutoBindingDefFactory.getAutoBindingDef(autoBindingType.getName());
    }
}

