/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.expression;

import java.util.Map;
import java.util.function.Function;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.di.core.expression.Expression;
import org.lastaflute.di.core.expression.dwarf.ExpressionPlainHook;
import org.lastaflute.di.core.expression.dwarf.SimpleExpressionPlainHook;
import org.lastaflute.di.core.expression.engine.ExpressionEngine;
import org.lastaflute.di.core.expression.engine.JavaScriptExpressionEngine;
import org.lastaflute.di.util.LdiClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingExpression
implements Expression {
    private static final Logger logger = LoggerFactory.getLogger(ScriptingExpression.class);
    protected static final SimpleExpressionPlainHook defaultPlainHook = new SimpleExpressionPlainHook();
    protected static Boolean internalDebug;
    protected final ExpressionEngine engine = this.prepareEngine();
    protected final Object parsed;

    public ScriptingExpression(String source) {
        this.parsed = this.engine.parseExpression(source);
    }

    public ScriptingExpression(Function<ScriptingExpression, String> sourceProvider) {
        this.parsed = this.engine.parseExpression(sourceProvider.apply(this));
    }

    protected ExpressionEngine prepareEngine() {
        Class<?> engineType = LastaDiProperties.getInstance().getDiXmlScriptExpressionEngineType();
        ExpressionEngine engine = engineType != null ? (ExpressionEngine)LdiClassUtil.newInstance(engineType) : this.createDefaultEngine();
        return engine;
    }

    protected ExpressionEngine createDefaultEngine() {
        return new JavaScriptExpressionEngine();
    }

    @Override
    public Object evaluate(Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        Object hooked;
        if (this.parsed instanceof String && (hooked = this.hookPlainly((String)this.parsed, contextMap, container, resultType)) != null) {
            if (this.isInternalDebug()) {
                logger.debug("#fw_debug Parsed as simple expression by plain hook: {} => {}", this.parsed, hooked);
            }
            return hooked;
        }
        if (this.isInternalDebug()) {
            logger.debug("#fw_debug ...Evaluating the script by expression engine: script={}", this.parsed);
        }
        return this.engine.evaluate(this.parsed, contextMap, container, resultType);
    }

    protected Object hookPlainly(String expression, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        ExpressionPlainHook plainHook = this.preparePlainHook();
        return plainHook != null ? plainHook.hookPlainly(expression, contextMap, container, resultType) : null;
    }

    public ExpressionPlainHook preparePlainHook() {
        return defaultPlainHook;
    }

    public String resolveStaticMethodReference(Class<?> refType, String methodName) {
        return this.engine.resolveStaticMethodReference(refType, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isInternalDebug() {
        if (internalDebug != null) return internalDebug;
        Class<ScriptingExpression> clazz = ScriptingExpression.class;
        synchronized (ScriptingExpression.class) {
            if (internalDebug != null) return internalDebug;
            internalDebug = LastaDiProperties.getInstance().isInternalDebug();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return internalDebug;
        }
    }
}

