/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.expression.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.di.core.exception.ExpressionClassCreateFailureException;
import org.lastaflute.di.core.expression.dwarf.ExpressionCastResolver;
import org.lastaflute.di.core.expression.engine.ExpressionEngine;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class JavaScriptExpressionEngine
implements ExpressionEngine {
    protected static final String SQ = "'";
    protected static final String DQ = "\"";
    protected static final ScriptEngineManager defaultManager = new ScriptEngineManager();
    protected static final ExpressionCastResolver castResolver = new ExpressionCastResolver();

    @Override
    public Object parseExpression(String source) {
        return source.trim();
    }

    @Override
    public Object evaluate(Object exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        return this.viaVariableResolvedEvaluate((String)exp, contextMap, container, resultType);
    }

    protected Object viaVariableResolvedEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        String filteredExp = exp;
        for (Map.Entry<String, ? extends Object> entry : contextMap.entrySet()) {
            filteredExp = LdiStringUtil.replace(filteredExp, "#" + entry.getKey(), SQ + entry.getValue() + SQ);
        }
        return this.viaCastResolvedEvaluate(filteredExp, contextMap, container, resultType);
    }

    protected Object viaCastResolvedEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        Class<?> realType;
        String realExp;
        ExpressionCastResolver.CastResolved resolved = castResolver.resolveCast(exp, resultType);
        if (resolved != null) {
            realExp = resolved.getFilteredExp();
            realType = resolved.getResolvedType();
        } else {
            realExp = exp.trim();
            realType = resultType;
        }
        return this.viaFirstNameResolvedEvaluate(realExp, contextMap, container, realType);
    }

    protected Object viaFirstNameResolvedEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        String filteredExp;
        String firstName = null;
        LaContainer firstComponent = null;
        if (!exp.startsWith(DQ) && !exp.startsWith("[") && !exp.startsWith("{") && exp.contains(".")) {
            String componentName = exp.substring(0, exp.indexOf("."));
            LaContainer namedContainer = container.getRoot().findChild(componentName);
            if (namedContainer != null) {
                String rear = exp.substring(exp.indexOf(".") + ".".length());
                if (rear.contains(".")) {
                    String nextName = rear.substring(0, rear.indexOf("."));
                    if (namedContainer.hasComponentDef(nextName)) {
                        filteredExp = rear;
                        firstName = nextName;
                        firstComponent = namedContainer.getComponent(nextName);
                    } else {
                        filteredExp = exp;
                        firstName = componentName;
                        firstComponent = namedContainer;
                    }
                } else {
                    if (namedContainer.hasComponentDef(rear)) {
                        return namedContainer.getComponent(rear);
                    }
                    filteredExp = exp;
                    firstName = componentName;
                    firstComponent = namedContainer;
                }
            } else {
                filteredExp = exp;
                if (container.hasComponentDef(componentName)) {
                    firstName = componentName;
                    firstComponent = (LaContainer)container.getComponent(componentName);
                }
            }
        } else {
            filteredExp = exp;
        }
        Object evaluated = this.actuallyEvaluate(filteredExp, contextMap, container, firstName, firstComponent);
        Object filtered = this.filterEvaluated(filteredExp, contextMap, container, evaluated, resultType);
        return filtered;
    }

    protected Object actuallyEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, String firstName, Object firstComponent) {
        ScriptEngine engine = this.comeOnScriptEngine();
        if (firstName != null) {
            engine.put(firstName, firstComponent);
        }
        try {
            return engine.eval(exp);
        }
        catch (RuntimeException | ScriptException e) {
            this.throwJavaScriptExpressionException(exp, contextMap, container, e);
            return null;
        }
    }

    protected ScriptEngine comeOnScriptEngine() {
        String specifyedName = LastaDiProperties.getInstance().getDiXmlScriptManagedEngineName();
        String engineName = specifyedName != null ? specifyedName : this.getDefaultEngineName();
        ScriptEngine engine = this.prepareScriptEngineManager().getEngineByName(engineName);
        if (engine == null) {
            this.throwScriptEngineNotFoundException(engineName);
        }
        return engine;
    }

    protected void throwScriptEngineNotFoundException(String engineName) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Not found the script engine by the name.");
        br.addItem("Advice");
        br.addElement("Confirm that the engine exists in your JavaVM.");
        br.addElement("(also your lasta_di.properties settings)");
        br.addItem("Engine Name");
        br.addElement(engineName);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected String getDefaultEngineName() {
        return "javascript";
    }

    protected ScriptEngineManager prepareScriptEngineManager() {
        return defaultManager;
    }

    protected void throwJavaScriptExpressionException(Object exp, Map<String, ? extends Object> contextMap, LaContainer container, Exception e) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to evaluate the JavaScript expression.");
        br.addItem("Di XML");
        br.addElement(container.getPath());
        br.addItem("Expression");
        br.addElement(exp);
        br.addItem("Context Map");
        br.addElement(contextMap);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, e);
    }

    protected Object filterEvaluated(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Object evaluated, Class<?> resultType) {
        if (evaluated instanceof String) {
            String str = ((String)evaluated).trim();
            String prefix = "new ";
            String suffix = "()";
            if (str.startsWith("new ") && str.endsWith("()")) {
                String className = str.substring("new ".length(), str.length() - "()".length());
                try {
                    return LdiClassUtil.newInstance(className);
                }
                catch (RuntimeException e) {
                    this.throwExpressionClassCreateFailureException(exp, contextMap, container, className, e);
                }
            }
        }
        if (evaluated instanceof Map) {
            Map map = (Map)evaluated;
            return this.handleMap(exp, contextMap, container, map, resultType);
        }
        return evaluated;
    }

    protected void throwExpressionClassCreateFailureException(String exp, Map<String, ? extends Object> contextMap, LaContainer container, String className, RuntimeException cause) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to create the class in the expression.");
        br.addItem("Di XML");
        br.addElement(container.getPath());
        br.addItem("Expression");
        br.addElement(exp);
        br.addItem("Context Map");
        br.addElement(contextMap);
        br.addItem("Class Name");
        br.addElement(className);
        String msg = br.buildExceptionMessage();
        throw new ExpressionClassCreateFailureException(msg, cause);
    }

    protected Object handleMap(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Map<String, Object> map, Class<?> resultType) {
        List<Object> challengeList = this.challengeList(map);
        if (challengeList != null) {
            return castResolver.convertListTo(exp, contextMap, container, resultType, challengeList);
        }
        return map;
    }

    protected List<Object> challengeList(Map<String, Object> map) {
        int index = 0;
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            if (LdiStringUtil.isNumber(key) && Integer.parseInt(key) == index) {
                ++index;
                continue;
            }
            return null;
        }
        return new ArrayList<Object>(map.values());
    }

    @Override
    public String resolveStaticMethodReference(Class<?> refType, String methodName) {
        return refType.getName() + "." + methodName;
    }
}

