/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.meta.impl;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.exception.ComponentNotFoundException;
import org.lastaflute.di.core.meta.impl.LaContainerImpl;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;

public class LaContainerBehavior {
    private static Provider provider = new DefaultProvider();

    private LaContainerBehavior() {
    }

    public static Provider getProvider() {
        return provider;
    }

    public static void setProvider(Provider p) {
        provider = p;
    }

    public static ComponentDef acquireFromGetComponent(LaContainer container, Object key) {
        return LaContainerBehavior.getProvider().acquireFromGetComponent(container, key);
    }

    public static ComponentDef acquireFromGetComponentDef(LaContainer container, Object key) {
        return LaContainerBehavior.getProvider().acquireFromGetComponentDef(container, key);
    }

    public static ComponentDef acquireFromHasComponentDef(LaContainer container, Object key) {
        return LaContainerBehavior.getProvider().acquireFromHasComponentDef(container, key);
    }

    public static ComponentDef acquireFromInjectDependency(LaContainer container, Object key) {
        return LaContainerBehavior.getProvider().acquireFromInjectDependency(container, key);
    }

    public static class DefaultProvider
    implements Provider {
        @Override
        public ComponentDef acquireFromGetComponent(LaContainer container, Object key) {
            return this.acquireFromGetComponentDef(container, key);
        }

        @Override
        public ComponentDef acquireFromGetComponentDef(LaContainer container, Object key) {
            ComponentDef cd = this.getComponentDef(container, key);
            if (cd == null) {
                this.throwComponentNotFoundException(container, key);
            }
            return cd;
        }

        protected void throwComponentNotFoundException(LaContainer container, Object key) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Not found the component by the key.");
            br.addItem("Component Key");
            br.addElement(key);
            br.addItem("Definition Path");
            br.addElement(container.getPath());
            String msg = br.buildExceptionMessage();
            throw new ComponentNotFoundException(msg, key);
        }

        @Override
        public ComponentDef acquireFromHasComponentDef(LaContainer container, Object key) {
            return this.getComponentDef(container, key);
        }

        @Override
        public ComponentDef acquireFromInjectDependency(LaContainer container, Object key) {
            return this.acquireFromGetComponentDef(container, key);
        }

        protected ComponentDef getComponentDef(LaContainer container, Object key) {
            return ((LaContainerImpl)container).internalGetComponentDef(key);
        }
    }

    public static interface Provider {
        public ComponentDef acquireFromGetComponent(LaContainer var1, Object var2);

        public ComponentDef acquireFromGetComponentDef(LaContainer var1, Object var2);

        public ComponentDef acquireFromHasComponentDef(LaContainer var1, Object var2);

        public ComponentDef acquireFromInjectDependency(LaContainer var1, Object var2);
    }
}

