/*
 * Copyright 2015-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.lastaflute.di.core.external;

import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.meta.impl.LaContainerImpl;

/**
 * @author modified by jflute (originated in Seasar)
 * 
 */
public class GenericExternalContextComponentDefRegister implements ExternalContextComponentDefRegister {

    public void registerComponentDefs(final LaContainer container) {
        final LaContainerImpl impl = (LaContainerImpl) container;
        impl.register0(new ApplicationComponentDef());
        impl.register0(new ApplicationMapComponentDef());
        impl.register0(new InitParameterMapComponentDef());
        impl.register0(new SessionMapComponentDef());
        impl.register0(new RequestComponentDef());
        impl.register0(new RequestMapComponentDef());
        impl.register0(new RequestHeaderMapComponentDef());
        impl.register0(new RequestHeaderValuesMapComponentDef());
        impl.register0(new RequestParameterMapComponentDef());
        impl.register0(new RequestParameterValuesMapComponentDef());
    }
}
