/*
 * Copyright 2015-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.lastaflute.di.core.meta.impl;

import java.util.Map;

import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.expression.SimpleSourceExpression;

/**
 * @author modified by jflute (originated in Seasar)
 */
public class ComponentNameExpression extends SimpleSourceExpression {

    public ComponentNameExpression(String source) {
        super(source);
    }

    public Object evaluate(Map<String, ? extends Object> context, LaContainer container, Class<?> conversionType) {
        Object result = container.getComponent(source);
        if (result == null && context != null) {
            result = context.get(source);
        }
        return result;
    }
}
