/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.expression.dwarf;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.expression.dwarf.ExpressionCastResolver;
import org.lastaflute.di.core.expression.dwarf.ExpressionPlainHook;
import org.lastaflute.di.core.expression.engine.ExpressionEngine;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.beans.factory.BeanDescFactory;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiSrl;
import org.lastaflute.di.util.LdiStringUtil;
import org.lastaflute.di.util.tiger.LdiReflectionUtil;

public class SimpleExpressionPlainHook
implements ExpressionPlainHook {
    protected static final ExpressionCastResolver castResolver = new ExpressionCastResolver();

    @Override
    public Object hookPlainly(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        String resolvedExp = ExpressionEngine.resolveExpressionVariableSimply(exp, contextMap);
        return this.doHookPlainly(resolvedExp, contextMap, container, resultType);
    }

    protected Object doHookPlainly(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        Class<?> realType;
        String realExp;
        ExpressionCastResolver.CastResolved resolved = castResolver.resolveCast(exp, resultType);
        if (resolved != null) {
            realExp = resolved.getFilteredExp();
            realType = resolved.getResolvedType();
        } else {
            realExp = exp.trim();
            realType = resultType;
        }
        return this.actuallyHookPlainly(realExp, container, realType);
    }

    protected Object actuallyHookPlainly(String exp, LaContainer container, Class<?> resultType) {
        Object resovled = this.resolveSimpleString(exp, container, resultType);
        if (this.isReallyResolved(resovled)) {
            return resovled;
        }
        resovled = this.resolveSimpleNumber(exp, container, resultType);
        if (this.isReallyResolved(resovled)) {
            return resovled;
        }
        resovled = this.resolveSimpleEqualEqual(exp, container, resultType);
        if (this.isReallyResolved(resovled)) {
            return resovled;
        }
        resovled = this.resolveSimpleTypeExp(exp, container, resultType);
        if (this.isReallyResolved(resovled)) {
            return resovled;
        }
        resovled = this.resolveSimpleComponent(exp, container, resultType);
        if (this.isReallyResolved(resovled)) {
            return resovled;
        }
        resovled = this.resolveExistsResource(exp, container, resultType);
        if (this.isReallyResolved(resovled)) {
            return resovled;
        }
        resovled = this.resolveProviderConfig(exp, container, resultType);
        if (this.isReallyResolved(resovled)) {
            return resovled;
        }
        resovled = this.resolveComponentList(exp, container, resultType);
        if (this.isReallyResolved(resovled)) {
            return resovled;
        }
        return null;
    }

    protected boolean isReallyResolved(Object resovled) {
        return resovled != null;
    }

    protected Object resolveSimpleString(String exp, LaContainer container, Class<?> resultType) {
        String unquoted;
        if (exp.startsWith("\"") && exp.endsWith("\"") && exp.length() > "\"".length() && !(unquoted = exp.substring("\"".length(), exp.length() - "\"".length())).contains("\"")) {
            return unquoted;
        }
        return null;
    }

    protected Object resolveSimpleNumber(String exp, LaContainer container, Class<?> resultType) {
        if (LdiStringUtil.isNumber(exp)) {
            if (exp.length() > 9) {
                return Long.valueOf(exp);
            }
            return Integer.valueOf(exp);
        }
        return null;
    }

    protected Object resolveSimpleEqualEqual(String exp, LaContainer container, Class<?> resultType) {
        String[] split;
        if (exp.contains("==") && (split = exp.split("==")).length == 2) {
            String left = split[0].trim();
            String right = split[1].trim();
            if (left.startsWith("'") && left.endsWith("'") && left.length() > "'".length() && right.startsWith("'") && right.endsWith("'") && right.length() > "'".length()) {
                String unquotedLeft = left.substring("'".length(), left.length() - "'".length());
                String unquotedRight = right.substring("'".length(), right.length() - "'".length());
                if (!unquotedLeft.contains("'") && !unquotedRight.contains("'")) {
                    return unquotedLeft.equals(unquotedRight);
                }
            }
        }
        return null;
    }

    protected Object resolveSimpleTypeExp(String exp, LaContainer container, Class<?> resultType) {
        if (exp.startsWith("@") && exp.endsWith("@class")) {
            String className = exp.substring("@".length(), exp.lastIndexOf("@class"));
            return LdiClassUtil.forName(className);
        }
        if (exp.startsWith("@") && exp.contains("@")) {
            String className = exp.substring("@".length(), exp.lastIndexOf("@"));
            String rear = exp.substring(exp.lastIndexOf("@") + "@".length());
            Class<?> clazz = LdiClassUtil.forName(className);
            if (rear.endsWith("()")) {
                String methodName = rear.substring(0, rear.lastIndexOf("()"));
                Method method = LdiReflectionUtil.getMethod(clazz, methodName, null);
                return LdiReflectionUtil.invoke(method, null, null);
            }
            Field field = LdiReflectionUtil.getField(clazz, rear);
            return LdiReflectionUtil.getValue(field, null);
        }
        return null;
    }

    protected Object resolveSimpleComponent(String exp, LaContainer container, Class<?> resultType) {
        if (!LdiSrl.containsAny(exp, ".", ",", "'", "\"", "@", "#") && container.hasComponentDef(exp)) {
            return container.getComponent(exp);
        }
        return null;
    }

    protected Object resolveExistsResource(String exp, LaContainer container, Class<?> resultType) {
        String path;
        if (exp.startsWith(EXISTS_BEGIN) && exp.endsWith("')") && !(path = exp.substring(EXISTS_BEGIN.length(), exp.lastIndexOf("')"))).contains("'")) {
            return LdiResourceUtil.exists(path);
        }
        return null;
    }

    protected Object resolveProviderConfig(String exp, LaContainer container, Class<?> resultType) {
        boolean noArgMethod = this.isProviderConfigNoArgMethod(exp);
        boolean orDefaultMethod = this.isProviderConfigOrDefaultMethod(exp);
        if (noArgMethod || orDefaultMethod) {
            String[] tokens;
            if (orDefaultMethod && LdiSrl.count(exp, "\"") == 2) {
                List<String> splitList = LdiSrl.splitList(exp, "\"");
                String savedDotKey = LdiSrl.replace(splitList.get(1), ".", "$$dot$$");
                exp = splitList.get(0) + "\"" + savedDotKey + "\"" + splitList.get(2);
            }
            if ((tokens = exp.split("\\.")).length > 1) {
                Object component = null;
                BeanDesc beanDesc = null;
                for (String prop : tokens) {
                    if (prop.endsWith("()")) {
                        if (component == null) break;
                        String methodName = prop.substring(0, prop.length() - "()".length());
                        if ((component = beanDesc.invoke(component, methodName, null)) == null) {
                            component = NULL_RETURN;
                            break;
                        }
                        beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
                        continue;
                    }
                    if (prop.startsWith("getOrDefault(\"") && prop.endsWith("\", null)")) {
                        if (component == null) break;
                        String key = LdiSrl.extractScopeFirst(prop, "getOrDefault(\"", "\", null)").getContent();
                        String plainDotKey = LdiSrl.replace(key, "$$dot$$", ".");
                        if ((component = beanDesc.invoke(component, "getOrDefault", new Object[]{plainDotKey, null})) == null) {
                            component = NULL_RETURN;
                            break;
                        }
                        beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
                        continue;
                    }
                    if (beanDesc == null) {
                        if (!container.hasComponentDef(prop)) break;
                        component = container.getComponent(prop);
                        beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
                        continue;
                    }
                    PropertyDesc propertyDesc = beanDesc.getPropertyDesc(prop);
                    if (propertyDesc == null) break;
                    component = propertyDesc.getValue(component);
                    beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
                }
                if (component != null) {
                    return component;
                }
            }
        }
        return null;
    }

    protected boolean isProviderConfigNoArgMethod(String exp) {
        return exp.startsWith("provider.config().get") && exp.endsWith("()") && !exp.contains("\"");
    }

    protected boolean isProviderConfigOrDefaultMethod(String exp) {
        return exp.startsWith("provider.config().getOrDefault") && exp.endsWith("\", null)");
    }

    protected Object resolveComponentList(String exp, LaContainer container, Class<?> resultType) {
        if (!exp.contains("\"") && !exp.contains("'") && exp.startsWith("[") && exp.endsWith("]")) {
            String listContents = exp.substring(1, exp.length() - 1);
            String[] elements = LdiStringUtil.split(listContents, ",");
            boolean compAry = false;
            for (String comp : elements) {
                if (LdiStringUtil.isNumber(comp)) continue;
                compAry = true;
                break;
            }
            if (compAry) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                for (String comp : elements) {
                    Object component = container.getComponent(comp.trim());
                    resultList.add(component);
                }
                return castResolver.convertListTo(exp, container, resultType, resultList);
            }
        }
        return null;
    }
}

