/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.dixml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.conbuilder.impl.AbstractLaContainerBuilder;
import org.lastaflute.di.core.factory.dixml.DiXmlTagHandlerRule;
import org.lastaflute.di.core.factory.dixml.exception.DiXmlParseFailureException;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.helper.xml.SaxHandler;
import org.lastaflute.di.helper.xml.SaxHandlerParser;
import org.lastaflute.di.helper.xml.TagHandlerContext;
import org.lastaflute.di.util.LdiInputStreamUtil;
import org.lastaflute.di.util.LdiSAXParserFactoryUtil;

public class DiXmlLaContainerBuilder
extends AbstractLaContainerBuilder {
    public static final String PUBLIC_ID10 = "-//DBFLUTE//DTD LastaDi 1.0//EN";
    public static final String DTD_PATH10 = "org/lastaflute/di/lastadi10.dtd";
    protected DiXmlTagHandlerRule rule = new DiXmlTagHandlerRule();
    protected final Map<String, String> dtdMap = new HashMap<String, String>();

    public DiXmlLaContainerBuilder() {
        this.dtdMap.put(PUBLIC_ID10, DTD_PATH10);
    }

    public void addDtd(String publicId, String systemId) {
        this.dtdMap.put(publicId, systemId);
    }

    public void clearDtd() {
        this.dtdMap.clear();
    }

    @Override
    public LaContainer build(String path) {
        return this.parse(null, path);
    }

    @Override
    public LaContainer include(LaContainer parent, String path) {
        LaContainer child = this.parse(parent, path);
        parent.include(child);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LaContainer parse(LaContainer parent, String path) {
        SaxHandlerParser parser = this.createSaxHandlerParser(parent, path);
        InputStream is = this.findDiXmlInputStream(parent, path);
        try {
            LaContainer laContainer = (LaContainer)parser.parse(is, path);
            return laContainer;
        }
        catch (Throwable cause) {
            if (cause instanceof DiXmlParseFailureException) {
                throw (DiXmlParseFailureException)cause;
            }
            this.throwDependencyXmlParseFailureException(parent, path, cause);
            LaContainer laContainer = null;
            return laContainer;
        }
        finally {
            LdiInputStreamUtil.close(is);
        }
    }

    protected void throwDependencyXmlParseFailureException(LaContainer parent, String path, Throwable cause) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to parse the dependency XML.");
        br.addItem("Dependency XML");
        br.addElement(path + (parent != null ? " included by " + parent.getPath() : ""));
        String msg = br.buildExceptionMessage();
        throw new DiXmlParseFailureException(msg, cause);
    }

    protected SaxHandlerParser createSaxHandlerParser(LaContainer parent, String path) {
        SAXParserFactory factory = LdiSAXParserFactoryUtil.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        SAXParser saxParser = LdiSAXParserFactoryUtil.newSAXParser(factory);
        SaxHandler handler = new SaxHandler(this.rule);
        for (Map.Entry<String, String> entry : this.dtdMap.entrySet()) {
            String publicId = entry.getKey();
            String systemId = entry.getValue();
            handler.registerDtdPath(publicId, systemId);
        }
        TagHandlerContext ctx = handler.getTagHandlerContext();
        ctx.addParameter("parent", parent);
        ctx.addParameter("path", path);
        return new SaxHandlerParser(handler, saxParser);
    }

    public DiXmlTagHandlerRule getRule() {
        return this.rule;
    }

    public void setRule(DiXmlTagHandlerRule rule) {
        this.rule = rule;
    }
}

