/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.dixml.taghandler;

import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.expression.Expression;
import org.lastaflute.di.core.expression.ScriptingExpression;
import org.lastaflute.di.core.factory.LaContainerFactory;
import org.lastaflute.di.core.factory.dixml.exception.TagAttributeNotDefinedRuntimeException;
import org.lastaflute.di.core.factory.dixml.taghandler.AbstractTagHandler;
import org.lastaflute.di.core.smart.SmartDeployMode;
import org.lastaflute.di.helper.xml.TagHandlerContext;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiStringUtil;
import org.xml.sax.Attributes;

public class IncludeTagHandler
extends AbstractTagHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void start(TagHandlerContext context, Attributes attributes) {
        String path = attributes.getValue("path");
        if (path == null) {
            throw new TagAttributeNotDefinedRuntimeException("include", "path");
        }
        LaContainer container = (LaContainer)context.peek();
        String condition = attributes.getValue("condition");
        if (!LdiStringUtil.isEmpty(condition)) {
            Map<String, String> contextMap = this.prepareContextMap();
            Expression expression = this.createExpression(context, condition, () -> new ScriptingExpression(exp -> this.resolveVariableIfNeeds(condition, path, (ScriptingExpression)exp)));
            Object evaluated = expression.evaluate(contextMap, container, Boolean.TYPE);
            if (!(evaluated instanceof Boolean)) {
                throw new IllegalStateException("condition:" + condition);
            }
            if (!((Boolean)evaluated).booleanValue()) {
                return;
            }
        }
        LaContainerFactory.include(container, path);
    }

    protected Map<String, String> prepareContextMap() {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("SMART", SmartDeployMode.getValue().code());
        return map;
    }

    protected String resolveVariableIfNeeds(String expr, String path, ScriptingExpression expression) {
        if (expr == null) {
            return null;
        }
        return this.doResolveShortExistsIfNeeds(this.doResolvePathExpIfNeeds(expr, path, expression), expression);
    }

    protected String doResolvePathExpIfNeeds(String expr, String path, ScriptingExpression expression) {
        String pathExp = "#path";
        return expr.contains("#path") ? expr.replace("#path", path) : expr;
    }

    protected String doResolveShortExistsIfNeeds(String expr, ScriptingExpression expression) {
        String shortExists = "#exists(";
        if (expr.contains("#exists(")) {
            String reference = expression.resolveStaticMethodReference(LdiResourceUtil.class, "exists");
            return expr.replace("#exists(", reference + "(");
        }
        return expr;
    }
}

