/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.util.ConcurrentMapFactory;

public class LdiMapUtil {
    protected static final MapFactory factory = LdiMapUtil.getMapFactory();

    public static <KEY, VALUE> Map<KEY, VALUE> createHashMap() {
        return factory.create();
    }

    public static <KEY, VALUE> Map<KEY, VALUE> createHashMap(int initialCapacity) {
        return factory.create(initialCapacity);
    }

    public static <KEY, VALUE> Map<KEY, VALUE> createHashMap(int initialCapacity, float loadFactor) {
        return factory.create(initialCapacity, loadFactor);
    }

    protected static MapFactory getMapFactory() {
        try {
            Class<ConcurrentMapFactory> clazz = ConcurrentMapFactory.class;
            return (MapFactory)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return new SynchronizedMapFactory();
        }
    }

    public static class SynchronizedMapFactory
    implements MapFactory {
        @Override
        public <KEY, VALUE> Map<KEY, VALUE> create() {
            return Collections.synchronizedMap(new HashMap());
        }

        @Override
        public <KEY, VALUE> Map<KEY, VALUE> create(int initialCapacity) {
            return Collections.synchronizedMap(new HashMap(initialCapacity));
        }

        @Override
        public <KEY, VALUE> Map<KEY, VALUE> create(int initialCapacity, float loadFactor) {
            return Collections.synchronizedMap(new HashMap(initialCapacity, loadFactor));
        }
    }

    static interface MapFactory {
        public <KEY, VALUE> Map<KEY, VALUE> create();

        public <KEY, VALUE> Map<KEY, VALUE> create(int var1);

        public <KEY, VALUE> Map<KEY, VALUE> create(int var1, float var2);
    }
}

