/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.dbcp.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.lastaflute.jta.core.xa.DefaultXAResource;
import org.lastaflute.jta.dbcp.DBXAResource;
import org.lastaflute.jta.exception.LjtXAException;

public class DBXAResourceImpl
extends DefaultXAResource
implements DBXAResource {
    protected final Connection connection;

    public DBXAResourceImpl(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    protected void doBegin(Xid xid) throws XAException {
        try {
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new LjtXAException("Failed to set auto-commit: xid=" + xid, e);
        }
    }

    @Override
    protected void doCommit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new LjtXAException("Failed to commit: xid=" + xid, e);
        }
    }

    @Override
    protected int doPrepare(Xid xid) throws XAException {
        try {
            if (this.connection.isClosed()) {
                return 3;
            }
            return 0;
        }
        catch (SQLException e) {
            throw new LjtXAException("Failed to determine connecton closed or not: xid=" + xid, e);
        }
    }

    @Override
    protected void doRollback(Xid xid) throws XAException {
        try {
            this.connection.rollback();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new LjtXAException("Failed to roll-back: xid=" + xid, e);
        }
    }
}

