/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.interceptors;

import java.lang.reflect.Method;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.aop.frame.MethodInterceptor;
import org.lastaflute.di.core.aop.frame.MethodInvocation;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.util.LdiMethodUtil;

public class HotAwareDelegateInterceptor
implements MethodInterceptor {
    protected LaContainer container;
    protected String targetName;

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.targetName == null) {
            throw new EmptyRuntimeException("targetName");
        }
        Method method = invocation.getMethod();
        if (!LdiMethodUtil.isAbstract(method)) {
            return invocation.proceed();
        }
        Object target = this.container.getComponent(this.targetName);
        return LdiMethodUtil.invoke(method, target, invocation.getArguments());
    }

    public void setContainer(LaContainer container) {
        this.container = container.getRoot();
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }
}

