/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.core.aop.frame.MethodInvocation;
import org.lastaflute.di.core.aop.interceptors.AbstractInterceptor;

public class MockInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 6438214603532050462L;
    private final Map<String, Object> returnValueMap = new HashMap<String, Object>();
    private final Map<String, Throwable> throwableMap = new HashMap<String, Throwable>();
    private final Map<String, Boolean> invokedMap = new HashMap<String, Boolean>();
    private final Map<String, Object[]> argsMap = new HashMap<String, Object[]>();

    public MockInterceptor() {
    }

    public MockInterceptor(Object value) {
        this.setReturnValue(value);
    }

    public boolean isInvoked(String methodName) {
        return this.invokedMap.containsKey(methodName);
    }

    public Object[] getArgs(String methodName) {
        return this.argsMap.get(methodName);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        this.invokedMap.put(invocation.getMethod().getName(), Boolean.TRUE);
        this.argsMap.put(methodName, invocation.getArguments());
        if (this.throwableMap.containsKey(methodName)) {
            throw this.throwableMap.get(methodName);
        }
        if (this.throwableMap.containsKey(null)) {
            throw this.throwableMap.get(null);
        }
        if (this.returnValueMap.containsKey(methodName)) {
            return this.returnValueMap.get(methodName);
        }
        return this.returnValueMap.get(null);
    }

    public void setReturnValue(Object returnValue) {
        this.setReturnValue(null, returnValue);
    }

    public void setReturnValue(String methodName, Object returnValue) {
        this.returnValueMap.put(methodName, returnValue);
    }

    public void setThrowable(Throwable throwable) {
        this.setThrowable(null, throwable);
    }

    public void setThrowable(String methodName, Throwable throwable) {
        this.throwableMap.put(methodName, throwable);
    }
}

