/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.intertype;

import java.util.Arrays;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.lastaflute.di.core.aop.InterType;
import org.lastaflute.di.core.util.ClassPoolUtil;
import org.lastaflute.di.exception.CannotCompileRuntimeException;
import org.lastaflute.di.exception.NotFoundRuntimeException;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;

public abstract class AbstractInterType
implements InterType {
    public static final String COMPONENT = "instance = prototype";
    protected Class<?> targetClass;
    protected CtClass enhancedClass;
    protected ClassPool classPool;

    @Override
    public void introduce(Class<?> targetClass, CtClass enhancedClass) {
        this.targetClass = targetClass;
        this.enhancedClass = enhancedClass;
        this.classPool = enhancedClass.getClassPool();
        try {
            this.introduce();
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot introduce the inter-type by Javassist.");
            br.addItem("targetClass");
            br.addElement(targetClass);
            br.addItem("enhancedClass");
            br.addElement(enhancedClass);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
        finally {
            this.targetClass = null;
            this.enhancedClass = null;
            this.classPool = null;
        }
    }

    protected abstract void introduce() throws CannotCompileException, NotFoundException;

    protected void addInterface(Class<?> clazz) {
        this.enhancedClass.addInterface(this.toCtClass(clazz));
    }

    protected void addField(Class<?> type, String name) {
        this.addField(2, type, name);
    }

    protected void addField(Class<?> type, String name, String init) {
        this.addField(2, type, name, init);
    }

    protected void addStaticField(Class<?> type, String name) {
        this.addStaticField(2, type, name);
    }

    protected void addStaticField(Class<?> type, String name, String init) {
        this.addStaticField(2, type, name, init);
    }

    protected void addConstant(Class<?> type, String name, String init) {
        this.addStaticField(17, type, name, init);
    }

    protected void addStaticField(int modifiers, Class<?> type, String name) {
        this.addField(8 | modifiers, type, name);
    }

    protected void addStaticField(int modifiers, Class<?> type, String name, String init) {
        this.addField(8 | modifiers, type, name, init);
    }

    protected void addStaticField(int modifiers, Class<?> type, String name, CtField.Initializer init) {
        this.addField(8 | modifiers, type, name, init);
    }

    protected void addField(int modifiers, Class<?> type, String name) {
        try {
            CtField field = new CtField(this.toCtClass(type), name, this.enhancedClass);
            field.setModifiers(modifiers);
            this.enhancedClass.addField(field);
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot add the field to the class by Javassist.");
            br.addItem("enhancedClass");
            br.addElement(this.enhancedClass);
            br.addItem("Field Modifiers");
            br.addElement(modifiers);
            br.addItem("Field Type");
            br.addElement(type);
            br.addItem("Field Name");
            br.addElement(name);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected void addField(String src) {
        try {
            this.enhancedClass.addField(CtField.make((String)src, (CtClass)this.enhancedClass));
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot add the field to the class by Javassist.");
            br.addItem("enhancedClass");
            br.addElement(this.enhancedClass);
            br.addItem("Field Source");
            br.addElement(src);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected void addField(int modifiers, Class<?> type, String name, String init) {
        try {
            CtField field = new CtField(this.toCtClass(type), name, this.enhancedClass);
            field.setModifiers(modifiers);
            this.enhancedClass.addField(field, init);
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot add the field to the class by Javassist.");
            br.addItem("enhancedClass");
            br.addElement(this.enhancedClass);
            br.addItem("Field Modifiers");
            br.addElement(modifiers);
            br.addItem("Field Type");
            br.addElement(type);
            br.addItem("Field Name");
            br.addElement(name);
            br.addItem("Field DefaultValue");
            br.addElement(init);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected void addField(int modifiers, Class<?> type, String name, CtField.Initializer init) {
        try {
            CtField field = new CtField(this.toCtClass(type), name, this.enhancedClass);
            field.setModifiers(modifiers);
            this.enhancedClass.addField(field, init);
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot add the field to the class by Javassist.");
            br.addItem("enhancedClass");
            br.addElement(this.enhancedClass);
            br.addItem("Field Modifiers");
            br.addElement(modifiers);
            br.addItem("Field Type");
            br.addElement(type);
            br.addItem("Field Name");
            br.addElement(name);
            br.addItem("Field DefaultValue Initializer");
            br.addElement(init);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected void addMethod(String name, String src) {
        this.addMethod(1, Void.TYPE, name, null, null, src);
    }

    protected void addMethod(String name, Class<?>[] paramTypes, String src) {
        this.addMethod(1, Void.TYPE, name, paramTypes, null, src);
    }

    protected void addMethod(String name, Class<?>[] paramTypes, Class<?>[] exceptionTypes, String src) {
        this.addMethod(1, Void.TYPE, name, paramTypes, exceptionTypes, src);
    }

    protected void addMethod(Class<?> returnType, String name, String src) {
        this.addMethod(1, returnType, name, null, null, src);
    }

    protected void addMethod(Class<?> returnType, String name, Class<?>[] paramTypes, String src) {
        this.addMethod(1, returnType, name, paramTypes, null, src);
    }

    protected void addMethod(Class<?> returnType, String name, Class<?>[] paramTypes, Class<?>[] exceptionTypes, String src) {
        this.addMethod(1, returnType, name, paramTypes, exceptionTypes, src);
    }

    protected void addStaticMethod(String name, String src) {
        this.addMethod(9, Void.TYPE, name, null, null, src);
    }

    protected void addStaticMethod(String name, Class<?>[] paramTypes, String src) {
        this.addMethod(9, Void.TYPE, name, paramTypes, null, src);
    }

    protected void addStaticMethod(String name, Class<?>[] paramTypes, Class<?>[] exceptionTypes, String src) {
        this.addMethod(9, Void.TYPE, name, paramTypes, exceptionTypes, src);
    }

    protected void addStaticMethod(Class<?> returnType, String name, String src) {
        this.addMethod(9, returnType, name, null, null, src);
    }

    protected void addStaticMethod(Class<?> returnType, String name, Class<?>[] paramTypes, String src) {
        this.addMethod(9, returnType, name, paramTypes, null, src);
    }

    protected void addStaticMethod(Class<?> returnType, String name, Class<?>[] paramTypes, Class<?>[] exceptionTypes, String src) {
        this.addMethod(9, returnType, name, paramTypes, exceptionTypes, src);
    }

    protected void addMethod(int modifiers, Class<?> returnType, String name, Class<?>[] paramTypes, Class<?>[] exceptionTypes, String src) {
        try {
            CtClass returnCtClass = this.toCtClass(returnType);
            CtClass[] paramCtClassArray = this.toCtClassArray(paramTypes);
            CtClass[] expCtClassArray = this.toCtClassArray(exceptionTypes);
            CtMethod ctMethod = CtNewMethod.make((int)modifiers, (CtClass)returnCtClass, (String)name, (CtClass[])paramCtClassArray, (CtClass[])expCtClassArray, (String)src, (CtClass)this.enhancedClass);
            this.enhancedClass.addMethod(ctMethod);
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot add the method to the class by Javassist.");
            br.addItem("enhancedClass");
            br.addElement(this.enhancedClass);
            br.addItem("Method Modifiers");
            br.addElement(modifiers);
            br.addItem("Return Type");
            br.addElement(returnType);
            br.addItem("Method Name");
            br.addElement(name);
            br.addItem("Parameter Types");
            br.addElement(paramTypes != null ? Arrays.asList(paramTypes) : null);
            br.addItem("Exception Types");
            br.addElement(exceptionTypes != null ? Arrays.asList(exceptionTypes) : null);
            br.addItem("Method Source");
            br.addElement(src);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected void addMethod(String src) {
        try {
            this.enhancedClass.addMethod(CtNewMethod.make((String)src, (CtClass)this.enhancedClass));
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot add the method to the class by Javassist.");
            br.addItem("enhancedClass");
            br.addElement(this.enhancedClass);
            br.addElement(src);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected CtClass toCtClass(Class<?> clazz) {
        return ClassPoolUtil.toCtClass(this.classPool, clazz);
    }

    protected CtClass[] toCtClassArray(Class<?>[] classes) {
        return ClassPoolUtil.toCtClassArray(this.classPool, classes);
    }

    protected Class<?> getTargetClass() {
        return this.targetClass;
    }

    protected CtClass getEnhancedClass() {
        return this.enhancedClass;
    }

    protected ClassPool getClassPool() {
        return this.classPool;
    }
}

