/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.javassist;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.LinkedList;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.lastaflute.di.core.aop.intertype.PropertyInterType;
import org.lastaflute.di.core.aop.javassist.AspectWeaver;
import org.lastaflute.di.core.aop.javassist.BytecodeClassDefiner;
import org.lastaflute.di.core.exception.CannotDefineClassException;
import org.lastaflute.di.core.util.ClassPoolUtil;
import org.lastaflute.di.exception.CannotCompileRuntimeException;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.exception.IllegalAccessRuntimeException;
import org.lastaflute.di.exception.InvocationTargetRuntimeException;
import org.lastaflute.di.exception.NoSuchMethodRuntimeException;
import org.lastaflute.di.exception.NotFoundRuntimeException;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.tiger.LdiReflectionUtil;

public class AbstractGenerator {
    private static final LaLogger logger = LaLogger.getLogger(PropertyInterType.class);
    protected static final String DEFINE_CLASS_METHOD_NAME = "defineClass";
    protected static final ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(AbstractGenerator.createAspectWeaverPrivilegedAction());
    protected static final Method defineClassMethod = (Method)AccessController.doPrivileged(AbstractGenerator.createDefineClassPrivilegedAction());
    protected static final Method privateLookupInMethod = AbstractGenerator.prepareMethodHandlesPrivateLookupInMethod();
    protected static final Method lookupDefineClassMethod = AbstractGenerator.prepareMethodHandlesLookupDefineClassMethod();
    protected final ClassPool classPool;
    protected final Class<?> targetClass;

    protected static PrivilegedAction<Object> createAspectWeaverPrivilegedAction() {
        return new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return AspectWeaver.class.getProtectionDomain();
            }
        };
    }

    protected static PrivilegedAction<Object> createDefineClassPrivilegedAction() {
        return new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return AbstractGenerator.prepareClassLoaderDefineClassMethod();
            }
        };
    }

    protected static Method prepareClassLoaderDefineClassMethod() {
        Method method;
        Class<ClassLoader> typeAsResource = ClassLoader.class;
        String defineClassMethodName = DEFINE_CLASS_METHOD_NAME;
        Class[] paramTypes = new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class};
        try {
            Class<?> typeByCurrentContext = LdiClassUtil.forName(typeAsResource.getName());
            method = typeByCurrentContext.getDeclaredMethod(DEFINE_CLASS_METHOD_NAME, paramTypes);
            try {
                method.setAccessible(true);
                logger.debug("ClassLoader@defineClass() can be called for AOP");
            }
            catch (RuntimeException e) {
                String fqcn = e.getClass().getName();
                if (!"java.lang.reflect.InaccessibleObjectException".equals(fqcn)) {
                    throw e;
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(typeAsResource, DEFINE_CLASS_METHOD_NAME, paramTypes, e);
        }
        return method;
    }

    protected static Method prepareMethodHandlesPrivateLookupInMethod() {
        Method method;
        Class[] argTypes = new Class[]{Class.class, MethodHandles.Lookup.class};
        try {
            method = LdiReflectionUtil.getMethod(MethodHandles.class, "privateLookupIn", argTypes);
        }
        catch (NoSuchMethodRuntimeException ignored) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("MethodHandles@privateLookupIn() can be called for AOP: method=" + method);
        }
        return method;
    }

    protected static Method prepareMethodHandlesLookupDefineClassMethod() {
        Method method;
        Class[] argTypes = new Class[]{byte[].class};
        try {
            method = LdiReflectionUtil.getMethod(MethodHandles.Lookup.class, DEFINE_CLASS_METHOD_NAME, argTypes);
        }
        catch (NoSuchMethodRuntimeException ignored) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("MethodHandles.Lookup@defineClass() can be called for AOP: method=" + method);
        }
        return method;
    }

    protected AbstractGenerator(ClassPool classPool, Class<?> targetClass) {
        this.classPool = classPool;
        this.targetClass = targetClass;
    }

    public Class<?> toClass(ClassLoader classLoader, CtClass ctClass) {
        Class<?> enhancedClass = null;
        LinkedList<Throwable> currentCauseList = new LinkedList<Throwable>();
        if (defineClassMethod.isAccessible()) {
            try {
                enhancedClass = this.invokeClassLoaderDefineClass(classLoader, ctClass);
            }
            catch (Throwable cause) {
                currentCauseList.add(cause);
            }
        }
        if (enhancedClass != null) {
            return enhancedClass;
        }
        if (this.isInterfaceDefineEnabled()) {
            if (classLoader instanceof BytecodeClassDefiner) {
                try {
                    enhancedClass = this.callInterfaceDefineClass((BytecodeClassDefiner)((Object)classLoader), ctClass);
                }
                catch (Throwable cause) {
                    currentCauseList.add(cause);
                }
            }
            if (enhancedClass != null) {
                return enhancedClass;
            }
        }
        try {
            enhancedClass = this.invokeMethodHandlesDefineClass(classLoader, ctClass);
        }
        catch (Throwable cause) {
            currentCauseList.add(cause);
        }
        if (enhancedClass != null) {
            return enhancedClass;
        }
        String giveupMessage = this.buildCannotDefineClassMessage(classLoader, ctClass, currentCauseList);
        if (currentCauseList.isEmpty()) {
            throw new CannotDefineClassException(giveupMessage);
        }
        throw new CannotDefineClassException(giveupMessage, currentCauseList.getLast());
    }

    protected Class<?> invokeClassLoaderDefineClass(ClassLoader classLoader, CtClass ctClass) {
        try {
            String className = ctClass.getName();
            byte[] bytecode = this.convertCtClassToBytecode(ctClass);
            Integer off = 0;
            Integer len = bytecode.length;
            Object[] args = new Object[]{className, bytecode, off, len, protectionDomain};
            return (Class)defineClassMethod.invoke((Object)classLoader, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(ClassLoader.class, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(ClassLoader.class, e);
        }
    }

    protected boolean isInterfaceDefineEnabled() {
        return false;
    }

    protected Class<?> callInterfaceDefineClass(BytecodeClassDefiner definer, CtClass ctClass) {
        String className = ctClass.getName();
        byte[] bytecode = this.convertCtClassToBytecode(ctClass);
        Integer off = 0;
        Integer len = bytecode.length;
        return definer.defineBytecodeClass(className, bytecode, off, len, protectionDomain);
    }

    protected Class<?> invokeMethodHandlesDefineClass(ClassLoader classLoader, CtClass ctClass) {
        if (privateLookupInMethod == null) {
            return null;
        }
        MethodHandles.Lookup lookup = (MethodHandles.Lookup)LdiReflectionUtil.invoke(privateLookupInMethod, null, this.targetClass, MethodHandles.lookup());
        if (lookupDefineClassMethod == null) {
            String msg = "privateLookupInMethod exists but lookupDefineClassMethod is null: " + privateLookupInMethod;
            throw new IllegalStateException(msg);
        }
        byte[] bytecode = this.convertCtClassToBytecode(ctClass);
        return (Class)LdiReflectionUtil.invoke(lookupDefineClassMethod, lookup, new Object[]{bytecode});
    }

    protected byte[] convertCtClassToBytecode(CtClass ctClass) {
        byte[] bytecode;
        try {
            bytecode = ctClass.toBytecode();
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot convert the class to bytecode by Javassist.");
            br.addItem("Target Class");
            br.addElement(this.targetClass);
            br.addItem("CtClass");
            br.addElement(ctClass);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return bytecode;
    }

    protected String buildCannotDefineClassMessage(ClassLoader classLoader, CtClass ctClass, LinkedList<Throwable> currentCauseList) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Cannot define the class to class loader.");
        br.addItem("Advice");
        br.addElement("To define the class to class loader is required to enhance class.");
        br.addElement("But both ClassLoader way and MethodHandles way don't work in your environment.");
        br.addElement(" ClassLoader way: call ClassLoader@defineClass() by reflection private-access.");
        br.addElement(" MethodHandles way: call MethodHandles.Lookup@defineClass() since java9.");
        br.addElement("");
        br.addElement("The private-access to java.lang is disabled as default since java16");
        br.addElement("so MethodHandles way is implemented as secondary.");
        br.addElement("But maybe the way does not always work...");
        br.addElement("");
        br.addElement("java8: no problem, ClassLoader way");
        br.addElement("java9~15: basically no problem, ClassLoader way (permitted as default)");
        br.addElement("java16~: MethodHandles way or ClassLoader way by option");
        br.addElement("");
        br.addElement("If you MethodHandles way does not work in your environment (since java16)");
        br.addElement("consider 'add-opens' option of java command for ClassLoader way.");
        br.addItem("ClassLoader");
        br.addElement(classLoader);
        br.addItem("CtClass");
        br.addElement(ctClass);
        if (!currentCauseList.isEmpty()) {
            br.addItem("Gradual Cause");
            for (Throwable cause : currentCauseList) {
                br.addElement(cause.getClass().getName());
            }
        }
        return br.buildExceptionMessage();
    }

    protected CtClass toCtClass(Class<?> clazz) {
        return ClassPoolUtil.toCtClass(this.classPool, clazz);
    }

    protected CtClass toCtClass(String className) {
        return ClassPoolUtil.toCtClass(this.classPool, className);
    }

    protected CtClass[] toCtClassArray(String[] classNames) {
        return ClassPoolUtil.toCtClassArray(this.classPool, classNames);
    }

    protected CtClass[] toCtClassArray(Class<?>[] classes) {
        return ClassPoolUtil.toCtClassArray(this.classPool, classes);
    }

    protected CtClass createCtClass(String name) {
        return ClassPoolUtil.createCtClass(this.classPool, name);
    }

    protected CtClass createCtClass(String name, Class<?> superClass) {
        return ClassPoolUtil.createCtClass(this.classPool, name, superClass);
    }

    protected CtClass createCtClass(String name, CtClass superClass) {
        return ClassPoolUtil.createCtClass(this.classPool, name, superClass);
    }

    protected CtClass getAndRenameCtClass(Class<?> orgClass, String newName) {
        return this.getAndRenameCtClass(LdiClassUtil.getSimpleClassName(orgClass), newName);
    }

    protected CtClass getAndRenameCtClass(String orgName, String newName) {
        try {
            return this.classPool.getAndRename(orgName, newName);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    protected void setInterface(CtClass clazz, Class<?> interfaceType) {
        clazz.setInterfaces(new CtClass[]{this.toCtClass(interfaceType)});
    }

    protected void setInterfaces(CtClass clazz, Class<?>[] interfaces) {
        clazz.setInterfaces(this.toCtClassArray(interfaces));
    }

    protected CtConstructor createDefaultConstructor(Class<?> clazz) {
        return this.createDefaultConstructor(this.toCtClass(clazz));
    }

    protected CtConstructor createDefaultConstructor(CtClass clazz) {
        try {
            CtConstructor ctConstructor = CtNewConstructor.defaultConstructor((CtClass)clazz);
            clazz.addConstructor(ctConstructor);
            return ctConstructor;
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot make or add the default constructor to the class by Javassist.");
            br.addItem("CtClass");
            br.addElement(clazz);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected CtConstructor createConstructor(CtClass clazz, Constructor<?> constructor) {
        return this.createConstructor(clazz, this.toCtClassArray(constructor.getParameterTypes()), this.toCtClassArray(constructor.getExceptionTypes()));
    }

    protected CtConstructor createConstructor(CtClass clazz, CtClass[] parameterTypes, CtClass[] exceptionTypes) {
        try {
            CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])parameterTypes, (CtClass[])exceptionTypes, (CtClass)clazz);
            clazz.addConstructor(ctConstructor);
            return ctConstructor;
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot make or add the constructor to the class by Javassist.");
            br.addItem("CtClass");
            br.addElement(clazz);
            br.addItem("parameterTypes");
            br.addElement(parameterTypes != null ? Arrays.asList(parameterTypes) : null);
            br.addItem("exceptionTypes");
            br.addElement(exceptionTypes != null ? Arrays.asList(exceptionTypes) : null);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected CtMethod getDeclaredMethod(CtClass clazz, String name, CtClass[] argTypes) {
        try {
            return clazz.getDeclaredMethod(name, argTypes);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    protected CtMethod createMethod(CtClass clazz, String src) {
        try {
            CtMethod ctMethod = CtNewMethod.make((String)src, (CtClass)clazz);
            clazz.addMethod(ctMethod);
            return ctMethod;
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot make or add the method to the class by Javassist.");
            br.addItem("CtClass");
            br.addElement(clazz);
            br.addItem("Method Source");
            br.addElement(src);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected CtMethod createMethod(CtClass clazz, Method method, String body) {
        return this.createMethod(clazz, method.getModifiers(), method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), body);
    }

    protected CtMethod createMethod(CtClass clazz, int modifier, Class<?> returnType, String methodName, Class<?>[] parameterTypes, Class<?>[] exceptionTypes, String body) {
        int modifiers = modifier & 0xFFFFFAFF;
        CtClass returnCtClass = this.toCtClass(returnType);
        CtClass[] paramCtClasses = this.toCtClassArray(parameterTypes);
        CtClass[] expCtClasses = this.toCtClassArray(exceptionTypes);
        try {
            CtMethod ctMethod = CtNewMethod.make((int)modifiers, (CtClass)returnCtClass, (String)methodName, (CtClass[])paramCtClasses, (CtClass[])expCtClasses, (String)body, (CtClass)clazz);
            clazz.addMethod(ctMethod);
            return ctMethod;
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot make or add the method to the class by Javassist.");
            br.addItem("CtClass");
            br.addElement(clazz);
            br.addItem("Modifiers");
            br.addElement(modifiers);
            br.addItem("Return Type");
            br.addElement(returnType);
            br.addItem("Method Name");
            br.addElement(methodName);
            br.addItem("Parameter Types");
            br.addElement(parameterTypes != null ? Arrays.asList(parameterTypes) : null);
            br.addItem("Exception Types");
            br.addElement(exceptionTypes != null ? Arrays.asList(exceptionTypes) : null);
            br.addItem("Method Body");
            br.addElement(body);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected void setMethodBody(CtMethod method, String src) {
        try {
            method.setBody(src);
        }
        catch (CannotCompileException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot set the body to the method by Javassist.");
            br.addItem("CtMethod");
            br.addElement(method);
            br.addItem("Method Source");
            br.addElement(src);
            throw new CannotCompileRuntimeException(br.buildExceptionMessage(), e);
        }
    }

    protected static String fromObject(Class<?> type, String expr) {
        if (type.equals(Void.TYPE) || type.equals(Object.class)) {
            return expr;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Character.TYPE)) {
            Class<?> wrapper = LdiClassUtil.getWrapperClass(type);
            return "((" + wrapper.getName() + ") " + expr + ")." + type.getName() + "Value()";
        }
        if (type.isPrimitive()) {
            return "((java.lang.Number) " + expr + ")." + type.getName() + "Value()";
        }
        return "(" + LdiClassUtil.getSimpleClassName(type) + ") " + expr;
    }

    protected static String toObject(Class<?> type, String expr) {
        if (type.isPrimitive()) {
            Class<?> wrapper = LdiClassUtil.getWrapperClass(type);
            return "new " + wrapper.getName() + "(" + expr + ")";
        }
        return expr;
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }
}

