/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.javassist;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import org.lastaflute.di.core.aop.InterType;
import org.lastaflute.di.core.aop.frame.MethodInterceptor;
import org.lastaflute.di.core.aop.javassist.EnhancedClassGenerator;
import org.lastaflute.di.core.aop.javassist.MethodInvocationClassGenerator;
import org.lastaflute.di.core.util.ClassPoolUtil;
import org.lastaflute.di.exception.NoSuchFieldRuntimeException;
import org.lastaflute.di.util.LdiClassLoaderUtil;
import org.lastaflute.di.util.LdiFieldUtil;
import org.lastaflute.di.util.LdiMethodUtil;
import org.lastaflute.di.util.LdiSrl;

public class AspectWeaver {
    public static final String PREFIX_ENHANCED_CLASS = "$$";
    public static final String SUFFIX_ENHANCED_CLASS = "$$EnhancedByLastaDi$$";
    public static final String SUFFIX_METHOD_INVOCATION_CLASS = "$$MethodInvocation$$";
    public static final String SUFFIX_INVOKE_SUPER_METHOD = "$$invokeSuperMethod$$";
    public static final String SEPARATOR_METHOD_INVOCATION_CLASS = "$$";
    protected static final Set<String> enhancedClassNames = Collections.synchronizedSet(new HashSet());
    protected final Class<?> targetClass;
    protected final Map<?, ?> parameters;
    protected final ClassPool classPool;
    protected final String enhancedClassName;
    protected final EnhancedClassGenerator enhancedClassGenerator;
    protected final List<Class<?>> methodInvocationClassList = new ArrayList();
    protected Class<?> enhancedClass;

    public AspectWeaver(Class<?> targetClass, Map<?, ?> parameters) {
        this.targetClass = targetClass;
        this.parameters = parameters;
        this.classPool = this.initializeClassPool(targetClass);
        this.enhancedClassName = this.buildEnhancedClassName();
        this.enhancedClassGenerator = this.createEnhancedClassGenerator(targetClass);
    }

    protected ClassPool initializeClassPool(Class<?> targetClass) {
        return ClassPoolUtil.getClassPool(targetClass);
    }

    protected EnhancedClassGenerator createEnhancedClassGenerator(Class<?> targetClass) {
        return this.newEnhancedClassGenerator(this.classPool, targetClass, this.enhancedClassName);
    }

    protected EnhancedClassGenerator newEnhancedClassGenerator(ClassPool classPool, Class<?> targetClass, String enhancedClassName) {
        return new EnhancedClassGenerator(classPool, targetClass, enhancedClassName);
    }

    public void setInterceptors(Method method, MethodInterceptor[] interceptors) {
        String methodInvocationClassName = this.buildMethodInvocationClassName(method);
        MethodInvocationClassGenerator methodInvocationClassGenerator = this.createMethodInvocationClassGenerator(methodInvocationClassName);
        String invokeSuperMethodName = this.createInvokeSuperMethod(method);
        methodInvocationClassGenerator.createProceedMethod(method, invokeSuperMethodName);
        this.enhancedClassGenerator.createTargetMethod(method, methodInvocationClassName);
        Class<?> methodInvocationClass = methodInvocationClassGenerator.toClass(LdiClassLoaderUtil.getClassLoader(this.targetClass));
        this.setStaticField(methodInvocationClass, "method", method);
        this.setStaticField(methodInvocationClass, "interceptors", interceptors);
        this.setStaticField(methodInvocationClass, "parameters", this.parameters);
        this.methodInvocationClassList.add(methodInvocationClass);
    }

    protected MethodInvocationClassGenerator createMethodInvocationClassGenerator(String methodInvocationClassName) {
        return this.newMethodInvocationClassGenerator(this.classPool, this.enhancedClassName, methodInvocationClassName);
    }

    protected MethodInvocationClassGenerator newMethodInvocationClassGenerator(ClassPool classPool, String enhancedClassName, String methodInvocationClassName) {
        return new MethodInvocationClassGenerator(classPool, enhancedClassName, methodInvocationClassName);
    }

    public void setInterTypes(InterType[] interTypes) {
        if (interTypes == null) {
            return;
        }
        for (int i = 0; i < interTypes.length; ++i) {
            this.enhancedClassGenerator.applyInterType(interTypes[i]);
        }
    }

    public Class<?> generateClass() {
        if (this.enhancedClass == null) {
            this.enhancedClass = this.enhancedClassGenerator.toClass(LdiClassLoaderUtil.getClassLoader(this.targetClass));
            for (int i = 0; i < this.methodInvocationClassList.size(); ++i) {
                Class<?> methodInvocationClass = this.methodInvocationClassList.get(i);
                this.setStaticField(methodInvocationClass, "targetClass", this.targetClass);
            }
        }
        return this.enhancedClass;
    }

    public void setStaticField(Class<?> clazz, String name, Object value) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            LdiFieldUtil.set(field, name, value);
            field.setAccessible(false);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(this.enhancedClass, name, e);
        }
    }

    public String buildEnhancedClassName() {
        StringBuilder sb = new StringBuilder(200);
        String targetClassName = this.targetClass.getName();
        Package pkg = this.targetClass.getPackage();
        if (targetClassName.startsWith("java.") || pkg != null && pkg.isSealed()) {
            sb.append("$$");
        }
        sb.append(targetClassName).append(SUFFIX_ENHANCED_CLASS).append(Integer.toHexString(this.hashCode()));
        int length = sb.length();
        int i = 0;
        while (enhancedClassNames.contains(new String(sb))) {
            sb.setLength(length);
            sb.append("_").append(i);
            ++i;
        }
        String name = new String(sb);
        enhancedClassNames.add(name);
        return name;
    }

    public String buildMethodInvocationClassName(Method method) {
        String pkg = MethodInvocationClassGenerator.getTemplateClass().getPackage().getName();
        String enhancedIdentity = LdiSrl.camelize(this.enhancedClassName, ".");
        String invocationSuffix = SUFFIX_METHOD_INVOCATION_CLASS;
        String methodName = method.getName();
        String invocationSeparator = "$$";
        int classCount = this.methodInvocationClassList.size();
        return pkg + "." + enhancedIdentity + SUFFIX_METHOD_INVOCATION_CLASS + methodName + "$$" + classCount;
    }

    public String createInvokeSuperMethod(Method method) {
        String invokeSuperMethodName = "$$" + method.getName() + SUFFIX_INVOKE_SUPER_METHOD;
        if (!LdiMethodUtil.isAbstract(method)) {
            this.enhancedClassGenerator.createInvokeSuperMethod(method, invokeSuperMethodName);
        }
        return invokeSuperMethodName;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Map<?, ?> getParameters() {
        return this.parameters != null ? Collections.unmodifiableMap(this.parameters) : Collections.emptyMap();
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    public String getEnhancedClassName() {
        return this.enhancedClassName;
    }

    public EnhancedClassGenerator getEnhancedClassGenerator() {
        return this.enhancedClassGenerator;
    }
}

