/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.javassist;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.ListIterator;
import javassist.ClassPool;
import javassist.CtClass;
import org.lastaflute.di.core.aop.InterType;
import org.lastaflute.di.core.aop.javassist.AbstractGenerator;
import org.lastaflute.di.core.aop.javassist.TryBlockSupport;

public class EnhancedClassGenerator
extends AbstractGenerator {
    protected final String enhancedClassName;
    protected CtClass enhancedCtClass;

    public EnhancedClassGenerator(ClassPool classPool, Class<?> targetClass, String enhancedClassName) {
        super(classPool, targetClass);
        this.enhancedClassName = enhancedClassName;
        this.setupClass();
        this.setupInterface();
        this.setupConstructor();
    }

    public void setupClass() {
        Class superClass = this.targetClass.isInterface() ? Object.class : this.targetClass;
        this.enhancedCtClass = this.createCtClass(this.enhancedClassName, superClass);
    }

    public void setupInterface() {
        if (this.targetClass.isInterface()) {
            this.setInterface(this.enhancedCtClass, this.targetClass);
        }
    }

    public void setupConstructor() {
        Constructor<?>[] constructors = this.targetClass.getDeclaredConstructors();
        if (constructors.length == 0) {
            this.createDefaultConstructor(this.enhancedCtClass);
        } else {
            for (int i = 0; i < constructors.length; ++i) {
                Package pkg;
                int modifier = constructors[i].getModifiers();
                if (!this.canCreateExplicitConstructor(modifier, pkg = this.targetClass.getPackage())) continue;
                this.createConstructor(this.enhancedCtClass, constructors[i]);
            }
        }
    }

    protected boolean canCreateExplicitConstructor(int modifier, Package pkg) {
        return Modifier.isPublic(modifier) || Modifier.isProtected(modifier) || !Modifier.isPrivate(modifier) && !this.targetClass.getName().startsWith("java.") && (pkg == null || !pkg.isSealed());
    }

    public void createTargetMethod(Method method, String methodInvocationClassName) {
        String methodSource = EnhancedClassGenerator.createTargetMethodSource(method, methodInvocationClassName);
        this.createMethod(this.enhancedCtClass, method, methodSource);
    }

    public void createInvokeSuperMethod(Method method, String invokeSuperMethodName) {
        String methodSource = EnhancedClassGenerator.createInvokeSuperMethodSource(method);
        this.createMethod(this.enhancedCtClass, method.getModifiers(), method.getReturnType(), invokeSuperMethodName, method.getParameterTypes(), method.getExceptionTypes(), methodSource);
    }

    public void applyInterType(InterType interType) {
        interType.introduce(this.targetClass, this.enhancedCtClass);
    }

    public Class<?> toClass(ClassLoader classLoader) {
        Class<?> clazz = this.toClass(classLoader, this.enhancedCtClass);
        this.enhancedCtClass.detach();
        this.enhancedCtClass = null;
        return clazz;
    }

    public static String createTargetMethodSource(Method method, String methodInvocationClassName) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("Object result = new ").append(methodInvocationClassName).append("(this, $args).proceed();");
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            sb.append("return;");
        } else if (returnType.isPrimitive()) {
            sb.append("return ($r) ((result == null) ? ");
            if (returnType.equals(Boolean.TYPE)) {
                sb.append("false : ");
            } else {
                sb.append("0 : ");
            }
            sb.append(EnhancedClassGenerator.fromObject(returnType, "result")).append(");");
        } else {
            sb.append("return ($r) result;");
        }
        String code = new String(sb);
        Class<?>[] exceptionTypes = EnhancedClassGenerator.normalizeExceptionTypes(method.getExceptionTypes());
        if (exceptionTypes.length != 1 || !exceptionTypes[0].equals(Throwable.class)) {
            code = EnhancedClassGenerator.aroundTryCatchBlock(exceptionTypes, code);
        }
        return "{" + code + "}";
    }

    public static String createInvokeSuperMethodSource(Method method) {
        return "{return ($r) super." + method.getName() + "($$);}";
    }

    public static Class<?>[] normalizeExceptionTypes(Class<?>[] exceptionTypes) {
        LinkedList list = new LinkedList();
        block0: for (int i = 0; i < exceptionTypes.length; ++i) {
            Class<?> currentException = exceptionTypes[i];
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                Class comparisonException = (Class)it.next();
                if (comparisonException.isAssignableFrom(currentException)) continue block0;
                if (!currentException.isAssignableFrom(comparisonException)) continue;
                it.remove();
            }
            list.add(currentException);
        }
        return list.toArray(new Class[list.size()]);
    }

    public static String aroundTryCatchBlock(Class<?>[] exceptionTypes, String code) {
        TryBlockSupport tryBlock = new TryBlockSupport(code);
        boolean needRuntimeException = true;
        boolean needError = true;
        for (int i = 0; i < exceptionTypes.length; ++i) {
            Class<?> exceptionType = exceptionTypes[i];
            tryBlock.addCatchBlock(exceptionType, "throw e;");
            if (exceptionType.equals(RuntimeException.class)) {
                needRuntimeException = false;
            }
            if (!exceptionType.equals(Error.class)) continue;
            needError = false;
        }
        if (needRuntimeException) {
            tryBlock.addCatchBlock(RuntimeException.class, "throw e;");
        }
        if (needError) {
            tryBlock.addCatchBlock(Error.class, "throw e;");
        }
        tryBlock.addCatchBlock(Throwable.class, "throw new java.lang.reflect.UndeclaredThrowableException(e);");
        return tryBlock.getSourceCode();
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getEnhancedClassName() {
        return this.enhancedClassName;
    }

    public CtClass getEnhancedCtClass() {
        return this.enhancedCtClass;
    }
}

