/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.proxy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import org.lastaflute.di.core.aop.Aspect;
import org.lastaflute.di.core.aop.InterType;
import org.lastaflute.di.core.aop.Pointcut;
import org.lastaflute.di.core.aop.frame.MethodInterceptor;
import org.lastaflute.di.core.aop.impl.PointcutImpl;
import org.lastaflute.di.core.aop.javassist.AspectWeaver;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiConstructorUtil;
import org.lastaflute.di.util.LdiMethodUtil;

public class AopProxy
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final LaLogger logger = LaLogger.getLogger(AopProxy.class);
    protected final Class<?> targetClass;
    protected final Class<?> enhancedClass;
    protected final Pointcut defaultPointcut;
    protected final AspectWeaver aspectWeaver;

    public AopProxy(Class<?> targetClass, Aspect[] aspects) {
        this(targetClass, aspects, null, null);
    }

    public AopProxy(Class<?> targetClass, Aspect[] aspects, InterType[] interTypes) {
        this(targetClass, aspects, interTypes, null);
    }

    public AopProxy(Class<?> targetClass, Aspect[] aspects, Map<?, ?> parameters) {
        this(targetClass, aspects, null, parameters);
    }

    public AopProxy(Class<?> targetClass, Aspect[] aspects, InterType[] interTypes, Map<?, ?> parameters) {
        if (this.isBothAspectInterTypeEmpty(aspects, interTypes)) {
            throw new EmptyRuntimeException("aspects and interTypes");
        }
        this.targetClass = targetClass;
        this.defaultPointcut = this.createDefaultPointcut(targetClass);
        this.aspectWeaver = this.createAspectWeaver(targetClass, parameters);
        this.setupAspects(aspects);
        this.aspectWeaver.setInterTypes(interTypes);
        this.enhancedClass = this.aspectWeaver.generateClass();
    }

    protected boolean isBothAspectInterTypeEmpty(Aspect[] aspects, InterType[] interTypes) {
        return !(aspects != null && aspects.length != 0 || interTypes != null && interTypes.length != 0);
    }

    protected Pointcut createDefaultPointcut(Class<?> targetClass) {
        return new PointcutImpl(targetClass);
    }

    protected AspectWeaver createAspectWeaver(Class<?> targetClass, Map<?, ?> parameters) {
        return this.newAspectWeaver(targetClass, parameters);
    }

    protected AspectWeaver newAspectWeaver(Class<?> targetClass, Map<?, ?> parameters) {
        return new AspectWeaver(targetClass, parameters);
    }

    protected void setupAspects(Aspect[] aspects) {
        if (aspects == null || aspects.length == 0) {
            return;
        }
        for (int i = 0; i < aspects.length; ++i) {
            Aspect aspect = aspects[i];
            if (aspect.getPointcut() != null) continue;
            aspect.setPointcut(this.defaultPointcut);
        }
        Method[] methods = this.targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (LdiMethodUtil.isBridgeMethod(method) || LdiMethodUtil.isSyntheticMethod(method)) continue;
            ArrayList<MethodInterceptor> interceptorList = new ArrayList<MethodInterceptor>();
            for (int j = 0; j < aspects.length; ++j) {
                Aspect aspect = aspects[j];
                if (!aspect.getPointcut().isApplied(method)) continue;
                interceptorList.add(aspect.getMethodInterceptor());
            }
            if (interceptorList.size() == 0) continue;
            if (!this.isApplicableAspect(method)) {
                logger.log("WSSR0009", new Object[]{this.targetClass.getName(), method.getName()});
                continue;
            }
            this.aspectWeaver.setInterceptors(method, interceptorList.toArray(new MethodInterceptor[interceptorList.size()]));
        }
    }

    protected boolean isApplicableAspect(Method method) {
        int mod = method.getModifiers();
        return !Modifier.isFinal(mod) && !Modifier.isStatic(mod);
    }

    public Object create() {
        return LdiClassUtil.newInstance(this.enhancedClass);
    }

    public Object create(Class<?>[] argTypes, Object[] args) {
        Constructor<?> constructor = LdiClassUtil.getConstructor(this.enhancedClass, argTypes);
        return LdiConstructorUtil.newInstance(constructor, args);
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Class<?> getEnhancedClass() {
        return this.enhancedClass;
    }

    public Pointcut getDefaultPointcut() {
        return this.defaultPointcut;
    }

    public AspectWeaver getAspectWeaver() {
        return this.aspectWeaver;
    }
}

