/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.expression.engine;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.di.core.exception.ExpressionClassCreateFailureException;
import org.lastaflute.di.core.expression.dwarf.ExpressionCastResolver;
import org.lastaflute.di.core.expression.engine.ExpressionEngine;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiSrl;
import org.lastaflute.di.util.LdiStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptExpressionEngine
implements ExpressionEngine {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptExpressionEngine.class);
    protected static final String FIRST_ENGINE_NAME = "sai";
    protected static final String SECOND_ENGINE_NAME = "rhino";
    protected static final String THIRD_ENGINE_NAME = "nashorn";
    protected static final String LAST_ENGINE_NAME = "javascript";
    protected static final String SQ = "'";
    protected static final String DQ = "\"";
    protected static final ScriptEngineManager defaultManager = new ScriptEngineManager();
    protected static final ExpressionCastResolver castResolver = new ExpressionCastResolver();

    @Override
    public Object parseExpression(String source) {
        return source.trim();
    }

    @Override
    public Object evaluate(Object exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        return this.viaVariableResolvedEvaluate((String)exp, contextMap, container, resultType);
    }

    protected Object viaVariableResolvedEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> resultType) {
        String resolvedExp = this.resolveExpressionVariable(exp, contextMap);
        return this.viaCastResolvedEvaluate(resolvedExp, container, resultType);
    }

    protected String resolveExpressionVariable(String exp, Map<String, ? extends Object> contextMap) {
        return ExpressionEngine.resolveExpressionVariableSimply(exp, contextMap);
    }

    protected Object viaCastResolvedEvaluate(String exp, LaContainer container, Class<?> resultType) {
        Class<?> realType;
        String realExp;
        ExpressionCastResolver.CastResolved resolved = castResolver.resolveCast(exp, resultType);
        if (resolved != null) {
            realExp = resolved.getFilteredExp();
            realType = resolved.getResolvedType();
        } else {
            realExp = exp.trim();
            realType = resultType;
        }
        return this.viaFirstNameResolvedEvaluate(realExp, container, realType);
    }

    protected Object viaFirstNameResolvedEvaluate(String exp, LaContainer container, Class<?> resultType) {
        String filteredExp;
        String firstName = null;
        LaContainer firstComponent = null;
        if (!exp.startsWith(DQ) && !exp.startsWith("[") && !exp.startsWith("{") && exp.contains(".")) {
            String componentName = exp.substring(0, exp.indexOf("."));
            LaContainer namedContainer = container.getRoot().findChild(componentName);
            if (namedContainer != null) {
                String rear = exp.substring(exp.indexOf(".") + ".".length());
                if (rear.contains(".")) {
                    String nextName = rear.substring(0, rear.indexOf("."));
                    if (namedContainer.hasComponentDef(nextName)) {
                        filteredExp = rear;
                        firstName = nextName;
                        firstComponent = namedContainer.getComponent(nextName);
                    } else {
                        filteredExp = exp;
                        firstName = componentName;
                        firstComponent = namedContainer;
                    }
                } else {
                    if (namedContainer.hasComponentDef(rear)) {
                        return namedContainer.getComponent(rear);
                    }
                    filteredExp = exp;
                    firstName = componentName;
                    firstComponent = namedContainer;
                }
            } else {
                filteredExp = exp;
                if (container.hasComponentDef(componentName)) {
                    firstName = componentName;
                    firstComponent = (LaContainer)container.getComponent(componentName);
                }
            }
        } else {
            filteredExp = exp;
        }
        Object evaluated = this.actuallyEvaluate(filteredExp, container, firstName, firstComponent);
        Object filtered = this.filterEvaluated(filteredExp, container, evaluated, resultType);
        return filtered;
    }

    protected Object actuallyEvaluate(String exp, LaContainer container, String firstName, Object firstComponent) {
        ScriptEngine engine = this.comeOnScriptEngine(exp, container);
        if (firstName != null) {
            engine.put(firstName, firstComponent);
        }
        this.showEvaluating(exp, container, firstName, firstComponent);
        try {
            Object result;
            if (this.isVarResultWayTarget(exp)) {
                engine.eval("var result = " + exp);
                result = engine.get("result");
            } else {
                result = engine.eval(exp);
            }
            this.showEvaluatedR(result);
            return result;
        }
        catch (RuntimeException | ScriptException e) {
            this.throwJavaScriptExpressionException(exp, container, e);
            return null;
        }
    }

    protected boolean isVarResultWayTarget(String exp) {
        return LdiSrl.isQuotedAnything(exp, "{", "}");
    }

    protected void showEvaluating(String exp, LaContainer container, String firstName, Object firstComponent) {
        if (this.isInternalDebug()) {
            StringBuilder sb = new StringBuilder();
            sb.append("#fw_debug ...Evaluating: exp={}, Di xml={}");
            if (firstName != null) {
                sb.append(", component={}/{}");
            }
            logger.debug(sb.toString(), new Object[]{exp, container.getPath(), firstName, firstComponent});
        }
    }

    protected void showEvaluatedR(Object result) {
        if (this.isInternalDebug()) {
            Object disp = result instanceof List ? new ArrayList((List)result).toString() + " (" + result.getClass().getName() + ")" : (result instanceof Map ? new LinkedHashMap((Map)result).toString() + " (" + result.getClass().getName() + ")" : result);
            logger.debug("#fw_debug Evaluated: {}", disp);
        }
    }

    protected void throwJavaScriptExpressionException(String exp, LaContainer container, Exception e) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to evaluate the JavaScript expression.");
        br.addItem("Expression");
        br.addElement(exp);
        br.addItem("Di XML");
        br.addElement(container.getPath());
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, e);
    }

    public void initializeManagedEngine() {
        if (this.isInternalDebug()) {
            logger.debug("#fw_debug ...Initializing framework-managed script engine for Di xml.");
        }
        ScriptEngineManager scriptEngineManager = this.prepareScriptEngineManager();
        String specifiedName = this.getDiXmlScriptManagedEngineName();
        if (specifiedName != null) {
            ScriptEngine specifiedEngine = scriptEngineManager.getEngineByName(specifiedName);
            if (this.isInternalDebug()) {
                if (specifiedEngine != null) {
                    logger.debug("#fw_debug Initialized the specified script engine: {}, {}", (Object)specifiedName, (Object)specifiedEngine);
                } else {
                    logger.debug("#fw_debug Not found the specified script engine: {}", (Object)specifiedName);
                }
            }
        } else {
            ScriptEngineFound found = this.findEmbeddedScriptEngine(scriptEngineManager);
            if (this.isInternalDebug()) {
                if (found != null) {
                    String engineName = found.getEngineName();
                    ScriptEngine foundEngine = found.getFoundEngine();
                    logger.debug("#fw_debug Initialized the embedded script engine: {}/{}", (Object)engineName, (Object)foundEngine);
                } else {
                    logger.debug("#fw_debug Not found the embedded script engine.");
                }
            }
        }
    }

    protected ScriptEngine comeOnScriptEngine(String exp, LaContainer container) {
        ScriptEngine engine;
        ScriptEngineManager scriptEngineManager = this.prepareScriptEngineManager();
        String specifyedName = this.getDiXmlScriptManagedEngineName();
        if (specifyedName != null) {
            engine = scriptEngineManager.getEngineByName(specifyedName);
            if (engine == null) {
                this.throwScriptEngineSpecifiedNotFoundException(specifyedName, exp, container);
            }
        } else {
            ScriptEngineFound found = this.findEmbeddedScriptEngine(scriptEngineManager);
            if (found == null) {
                this.throwScriptEngineEmbeddedNotFoundException(exp, container);
            }
            engine = found.getFoundEngine();
        }
        return engine;
    }

    protected ScriptEngineManager prepareScriptEngineManager() {
        return defaultManager;
    }

    protected String getDiXmlScriptManagedEngineName() {
        return LastaDiProperties.getInstance().getDiXmlScriptManagedEngineName();
    }

    protected ScriptEngineFound findEmbeddedScriptEngine(ScriptEngineManager scriptEngineManager) {
        ScriptEngineFound embeddedEngine = this.getEngineByName(scriptEngineManager, FIRST_ENGINE_NAME);
        if (embeddedEngine == null) {
            embeddedEngine = this.getEngineByName(scriptEngineManager, SECOND_ENGINE_NAME);
        }
        if (embeddedEngine == null) {
            embeddedEngine = this.getEngineByName(scriptEngineManager, THIRD_ENGINE_NAME);
        }
        if (embeddedEngine == null) {
            embeddedEngine = this.getEngineByName(scriptEngineManager, LAST_ENGINE_NAME);
        }
        return embeddedEngine;
    }

    protected ScriptEngineFound getEngineByName(ScriptEngineManager scriptEngineManager, String engineName) {
        ScriptEngine embeddedEngine = scriptEngineManager.getEngineByName(engineName);
        return embeddedEngine != null ? new ScriptEngineFound(engineName, embeddedEngine) : null;
    }

    protected void throwScriptEngineSpecifiedNotFoundException(String engineName, String exp, LaContainer container) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Not found the script engine by the specified name.");
        br.addItem("Advice");
        br.addElement("Your expression on the Di xml needs JavaScript engine.");
        br.addElement("But the script engine was not found by the engine name");
        br.addElement("specified by your lasta_di.properties.");
        br.addElement("");
        br.addElement("So confirm that the engine exists in your JavaVM.");
        br.addElement("(also your lasta_di.properties settings)");
        br.addItem("Engine Name");
        br.addElement(engineName);
        br.addItem("Script Expression");
        br.addElement(exp);
        br.addItem("Di xml");
        br.addElement(container.getPath());
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected void throwScriptEngineEmbeddedNotFoundException(String exp, LaContainer container) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Not found the script engine by the embedded name.");
        br.addItem("Advice");
        br.addElement("Your expression on the Di xml needs JavaScript engine.");
        br.addElement("But Nashorn (JavaScript engine) is removed since Java15.");
        br.addElement("");
        br.addElement("So add the 'sai' library to your dependencies.");
        br.addElement("It is JavaScript engine forked from Nashorn.");
        br.addElement(" https://github.com/codelibs/sai");
        br.addItem("Script Expression");
        br.addElement(exp);
        br.addItem("Di xml");
        br.addElement(container.getPath());
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected Object filterEvaluated(String exp, LaContainer container, Object evaluated, Class<?> resultType) {
        if (evaluated instanceof String) {
            String str = ((String)evaluated).trim();
            String prefix = "new ";
            String suffix = "()";
            if (str.startsWith("new ") && str.endsWith("()")) {
                String className = str.substring("new ".length(), str.length() - "()".length());
                try {
                    return LdiClassUtil.newInstance(className);
                }
                catch (RuntimeException e) {
                    this.throwExpressionClassCreateFailureException(exp, container, className, e);
                }
            }
        }
        if (evaluated instanceof List) {
            List list = (List)evaluated;
            return this.handleList(exp, container, list, resultType);
        }
        if (evaluated instanceof Map) {
            Map map = (Map)evaluated;
            return this.handleMap(exp, container, map, resultType);
        }
        return evaluated;
    }

    protected void throwExpressionClassCreateFailureException(String exp, LaContainer container, String className, RuntimeException cause) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to create the class in the expression.");
        br.addItem("Di XML");
        br.addElement(container.getPath());
        br.addItem("Expression");
        br.addElement(exp);
        br.addItem("Class Name");
        br.addElement(className);
        String msg = br.buildExceptionMessage();
        throw new ExpressionClassCreateFailureException(msg, cause);
    }

    protected Object handleList(String exp, LaContainer container, List<Object> list, Class<?> resultType) {
        return castResolver.convertListTo(exp, container, resultType, list);
    }

    protected Object handleMap(String exp, LaContainer container, Map<String, Object> map, Class<?> resultType) {
        List<Object> challengeList = this.challengeList(map);
        if (challengeList != null) {
            return this.handleList(exp, container, challengeList, resultType);
        }
        return map;
    }

    protected List<Object> challengeList(Map<String, Object> map) {
        if (this.isNumberKeyMap(map)) {
            return new ArrayList<Object>(map.values());
        }
        return null;
    }

    protected boolean isNumberKeyMap(Map<String, Object> map) {
        int index = 0;
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            if (LdiStringUtil.isNumber(key) && Integer.parseInt(key) == index) {
                ++index;
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public String resolveStaticMethodReference(Class<?> refType, String methodName) {
        return refType.getName() + "." + methodName;
    }

    protected boolean isInternalDebug() {
        return LastaDiProperties.getInstance().isInternalDebug();
    }

    public static class ScriptEngineFound {
        protected final String engineName;
        protected final ScriptEngine foundEngine;

        public ScriptEngineFound(String engineName, ScriptEngine foundEngine) {
            this.engineName = engineName;
            this.foundEngine = foundEngine;
        }

        public String toString() {
            return "{" + this.engineName + ", " + this.foundEngine + "}";
        }

        public String getEngineName() {
            return this.engineName;
        }

        public ScriptEngine getFoundEngine() {
            return this.foundEngine;
        }
    }
}

