/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.naming;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lastaflute.di.Disposable;
import org.lastaflute.di.DisposableUtil;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.naming.NamingConvention;
import org.lastaflute.di.naming.styling.StylingFreedomInterfaceMapper;
import org.lastaflute.di.naming.styling.StylingOptionFactory;
import org.lastaflute.di.util.LdiArrayUtil;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiMapUtil;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiResourcesUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class StyledNamingConvention
implements NamingConvention,
Disposable {
    protected static final char PACKAGE_SEPARATOR = '_';
    protected static final String PACKAGE_SEPARATOR_STR = "_";
    protected boolean initialized;
    protected String actionSuffix = "Action";
    protected String formSuffix = "Form";
    protected String serviceSuffix = "Service";
    protected String logicSuffix = "Logic";
    protected String repositorySuffix = "Repository";
    protected String assistSuffix = "Assist";
    protected String helperSuffix = "Helper";
    protected String interceptorSuffix = "Interceptor";
    protected String validatorSuffix = "Validator";
    protected String converterSuffix = "Converter";
    protected String jobSuffix = "Job";
    protected String implementationSuffix = "Impl";
    protected String viewRootPath = "/view";
    protected String viewExtension = ".html";
    protected String[] rootPackageNames = new String[0];
    protected String webRootPackageName = "web";
    protected String jobRootPackageName = "job";
    protected String bizRootPackageName = "biz";
    protected String[] ignorePackageNames = new String[0];
    protected final Set<String> hotdeployRootPackageNames = new HashSet<String>(4);
    protected final Map<String, LdiResourcesUtil.Resources[]> existenceCheckerArrays = LdiMapUtil.createHashMap();
    protected final Map<String, String> interfaceToImplementationMap = new HashMap<String, String>(4);
    protected final Map<String, String> implementationToInterfaceMap = new HashMap<String, String>(4);
    protected StylingFreedomInterfaceMapper freedomInterfaceMapper;

    public StyledNamingConvention() {
        this.initialize();
        this.setupPropertiesSmartPackage();
        this.setupFreedomInterfaceMapper();
    }

    public void initialize() {
        if (!this.initialized) {
            for (int i = 0; i < this.rootPackageNames.length; ++i) {
                this.addExistingChecker(this.rootPackageNames[i]);
            }
            DisposableUtil.add(this);
            this.initialized = true;
        }
    }

    protected void setupPropertiesSmartPackage() {
        LastaDiProperties.getInstance().getSmartPackageList().forEach(pkg -> this.addRootPackageName((String)pkg));
    }

    protected void setupFreedomInterfaceMapper() {
        StylingFreedomInterfaceMapper specified = new StylingOptionFactory().prepareFreedomInterfaceMapper();
        if (specified != null) {
            this.useFreedomInterfaceMapper(specified);
        }
    }

    public void addRootPackageName(String rootPackageName) {
        this.addRootPackageName(rootPackageName, true);
    }

    public void addRootPackageName(String rootPackageName, boolean hotdeploy) {
        this.rootPackageNames = (String[])LdiArrayUtil.add((Object[])this.rootPackageNames, rootPackageName);
        if (hotdeploy) {
            this.hotdeployRootPackageNames.add(rootPackageName);
        }
        this.addExistingChecker(rootPackageName);
    }

    public void addIgnorePackageName(String ignorePackageName) {
        this.ignorePackageNames = (String[])LdiArrayUtil.add((Object[])this.ignorePackageNames, ignorePackageName);
    }

    public void addInterfaceToImplementationClassName(String interfaceName, String implementationClassName) {
        this.interfaceToImplementationMap.put(interfaceName, implementationClassName);
        this.implementationToInterfaceMap.put(implementationClassName, interfaceName);
    }

    public void useFreedomInterfaceMapper(StylingFreedomInterfaceMapper freedomInterfaceMapper) {
        if (freedomInterfaceMapper == null) {
            throw new IllegalArgumentException("The argument 'freedomInterfaceMapper' should not be null.");
        }
        this.freedomInterfaceMapper = freedomInterfaceMapper;
    }

    @Override
    public boolean isTargetClassName(String className, String suffix) {
        if (this.isIgnoreClassName(className)) {
            return false;
        }
        if (!LdiStringUtil.trimSuffix(className, this.implementationSuffix).endsWith(suffix)) {
            return false;
        }
        String shortClassName = LdiClassUtil.getShortClassName(className);
        if (className.endsWith(this.implementationSuffix) && !className.endsWith("." + this.getImplementationPackageName() + "." + shortClassName)) {
            return false;
        }
        String middlePackageName = this.fromSuffixToPackageName(suffix);
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            if (className.startsWith(this.rootPackageNames[i] + "." + middlePackageName + ".")) {
                return true;
            }
            if (className.startsWith(this.buildRootAndWebPackagePrefix(i))) {
                return true;
            }
            if (className.startsWith(this.buildRootAndJobPackagePrefix(i))) {
                return true;
            }
            if (!className.startsWith(this.buildRootAndBizPackagePrefix(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTargetClassName(String className) {
        if (this.isIgnoreClassName(className)) {
            return false;
        }
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            if (!className.startsWith(this.rootPackageNames[i] + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHotdeployTargetClassName(String className) {
        if (this.isIgnoreClassName(className)) {
            return false;
        }
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            if (!className.startsWith(this.rootPackageNames[i] + ".")) continue;
            return this.hotdeployRootPackageNames.contains(this.rootPackageNames[i]);
        }
        return false;
    }

    @Override
    public boolean isIgnoreClassName(String className) {
        for (int i = 0; i < this.ignorePackageNames.length; ++i) {
            if (!className.startsWith(this.ignorePackageNames[i] + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String fromSuffixToPackageName(String suffix) {
        if (LdiStringUtil.isEmpty(suffix)) {
            throw new EmptyRuntimeException("suffix");
        }
        return suffix.toLowerCase();
    }

    @Override
    public String fromClassNameToComponentName(String className) {
        int i;
        if (LdiStringUtil.isEmpty(className)) {
            throw new EmptyRuntimeException("className");
        }
        String interfaceClassName = this.toInterfaceClassName(className);
        String suffix = this.fromClassNameToSuffix(interfaceClassName);
        String middlePackageName = this.fromSuffixToPackageName(suffix);
        String name = null;
        for (i = 0; i < this.rootPackageNames.length; ++i) {
            String prefix = this.rootPackageNames[i] + "." + middlePackageName + ".";
            if (!interfaceClassName.startsWith(prefix)) continue;
            name = interfaceClassName.substring(prefix.length());
        }
        if (LdiStringUtil.isEmpty(name)) {
            for (i = 0; i < this.rootPackageNames.length; ++i) {
                String webPackagePrefix = this.buildRootAndWebPackagePrefix(i);
                if (interfaceClassName.startsWith(webPackagePrefix)) {
                    name = interfaceClassName.substring(webPackagePrefix.length());
                    continue;
                }
                String jobPackagePrefix = this.buildRootAndJobPackagePrefix(i);
                if (interfaceClassName.startsWith(jobPackagePrefix)) {
                    name = interfaceClassName.substring(jobPackagePrefix.length());
                    continue;
                }
                String bizPackagePrefix = this.buildRootAndBizPackagePrefix(i);
                if (!interfaceClassName.startsWith(bizPackagePrefix)) continue;
                name = interfaceClassName.substring(bizPackagePrefix.length());
            }
            if (LdiStringUtil.isEmpty(name)) {
                return this.fromClassNameToShortComponentName(className);
            }
        }
        String[] array = LdiStringUtil.split(name, ".");
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 == array.length - 1) {
                sb.append(LdiStringUtil.decapitalize(array[i2]));
                continue;
            }
            sb.append(array[i2]).append('_');
        }
        return sb.toString();
    }

    @Override
    public String fromClassNameToShortComponentName(String className) {
        if (LdiStringUtil.isEmpty(className)) {
            throw new EmptyRuntimeException("className");
        }
        String s = LdiStringUtil.decapitalize(LdiClassUtil.getShortClassName(className));
        if (s.endsWith(this.implementationSuffix)) {
            return s.substring(0, s.length() - this.implementationSuffix.length());
        }
        return s;
    }

    @Override
    public Class<?> toCompleteClass(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return clazz;
        }
        String className = this.toImplementationClassName(clazz.getName());
        if (LdiResourceUtil.isExist(LdiClassUtil.getResourcePath(className))) {
            return LdiClassUtil.forName(className);
        }
        return clazz;
    }

    @Override
    public Class<?> fromComponentNameToClass(String componentName) {
        if (LdiStringUtil.isEmpty(componentName)) {
            throw new EmptyRuntimeException("componentName");
        }
        String suffix = this.fromComponentNameToSuffix(componentName);
        if (suffix == null) {
            return null;
        }
        String middlePackageName = this.fromSuffixToPackageName(suffix);
        String partOfClassName = this.fromComponentNameToPartOfClassName(componentName);
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            String rootPackageName = this.rootPackageNames[i];
            Class<?> clazz = this.findWebClass(rootPackageName, partOfClassName);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.findJobClass(rootPackageName, partOfClassName);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.findBizClass(rootPackageName, partOfClassName);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.findClass(rootPackageName, middlePackageName, partOfClassName);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    protected Class<?> findWebClass(String rootPackageName, String partOfClassName) {
        return this.findClass(rootPackageName, this.webRootPackageName, partOfClassName);
    }

    protected Class<?> findJobClass(String rootPackageName, String partOfClassName) {
        return this.findClass(rootPackageName, this.jobRootPackageName, partOfClassName);
    }

    protected Class<?> findBizClass(String rootPackageName, String partOfClassName) {
        return this.findClass(rootPackageName, this.bizRootPackageName, partOfClassName);
    }

    protected Class<?> findClass(String rootPackageName, String middlePackageName, String partOfClassName) {
        this.initialize();
        String backPartOfClassName = LdiClassUtil.concatName(middlePackageName, partOfClassName);
        String className = LdiClassUtil.concatName(rootPackageName, backPartOfClassName);
        String backPartOfImplClassName = this.toImplementationClassName(backPartOfClassName);
        String implClassName = LdiClassUtil.concatName(rootPackageName, backPartOfImplClassName);
        if (!this.isIgnoreClassName(implClassName) && this.isExist(rootPackageName, backPartOfImplClassName)) {
            return LdiClassUtil.forName(implClassName);
        }
        if (!this.isIgnoreClassName(className) && this.isExist(rootPackageName, backPartOfClassName)) {
            return LdiClassUtil.forName(className);
        }
        return null;
    }

    @Override
    public String fromComponentNameToSuffix(String componentName) {
        return this.fromNameToSuffix(componentName);
    }

    @Override
    public String fromClassNameToSuffix(String componentName) {
        return this.fromNameToSuffix(componentName);
    }

    protected String fromNameToSuffix(String name) {
        if (LdiStringUtil.isEmpty(name)) {
            throw new EmptyRuntimeException("name");
        }
        for (int i = name.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            return name.substring(i);
        }
        return null;
    }

    @Override
    public String fromComponentNameToPartOfClassName(String componentName) {
        if (componentName == null) {
            throw new EmptyRuntimeException("componentName");
        }
        String[] names = LdiStringUtil.split(componentName, PACKAGE_SEPARATOR_STR);
        StringBuffer buf = new StringBuffer(50);
        for (int i = 0; i < names.length; ++i) {
            if (i == names.length - 1) {
                buf.append(LdiStringUtil.capitalize(names[i]));
                continue;
            }
            buf.append(names[i]).append(".");
        }
        return buf.toString();
    }

    @Override
    public String fromPathToActionName(String path) {
        return this.fromPathToComponentName(path, this.actionSuffix);
    }

    protected String fromPathToComponentName(String path, String nameSuffix) {
        if (!path.startsWith(this.viewRootPath) || !path.endsWith(this.viewExtension)) {
            throw new IllegalArgumentException(path);
        }
        String removedView = path.substring(this.adjustViewRootPath().length() + 1, path.length() - this.viewExtension.length());
        String componentName = (removedView + nameSuffix).replace('/', '_');
        int lastDelimiterIndex = componentName.lastIndexOf(95);
        if (lastDelimiterIndex == -1) {
            return LdiStringUtil.decapitalize(componentName);
        }
        String componentPath = componentName.substring(0, lastDelimiterIndex + 1);
        String pureName = LdiStringUtil.decapitalize(componentName.substring(lastDelimiterIndex + 1));
        return componentPath + pureName;
    }

    @Override
    public String fromActionNameToPath(String actionName) {
        if (!actionName.endsWith(this.actionSuffix)) {
            throw new IllegalArgumentException(actionName);
        }
        String name = actionName.substring(0, actionName.length() - this.actionSuffix.length());
        return this.adjustViewRootPath() + "/" + name.replace('_', '/') + this.viewExtension;
    }

    @Override
    public String toImplementationClassName(String className) {
        String freedomMapped;
        if (this.freedomInterfaceMapper != null && (freedomMapped = this.freedomInterfaceMapper.toImplementationClassName(className)) != null) {
            return freedomMapped;
        }
        String implementationMappedName = this.interfaceToImplementationMap.get(className);
        if (implementationMappedName != null) {
            return implementationMappedName;
        }
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return this.getImplementationPackageName() + "." + className + this.implementationSuffix;
        }
        String basePackage = className.substring(0, index);
        String pureClassName = className.substring(index + 1);
        return basePackage + "." + this.getImplementationPackageName() + "." + pureClassName + this.implementationSuffix;
    }

    @Override
    public String toInterfaceClassName(String className) {
        String freedomMapped;
        if (this.freedomInterfaceMapper != null && (freedomMapped = this.freedomInterfaceMapper.toInterfaceClassName(className)) != null) {
            return freedomMapped;
        }
        String interfaceMappedName = this.implementationToInterfaceMap.get(className);
        if (interfaceMappedName != null) {
            return interfaceMappedName;
        }
        if (!className.endsWith(this.implementationSuffix)) {
            return className;
        }
        String key = "." + this.getImplementationPackageName() + ".";
        int index = className.lastIndexOf(key);
        if (index < 0) {
            throw new IllegalArgumentException(className);
        }
        String basePackage = className.substring(0, index);
        String interfacePureName = className.substring(index + key.length(), className.length() - this.implementationSuffix.length());
        return basePackage + "." + interfacePureName;
    }

    @Override
    public boolean isSkipClass(Class<?> clazz) {
        String interfaceClassName;
        if (clazz.isInterface()) {
            return false;
        }
        if (this.freedomInterfaceMapper != null && (interfaceClassName = this.freedomInterfaceMapper.toInterfaceClassName(clazz.getName())) != null) {
            return true;
        }
        for (Map.Entry<String, String> entry : this.interfaceToImplementationMap.entrySet()) {
            Class<?> interfaceClass = LdiClassUtil.forName(entry.getKey());
            if (!interfaceClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExist(String rootPackageName, String lastClassName) {
        LdiResourcesUtil.Resources[] checkerArray = this.getExistCheckerArray(rootPackageName);
        for (int i = 0; i < checkerArray.length; ++i) {
            if (!checkerArray[i].isExistClass(lastClassName)) continue;
            return true;
        }
        return false;
    }

    protected LdiResourcesUtil.Resources[] getExistCheckerArray(String rootPackageName) {
        return this.existenceCheckerArrays.get(rootPackageName);
    }

    protected void addExistingChecker(String rootPackageName) {
        LdiResourcesUtil.Resources[] checkerArray = LdiResourcesUtil.getResourcesTypes(rootPackageName);
        this.existenceCheckerArrays.put(rootPackageName, checkerArray);
    }

    protected String buildRootAndWebPackagePrefix(int rootIndex) {
        return this.rootPackageNames[rootIndex] + "." + this.webRootPackageName + ".";
    }

    protected String buildRootAndJobPackagePrefix(int rootIndex) {
        return this.rootPackageNames[rootIndex] + "." + this.jobRootPackageName + ".";
    }

    protected String buildRootAndBizPackagePrefix(int rootIndex) {
        return this.rootPackageNames[rootIndex] + "." + this.bizRootPackageName + ".";
    }

    @Override
    public void dispose() {
        for (LdiResourcesUtil.Resources[] array : this.existenceCheckerArrays.values()) {
            for (int i = 0; i < array.length; ++i) {
                array[i].close();
            }
        }
        this.existenceCheckerArrays.clear();
        this.initialized = false;
    }

    @Override
    public String getActionSuffix() {
        return this.actionSuffix;
    }

    public void setActionSuffix(String actionSuffix) {
        this.actionSuffix = actionSuffix;
    }

    @Override
    public String getFormSuffix() {
        return this.formSuffix;
    }

    public void setFormSuffix(String formSuffix) {
        this.formSuffix = formSuffix;
    }

    @Override
    public String getAssistSuffix() {
        return this.assistSuffix;
    }

    public void setAssistSuffix(String assistSuffix) {
        this.assistSuffix = assistSuffix;
    }

    @Override
    public String getLogicSuffix() {
        return this.logicSuffix;
    }

    public void setLogicSuffix(String logicSuffix) {
        this.logicSuffix = logicSuffix;
    }

    @Override
    public String getServiceSuffix() {
        return this.serviceSuffix;
    }

    public void setServiceSuffix(String serviceSuffix) {
        this.serviceSuffix = serviceSuffix;
    }

    @Override
    public String getRepositorySuffix() {
        return this.repositorySuffix;
    }

    public void setRepositorySuffix(String repositorySuffix) {
        this.repositorySuffix = repositorySuffix;
    }

    @Override
    public String getHelperSuffix() {
        return this.helperSuffix;
    }

    public void setHelperSuffix(String helperSuffix) {
        this.helperSuffix = helperSuffix;
    }

    @Override
    public String getInterceptorSuffix() {
        return this.interceptorSuffix;
    }

    public void setInterceptorSuffix(String interceptorSuffix) {
        this.interceptorSuffix = interceptorSuffix;
    }

    @Override
    public String getValidatorSuffix() {
        return this.validatorSuffix;
    }

    public void setValidatorSuffix(String validatorSuffix) {
        this.validatorSuffix = validatorSuffix;
    }

    @Override
    public String getConverterSuffix() {
        return this.converterSuffix;
    }

    public void setConverterSuffix(String converterSuffix) {
        this.converterSuffix = converterSuffix;
    }

    @Override
    public String getJobSuffix() {
        return this.jobSuffix;
    }

    public void setJobSuffix(String jobSuffix) {
        this.jobSuffix = jobSuffix;
    }

    @Override
    public String getImplementationSuffix() {
        return this.implementationSuffix;
    }

    public void setImplementationSuffix(String implementationSuffix) {
        this.implementationSuffix = implementationSuffix;
    }

    @Override
    public String getLogicPackageName() {
        return this.fromSuffixToPackageName(this.logicSuffix);
    }

    @Override
    public String getServicePackageName() {
        return this.fromSuffixToPackageName(this.serviceSuffix);
    }

    @Override
    public String getRepositoryPackageName() {
        return this.fromSuffixToPackageName(this.repositorySuffix);
    }

    @Override
    public String getHelperPackageName() {
        return this.fromSuffixToPackageName(this.helperSuffix);
    }

    @Override
    public String getInterceptorPackageName() {
        return this.fromSuffixToPackageName(this.interceptorSuffix);
    }

    @Override
    public String getValidatorPackageName() {
        return this.fromSuffixToPackageName(this.validatorSuffix);
    }

    @Override
    public String getConverterPackageName() {
        return this.fromSuffixToPackageName(this.converterSuffix);
    }

    @Override
    public String getImplementationPackageName() {
        return this.fromSuffixToPackageName(this.implementationSuffix);
    }

    @Override
    public String getViewExtension() {
        return this.viewExtension;
    }

    public void setViewExtension(String viewExtension) {
        this.viewExtension = viewExtension;
    }

    @Override
    public String getViewRootPath() {
        return this.viewRootPath;
    }

    public void setViewRootPath(String viewRootPath) {
        this.viewRootPath = viewRootPath;
    }

    @Override
    public String adjustViewRootPath() {
        return "/".equals(this.viewRootPath) ? "" : this.viewRootPath;
    }

    @Override
    public String[] getRootPackageNames() {
        return this.rootPackageNames;
    }

    @Override
    public String[] getIgnorePackageNames() {
        return this.ignorePackageNames;
    }

    @Override
    public String getSubApplicationRootPackageName() {
        return this.webRootPackageName;
    }

    public void setSubApplicationRootPackageName(String subApplicationRootPackageName) {
        this.webRootPackageName = subApplicationRootPackageName;
    }

    @Override
    public String getWebRootPackageName() {
        return this.webRootPackageName;
    }

    public void setWebRootPackageName(String webRootPackageName) {
        this.webRootPackageName = webRootPackageName;
    }

    @Override
    public String getJobRootPackageName() {
        return this.jobRootPackageName;
    }

    public void setJobRootPackageName(String jobRootPackageName) {
        this.jobRootPackageName = jobRootPackageName;
    }

    @Override
    public String getBizRootPackageName() {
        return this.bizRootPackageName;
    }

    public void setBizRootPackageName(String bizRootPackageName) {
        this.bizRootPackageName = bizRootPackageName;
    }
}

