/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.naming.styling;

import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.naming.styling.StylingFreedomInterfaceMapper;
import org.lastaflute.di.util.LdiClassUtil;

public class StylingOptionFactory {
    public StylingFreedomInterfaceMapper prepareFreedomInterfaceMapper() {
        Object mapperInstance;
        String mapperName = LastaDiProperties.getInstance().getNamingStylingFreedomInterfaceMapper();
        if (mapperName == null) {
            return null;
        }
        try {
            Class<?> mapperType = LdiClassUtil.forName(mapperName);
            mapperInstance = LdiClassUtil.newInstance(mapperType);
        }
        catch (RuntimeException e) {
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot instantiate the freedom interface mapper.");
            br.addItem("Advice");
            br.addElement("Confirm your mapper definition specified in lasta_di.properties.");
            br.addElement("For example, the mapper needs default constructor.");
            br.addItem("Mapper Name");
            br.addElement(mapperName);
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg, e);
        }
        try {
            return (StylingFreedomInterfaceMapper)StylingFreedomInterfaceMapper.class.cast(mapperInstance);
        }
        catch (ClassCastException e) {
            String interfaceName = StylingFreedomInterfaceMapper.class.getSimpleName();
            LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
            br.addNotice("Cannot cast the freedom interface mapper.");
            br.addItem("Advice");
            br.addElement("Confirm your mapper definition specified in lasta_di.properties.");
            br.addElement("For example, the mapper should implement " + interfaceName + " interface.");
            br.addItem("Mapper Name");
            br.addElement(mapperName);
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg, e);
        }
    }
}

