/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class LdiSrl {
    protected static final String HARF_LOWER_ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    protected static final String HARF_NUMBER = "0123456789";
    protected static final Set<Character> _alphabetHarfCharSet;
    protected static final Set<Character> _alphabetHarfLowerCharSet;
    protected static final Set<Character> _alphabetHarfUpperCharSet;
    protected static final Set<Character> _numberHarfCharSet;
    protected static final Set<Character> _alphabetHarfNumberHarfCharSet;
    protected static final Set<Character> _alphabetNumberHarfLowerCharSet;
    protected static final Set<Character> _alphabetNumberHarfUpperCharSet;

    public static boolean is_Null_or_Empty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean is_Null_or_TrimmedEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean is_NotNull_and_NotEmpty(String str) {
        return !LdiSrl.is_Null_or_Empty(str);
    }

    public static boolean is_NotNull_and_NotTrimmedEmpty(String str) {
        return !LdiSrl.is_Null_or_TrimmedEmpty(str);
    }

    public static boolean isEmpty(String str) {
        return str != null && str.length() == 0;
    }

    public static boolean isTrimmedEmpty(String str) {
        return str != null && str.trim().length() == 0;
    }

    public static int length(String str) {
        LdiSrl.assertStringNotNull(str);
        return str.length();
    }

    public static String cut(String str, int length) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.cut(str, length, null);
    }

    public static String cut(String str, int length, String suffix) {
        LdiSrl.assertStringNotNull(str);
        return str.length() > length ? str.substring(0, length) + (suffix != null ? suffix : "") : str;
    }

    public static String toLowerCase(String str) {
        LdiSrl.assertStringNotNull(str);
        return str.toLowerCase();
    }

    public static String toUpperCase(String str) {
        LdiSrl.assertStringNotNull(str);
        return str.toUpperCase();
    }

    public static String trim(String str) {
        return LdiSrl.doTrim(str, null);
    }

    public static String trim(String str, String trimStr) {
        return LdiSrl.doTrim(str, trimStr);
    }

    public static String ltrim(String str) {
        return LdiSrl.doLTrim(str, null);
    }

    public static String ltrim(String str, String trimStr) {
        return LdiSrl.doLTrim(str, trimStr);
    }

    public static String rtrim(String str) {
        return LdiSrl.doRTrim(str, null);
    }

    public static String rtrim(String str, String trimStr) {
        return LdiSrl.doRTrim(str, trimStr);
    }

    protected static String doTrim(String str, String trimStr) {
        return LdiSrl.doRTrim(LdiSrl.doLTrim(str, trimStr), trimStr);
    }

    protected static String doLTrim(String str, String trimStr) {
        LdiSrl.assertStringNotNull(str);
        if (trimStr == null) {
            String notTrimmedString = "a";
            String trimmed = (str + "a").trim();
            return trimmed.substring(0, trimmed.length() - "a".length());
        }
        String trimmed = str;
        while (trimmed.startsWith(trimStr)) {
            trimmed = LdiSrl.substringFirstRear(trimmed, trimStr);
        }
        return trimmed;
    }

    protected static String doRTrim(String str, String trimStr) {
        LdiSrl.assertStringNotNull(str);
        if (trimStr == null) {
            String notTrimmedString = "a";
            return ("a" + str).trim().substring("a".length());
        }
        String trimmed = str;
        while (trimmed.endsWith(trimStr)) {
            trimmed = LdiSrl.substringLastFront(trimmed, trimStr);
        }
        return trimmed;
    }

    public static String replace(String str, String fromStr, String toStr) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertFromStringNotNull(fromStr);
        LdiSrl.assertToStringNotNull(toStr);
        StringBuilder sb = null;
        int pos = 0;
        int pos2 = 0;
        while (true) {
            pos = str.indexOf(fromStr, pos2);
            if (pos2 == 0 && pos < 0) {
                return str;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (pos == 0) {
                sb.append(toStr);
                pos2 = fromStr.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(str.substring(pos2, pos));
            sb.append(toStr);
            pos2 = pos + fromStr.length();
        }
        sb.append(str.substring(pos2));
        return sb.toString();
    }

    public static String replaceBy(String str, Map<String, String> fromToMap) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertFromToMapNotNull(fromToMap);
        Set<Map.Entry<String, String>> entrySet = fromToMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            str = LdiSrl.replace(str, entry.getKey(), entry.getValue());
        }
        return str;
    }

    public static String replaceScopeContent(String str, String fromStr, String toStr, String beginMark, String endMark) {
        List<ScopeInfo> scopeList = LdiSrl.extractScopeList(str, beginMark, endMark);
        if (scopeList.isEmpty()) {
            return str;
        }
        return scopeList.get(0).replaceContentOnBaseString(fromStr, toStr);
    }

    public static String replaceScopeInterspace(String str, String fromStr, String toStr, String beginMark, String endMark) {
        List<ScopeInfo> scopeList = LdiSrl.extractScopeList(str, beginMark, endMark);
        if (scopeList.isEmpty()) {
            return str;
        }
        return scopeList.get(0).replaceInterspaceOnBaseString(fromStr, toStr);
    }

    public static List<String> splitList(String str, String delimiter) {
        return LdiSrl.doSplitList(str, delimiter, false);
    }

    public static List<String> splitListTrimmed(String str, String delimiter) {
        return LdiSrl.doSplitList(str, delimiter, true);
    }

    protected static List<String> doSplitList(String str, String delimiter, boolean trim) {
        String element;
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertDelimiterNotNull(delimiter);
        ArrayList<String> list = new ArrayList<String>();
        int elementIndex = 0;
        int delimiterIndex = str.indexOf(delimiter);
        while (delimiterIndex >= 0) {
            element = str.substring(elementIndex, delimiterIndex);
            list.add(trim ? element.trim() : element);
            elementIndex = delimiterIndex + delimiter.length();
            delimiterIndex = str.indexOf(delimiter, elementIndex);
        }
        element = str.substring(elementIndex);
        list.add(trim ? element.trim() : element);
        return list;
    }

    public static IndexOfInfo indexOfFirst(String str, String ... delimiters) {
        return LdiSrl.doIndexOfFirst(false, str, delimiters);
    }

    public static IndexOfInfo indexOfFirstIgnoreCase(String str, String ... delimiters) {
        return LdiSrl.doIndexOfFirst(true, str, delimiters);
    }

    protected static IndexOfInfo doIndexOfFirst(boolean ignoreCase, String str, String ... delimiters) {
        return LdiSrl.doIndexOf(ignoreCase, false, str, delimiters);
    }

    public static IndexOfInfo indexOfLast(String str, String ... delimiters) {
        return LdiSrl.doIndexOfLast(false, str, delimiters);
    }

    public static IndexOfInfo indexOfLastIgnoreCase(String str, String ... delimiters) {
        return LdiSrl.doIndexOfLast(true, str, delimiters);
    }

    protected static IndexOfInfo doIndexOfLast(boolean ignoreCase, String str, String ... delimiters) {
        return LdiSrl.doIndexOf(ignoreCase, true, str, delimiters);
    }

    protected static IndexOfInfo doIndexOf(boolean ignoreCase, boolean last, String str, String ... delimiters) {
        String filteredStr = ignoreCase ? str.toLowerCase() : str;
        int targetIndex = -1;
        String targetDelimiter = null;
        for (String delimiter : delimiters) {
            String filteredDelimiter = ignoreCase ? delimiter.toLowerCase() : delimiter;
            int index = last ? filteredStr.lastIndexOf(filteredDelimiter) : filteredStr.indexOf(filteredDelimiter);
            if (index < 0 || targetIndex >= 0 && !(last ? targetIndex < index : targetIndex > index)) continue;
            targetIndex = index;
            targetDelimiter = delimiter;
        }
        if (targetIndex < 0) {
            return null;
        }
        IndexOfInfo info = new IndexOfInfo();
        info.setBaseString(str);
        info.setIndex(targetIndex);
        info.setDelimiter(targetDelimiter);
        return info;
    }

    public static String substring(String str, int beginIndex) {
        LdiSrl.assertStringNotNull(str);
        if (str.length() < beginIndex) {
            String msg = "The length of the string was smaller than the begin index:";
            msg = msg + " str=" + str + ", beginIndex=" + beginIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        return str.substring(beginIndex);
    }

    public static String substring(String str, int beginIndex, int endIndex) {
        LdiSrl.assertStringNotNull(str);
        if (str.length() < beginIndex) {
            String msg = "The length of the string was smaller than the begin index:";
            msg = msg + " str=" + str + " beginIndex=" + beginIndex + " endIndex=" + endIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        if (str.length() < endIndex) {
            String msg = "The length of the string was smaller than the end index:";
            msg = msg + " str=" + str + " beginIndex=" + beginIndex + " endIndex=" + endIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        if (beginIndex > endIndex) {
            String msg = "The begin index was larger than the end index:";
            msg = msg + " str=" + str + " beginIndex=" + beginIndex + " endIndex=" + endIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        return str.substring(beginIndex, endIndex);
    }

    public static String frontstring(String str, int index) {
        LdiSrl.assertStringNotNull(str);
        if (str.length() < index) {
            String msg = "The length of the string was smaller than the index:";
            msg = msg + " str=" + str + " index=" + index;
            throw new StringIndexOutOfBoundsException(msg);
        }
        return str.substring(0, index);
    }

    public static String rearstring(String str, int reverseIndex) {
        LdiSrl.assertStringNotNull(str);
        if (str.length() < reverseIndex) {
            String msg = "The length of the string was smaller than the index:";
            msg = msg + " str=" + str + " reverseIndex=" + reverseIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        return str.substring(str.length() - reverseIndex);
    }

    public static String substringFirstFront(String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.doSubstringFirstRear(false, false, false, str, delimiters);
    }

    public static String substringFirstFrontIgnoreCase(String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.doSubstringFirstRear(false, false, true, str, delimiters);
    }

    public static String substringFirstRear(String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.doSubstringFirstRear(false, true, false, str, delimiters);
    }

    public static String substringFirstRearIgnoreCase(String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.doSubstringFirstRear(false, true, true, str, delimiters);
    }

    public static String substringLastFront(String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.doSubstringFirstRear(true, false, false, str, delimiters);
    }

    public static String substringLastFrontIgnoreCase(String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.doSubstringFirstRear(true, false, true, str, delimiters);
    }

    public static String substringLastRear(String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.doSubstringFirstRear(true, true, false, str, delimiters);
    }

    public static String substringLastRearIgnoreCase(String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.doSubstringFirstRear(true, true, true, str, delimiters);
    }

    protected static final String doSubstringFirstRear(boolean last, boolean rear, boolean ignoreCase, String str, String ... delimiters) {
        LdiSrl.assertStringNotNull(str);
        IndexOfInfo info = ignoreCase ? (last ? LdiSrl.indexOfLastIgnoreCase(str, delimiters) : LdiSrl.indexOfFirstIgnoreCase(str, delimiters)) : (last ? LdiSrl.indexOfLast(str, delimiters) : LdiSrl.indexOfFirst(str, delimiters));
        if (info == null) {
            return str;
        }
        if (rear) {
            return str.substring(info.getIndex() + info.getDelimiter().length());
        }
        return str.substring(0, info.getIndex());
    }

    public static boolean contains(String str, String keyword) {
        return LdiSrl.containsAll(str, keyword);
    }

    public static boolean containsIgnoreCase(String str, String keyword) {
        return LdiSrl.containsAllIgnoreCase(str, keyword);
    }

    public static boolean containsAll(String str, String ... keywords) {
        return LdiSrl.doContainsAll(false, str, keywords);
    }

    public static boolean containsAllIgnoreCase(String str, String ... keywords) {
        return LdiSrl.doContainsAll(true, str, keywords);
    }

    protected static boolean doContainsAll(boolean ignoreCase, String str, String ... keywords) {
        LdiSrl.assertStringNotNull(str);
        if (keywords == null || keywords.length == 0) {
            return false;
        }
        String filtered = ignoreCase ? str.toLowerCase() : str;
        for (String keyword : keywords) {
            if (ignoreCase) {
                String string = keyword = keyword != null ? keyword.toLowerCase() : null;
            }
            if (keyword != null && filtered.contains(keyword)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String str, String ... keywords) {
        return LdiSrl.doContainsAny(false, str, keywords);
    }

    public static boolean containsAnyIgnoreCase(String str, String ... keywords) {
        return LdiSrl.doContainsAny(true, str, keywords);
    }

    protected static boolean doContainsAny(boolean ignoreCase, String str, String ... keywords) {
        LdiSrl.assertStringNotNull(str);
        if (keywords == null || keywords.length == 0) {
            return false;
        }
        String filtered = ignoreCase ? str.toLowerCase() : str;
        for (String keyword : keywords) {
            if (ignoreCase) {
                String string = keyword = keyword != null ? keyword.toLowerCase() : null;
            }
            if (keyword == null || !filtered.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOrderedAll(String str, String ... keywords) {
        return LdiSrl.doContainsOrderedAll(false, str, keywords);
    }

    public static boolean containsOrderedAllIgnoreCase(String str, String ... keywords) {
        return LdiSrl.doContainsOrderedAll(true, str, keywords);
    }

    protected static boolean doContainsOrderedAll(boolean ignoreCase, String str, String ... keywords) {
        LdiSrl.assertStringNotNull(str);
        if (keywords == null || keywords.length == 0) {
            return false;
        }
        String current = ignoreCase ? str.toLowerCase() : str;
        for (String keyword : keywords) {
            if (ignoreCase) {
                String string = keyword = keyword != null ? keyword.toLowerCase() : null;
            }
            if (keyword == null || !current.contains(keyword)) {
                return false;
            }
            current = LdiSrl.substringFirstRear(current, keyword);
        }
        return true;
    }

    public static boolean containsElement(Collection<String> strList, String element) {
        return LdiSrl.containsElementAll(strList, element);
    }

    public static boolean containsElementIgnoreCase(Collection<String> strList, String element) {
        return LdiSrl.containsElementAllIgnoreCase(strList, element);
    }

    public static boolean containsElementAll(Collection<String> strList, String ... elements) {
        return LdiSrl.doContainsElementAll(false, strList, elements);
    }

    public static boolean containsElementAllIgnoreCase(Collection<String> strList, String ... elements) {
        return LdiSrl.doContainsElementAll(true, strList, elements);
    }

    protected static boolean doContainsElementAll(boolean ignoreCase, Collection<String> strList, String ... elements) {
        LdiSrl.assertStringListNotNull(strList);
        LdiSrl.assertElementVaryingNotNull(elements);
        return LdiSrl.doContainsElement(true, ignoreCase, ListElementContainsType.EQUAL, strList, elements);
    }

    public static boolean containsElementAny(Collection<String> strList, String ... elements) {
        return LdiSrl.doContainsElementAny(false, strList, elements);
    }

    public static boolean containsElementAnyIgnoreCase(Collection<String> strList, String ... elements) {
        return LdiSrl.doContainsElementAny(true, strList, elements);
    }

    protected static boolean doContainsElementAny(boolean ignoreCase, Collection<String> strList, String ... elements) {
        LdiSrl.assertStringListNotNull(strList);
        LdiSrl.assertElementVaryingNotNull(elements);
        return LdiSrl.doContainsElement(false, ignoreCase, ListElementContainsType.EQUAL, strList, elements);
    }

    protected static boolean doContainsElement(boolean all, boolean ignoreCase, ListElementContainsType type, Collection<String> strList, String ... elements) {
        LdiSrl.assertStringListNotNull(strList);
        LdiSrl.assertElementVaryingNotNull(elements);
        if (elements.length == 0) {
            return false;
        }
        for (String element : elements) {
            boolean exists = false;
            for (String current : strList) {
                boolean result = ignoreCase ? (ListElementContainsType.PREFIX.equals((Object)type) ? (current != null ? LdiSrl.startsWithIgnoreCase(current, element) : false) : (ListElementContainsType.SUFFIX.equals((Object)type) ? (current != null ? LdiSrl.endsWithIgnoreCase(current, element) : false) : (ListElementContainsType.KEYWORD.equals((Object)type) ? (current != null ? LdiSrl.containsIgnoreCase(current, element) : false) : LdiSrl.equalsIgnoreCase(current, element)))) : (ListElementContainsType.PREFIX.equals((Object)type) ? (current != null ? LdiSrl.startsWith(current, element) : false) : (ListElementContainsType.SUFFIX.equals((Object)type) ? (current != null ? LdiSrl.endsWith(current, element) : false) : (ListElementContainsType.KEYWORD.equals((Object)type) ? (current != null ? LdiSrl.contains(current, element) : false) : LdiSrl.equalsPlain(current, element))));
                if (!result) continue;
                exists = true;
            }
            if (all) {
                if (exists) continue;
                return false;
            }
            if (!exists) continue;
            return true;
        }
        return all;
    }

    public static boolean containsKeyword(Collection<String> strList, String keyword) {
        return LdiSrl.containsKeywordAll(strList, keyword);
    }

    public static boolean containsKeywordIgnoreCase(Collection<String> strList, String keyword) {
        return LdiSrl.containsKeywordAllIgnoreCase(strList, keyword);
    }

    public static boolean containsKeywordAll(Collection<String> strList, String ... keywords) {
        return LdiSrl.doContainsKeywordAll(false, strList, keywords);
    }

    public static boolean containsKeywordAllIgnoreCase(Collection<String> strList, String ... keywords) {
        return LdiSrl.doContainsKeywordAll(true, strList, keywords);
    }

    protected static boolean doContainsKeywordAll(boolean ignoreCase, Collection<String> strList, String ... keywords) {
        LdiSrl.assertStringListNotNull(strList);
        LdiSrl.assertKeywordVaryingNotNull(keywords);
        return LdiSrl.doContainsElement(true, ignoreCase, ListElementContainsType.KEYWORD, strList, keywords);
    }

    public static boolean containsKeywordAny(Collection<String> strList, String ... keywords) {
        return LdiSrl.doContainsKeywordAny(false, strList, keywords);
    }

    public static boolean containsKeywordAnyIgnoreCase(Collection<String> strList, String ... keywords) {
        return LdiSrl.doContainsKeywordAny(true, strList, keywords);
    }

    protected static boolean doContainsKeywordAny(boolean ignoreCase, Collection<String> strList, String ... keywords) {
        LdiSrl.assertStringListNotNull(strList);
        LdiSrl.assertKeywordVaryingNotNull(keywords);
        return LdiSrl.doContainsElement(false, ignoreCase, ListElementContainsType.KEYWORD, strList, keywords);
    }

    public static boolean containsPrefix(Collection<String> strList, String prefix) {
        return LdiSrl.containsPrefixAll(strList, prefix);
    }

    public static boolean containsPrefixIgnoreCase(Collection<String> strList, String prefix) {
        return LdiSrl.containsPrefixAllIgnoreCase(strList, prefix);
    }

    public static boolean containsPrefixAll(Collection<String> strList, String ... prefixes) {
        return LdiSrl.doContainsPrefixAll(false, strList, prefixes);
    }

    public static boolean containsPrefixAllIgnoreCase(Collection<String> strList, String ... prefixes) {
        return LdiSrl.doContainsPrefixAll(true, strList, prefixes);
    }

    protected static boolean doContainsPrefixAll(boolean ignoreCase, Collection<String> strList, String ... prefixes) {
        LdiSrl.assertStringListNotNull(strList);
        return LdiSrl.doContainsElement(true, ignoreCase, ListElementContainsType.PREFIX, strList, prefixes);
    }

    public static boolean containsPrefixAny(Collection<String> strList, String ... prefixes) {
        return LdiSrl.doContainsPrefixAny(false, strList, prefixes);
    }

    public static boolean containsPrefixAnyIgnoreCase(Collection<String> strList, String ... prefixes) {
        return LdiSrl.doContainsPrefixAny(true, strList, prefixes);
    }

    protected static boolean doContainsPrefixAny(boolean ignoreCase, Collection<String> strList, String ... prefixes) {
        LdiSrl.assertStringListNotNull(strList);
        return LdiSrl.doContainsElement(false, ignoreCase, ListElementContainsType.PREFIX, strList, prefixes);
    }

    public static boolean containsSuffix(Collection<String> strList, String suffix) {
        return LdiSrl.containsSuffixAll(strList, suffix);
    }

    public static boolean containsSuffixIgnoreCase(Collection<String> strList, String suffix) {
        return LdiSrl.containsSuffixAllIgnoreCase(strList, suffix);
    }

    public static boolean containsSuffixAll(Collection<String> strList, String ... suffixes) {
        return LdiSrl.doContainsSuffixAll(false, strList, suffixes);
    }

    public static boolean containsSuffixAllIgnoreCase(Collection<String> strList, String ... suffixes) {
        return LdiSrl.doContainsSuffixAll(true, strList, suffixes);
    }

    protected static boolean doContainsSuffixAll(boolean ignoreCase, Collection<String> strList, String ... suffixes) {
        LdiSrl.assertStringListNotNull(strList);
        return LdiSrl.doContainsElement(true, ignoreCase, ListElementContainsType.SUFFIX, strList, suffixes);
    }

    public static boolean containsSuffixAny(Collection<String> strList, String ... suffixes) {
        return LdiSrl.doContainsSuffixAny(false, strList, suffixes);
    }

    public static boolean containsSuffixAnyIgnoreCase(Collection<String> strList, String ... suffixes) {
        return LdiSrl.doContainsSuffixAny(true, strList, suffixes);
    }

    protected static boolean doContainsSuffixAny(boolean ignoreCase, Collection<String> strList, String ... suffixes) {
        LdiSrl.assertStringListNotNull(strList);
        return LdiSrl.doContainsElement(false, ignoreCase, ListElementContainsType.SUFFIX, strList, suffixes);
    }

    public static final boolean startsWith(String str, String ... prefixes) {
        return LdiSrl.doStartsWith(false, str, prefixes);
    }

    public static final boolean startsWithIgnoreCase(String str, String ... prefixes) {
        return LdiSrl.doStartsWith(true, str, prefixes);
    }

    protected static final boolean doStartsWith(boolean ignoreCase, String str, String ... prefixes) {
        LdiSrl.assertStringNotNull(str);
        if (prefixes == null || prefixes.length == 0) {
            return false;
        }
        String filtered = ignoreCase ? str.toLowerCase() : str;
        for (String prefix : prefixes) {
            if (prefix == null || !filtered.startsWith(ignoreCase ? prefix.toLowerCase() : prefix)) continue;
            return true;
        }
        return false;
    }

    public static final boolean endsWith(String str, String ... suffixes) {
        return LdiSrl.doEndsWith(false, str, suffixes);
    }

    public static final boolean endsWithIgnoreCase(String str, String ... suffixes) {
        return LdiSrl.doEndsWith(true, str, suffixes);
    }

    protected static final boolean doEndsWith(boolean ignoreCase, String str, String ... suffixes) {
        LdiSrl.assertStringNotNull(str);
        if (suffixes == null || suffixes.length == 0) {
            return false;
        }
        String filtered = ignoreCase ? str.toLowerCase() : str;
        for (String suffix : suffixes) {
            if (suffix == null || !filtered.endsWith(ignoreCase ? suffix.toLowerCase() : suffix)) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasKeywordAll(String keyword, String ... strs) {
        return LdiSrl.doHasKeywordAll(false, keyword, strs);
    }

    public static final boolean hasKeywordAllIgnoreCase(String keyword, String ... strs) {
        return LdiSrl.doHasKeywordAll(true, keyword, strs);
    }

    protected static final boolean doHasKeywordAll(boolean ignoreCase, String keyword, String ... strs) {
        LdiSrl.assertKeywordNotNull(keyword);
        return LdiSrl.doHasKeyword(true, ignoreCase, KeywordType.CONTAIN, keyword, strs);
    }

    public static final boolean hasKeywordAny(String keyword, String ... strs) {
        return LdiSrl.doHasKeywordAny(false, keyword, strs);
    }

    public static final boolean hasKeywordAnyIgnoreCase(String keyword, String ... strs) {
        return LdiSrl.doHasKeywordAny(true, keyword, strs);
    }

    protected static final boolean doHasKeywordAny(boolean ignoreCase, String keyword, String ... strs) {
        LdiSrl.assertKeywordNotNull(keyword);
        return LdiSrl.doHasKeyword(false, ignoreCase, KeywordType.CONTAIN, keyword, strs);
    }

    protected static final boolean doHasKeyword(boolean all, boolean ignoreCase, KeywordType type, String keyword, String ... strs) {
        LdiSrl.assertKeywordNotNull(keyword);
        if (strs == null || strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            boolean result;
            if (ignoreCase) {
                result = KeywordType.PREFIX.equals((Object)type) ? (str != null ? LdiSrl.startsWithIgnoreCase(str, keyword) : false) : (KeywordType.SUFFIX.equals((Object)type) ? (str != null ? LdiSrl.endsWithIgnoreCase(str, keyword) : false) : (str != null ? LdiSrl.containsIgnoreCase(str, keyword) : false));
            } else if (KeywordType.PREFIX.equals((Object)type)) {
                result = str != null ? LdiSrl.startsWith(str, keyword) : false;
            } else if (KeywordType.SUFFIX.equals((Object)type)) {
                result = str != null ? LdiSrl.endsWith(str, keyword) : false;
            } else {
                boolean bl = result = str != null ? LdiSrl.contains(str, keyword) : false;
            }
            if (all) {
                if (result) continue;
                return false;
            }
            if (!result) continue;
            return true;
        }
        return all;
    }

    public static final boolean hasPrefixAll(String prefix, String ... strs) {
        return LdiSrl.doHasPrefixAll(false, prefix, strs);
    }

    public static final boolean hasPrefixAllIgnoreCase(String prefix, String ... strs) {
        return LdiSrl.doHasPrefixAll(true, prefix, strs);
    }

    protected static final boolean doHasPrefixAll(boolean ignoreCase, String prefix, String ... strs) {
        LdiSrl.assertPrefixNotNull(prefix);
        return LdiSrl.doHasKeyword(true, ignoreCase, KeywordType.PREFIX, prefix, strs);
    }

    public static final boolean hasPrefixAny(String prefix, String ... strs) {
        return LdiSrl.doHasPrefixAny(false, prefix, strs);
    }

    public static final boolean hasPrefixAnyIgnoreCase(String prefix, String ... strs) {
        return LdiSrl.doHasPrefixAny(true, prefix, strs);
    }

    protected static final boolean doHasPrefixAny(boolean ignoreCase, String prefix, String ... strs) {
        LdiSrl.assertPrefixNotNull(prefix);
        return LdiSrl.doHasKeyword(false, ignoreCase, KeywordType.PREFIX, prefix, strs);
    }

    public static final boolean hasSuffixAll(String suffix, String ... strs) {
        return LdiSrl.doHasSuffixAll(false, suffix, strs);
    }

    public static final boolean hasSuffixAllIgnoreCase(String suffix, String ... strs) {
        return LdiSrl.doHasSuffixAll(true, suffix, strs);
    }

    protected static final boolean doHasSuffixAll(boolean ignoreCase, String suffix, String ... strs) {
        LdiSrl.assertSuffixNotNull(suffix);
        return LdiSrl.doHasKeyword(true, ignoreCase, KeywordType.SUFFIX, suffix, strs);
    }

    public static final boolean hasSuffixAny(String suffix, String ... strs) {
        return LdiSrl.doHasSuffixAny(false, suffix, strs);
    }

    public static final boolean hasSuffixAnyIgnoreCase(String suffix, String ... strs) {
        return LdiSrl.doHasSuffixAny(true, suffix, strs);
    }

    protected static final boolean doHasSuffixAny(boolean ignoreCase, String suffix, String ... strs) {
        LdiSrl.assertSuffixNotNull(suffix);
        return LdiSrl.doHasKeyword(false, ignoreCase, KeywordType.SUFFIX, suffix, strs);
    }

    public static int count(String str, String element) {
        return LdiSrl.doCount(str, element, false);
    }

    public static int countIgnoreCase(String str, String element) {
        return LdiSrl.doCount(str, element, true);
    }

    protected static int doCount(String str, String element, boolean ignoreCase) {
        int index;
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertElementNotNull(element);
        String filteredStr = ignoreCase ? str.toLowerCase() : str;
        String filteredElement = ignoreCase ? element.toLowerCase() : element;
        int count = 0;
        int baseIndex = 0;
        while ((index = filteredStr.indexOf(filteredElement, baseIndex)) >= 0) {
            baseIndex = index + filteredElement.length();
            ++count;
        }
        return count;
    }

    public static boolean equalsIgnoreCase(String str1, String ... strs) {
        if (strs != null) {
            for (String element : strs) {
                if ((str1 == null || !str1.equalsIgnoreCase(element)) && (str1 != null || element != null)) continue;
                return true;
            }
            return false;
        }
        return str1 == null;
    }

    public static boolean equalsFlexible(String str1, String ... strs) {
        if (strs != null) {
            str1 = str1 != null ? LdiSrl.replace(str1, "_", "") : null;
            for (String element : strs) {
                String string = element = element != null ? LdiSrl.replace(element, "_", "") : null;
                if ((str1 == null || !str1.equalsIgnoreCase(element)) && (str1 != null || element != null)) continue;
                return true;
            }
            return false;
        }
        return str1 == null;
    }

    public static boolean equalsFlexibleTrimmed(String str1, String ... strs) {
        String string = str1 = str1 != null ? str1.trim() : null;
        if (strs != null) {
            String[] trimmedStrs = new String[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                String element = strs[i];
                trimmedStrs[i] = element != null ? element.trim() : null;
            }
            return LdiSrl.equalsFlexible(str1, trimmedStrs);
        }
        return LdiSrl.equalsFlexible(str1, null);
    }

    public static boolean equalsPlain(String str1, String ... strs) {
        if (strs != null) {
            for (String element : strs) {
                if ((str1 == null || !str1.equals(element)) && (str1 != null || element != null)) continue;
                return true;
            }
            return false;
        }
        return str1 == null;
    }

    public static String connectByDelimiter(Collection<String> strList, String delimiter) {
        LdiSrl.assertStringListNotNull(strList);
        return LdiSrl.doConnectByDelimiter(strList, delimiter, null);
    }

    public static String connectByDelimiterQuoted(Collection<String> strList, String delimiter, String quotation) {
        LdiSrl.assertStringListNotNull(strList);
        LdiSrl.assertQuotationNotNull(quotation);
        return LdiSrl.doConnectByDelimiter(strList, delimiter, quotation);
    }

    protected static String doConnectByDelimiter(Collection<String> strList, String delimiter, String quotation) {
        LdiSrl.assertStringListNotNull(strList);
        StringBuilder sb = new StringBuilder();
        for (String str : strList) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(quotation != null ? LdiSrl.quoteAnything(str != null ? str : "null", quotation) : str);
        }
        return sb.toString();
    }

    public static String connectPrefix(String str, String prefix, String delimiter) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.is_NotNull_and_NotTrimmedEmpty(prefix) ? prefix + delimiter + str : str;
    }

    public static String connectSuffix(String str, String suffix, String delimiter) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.is_NotNull_and_NotTrimmedEmpty(suffix) ? str + delimiter + suffix : str;
    }

    public static String removePrefix(String str, String prefix) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.startsWith(str, prefix) ? LdiSrl.substringFirstRear(str, prefix) : str;
    }

    public static String removePrefixIgnoreCase(String str, String prefix) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.startsWithIgnoreCase(str, prefix) ? LdiSrl.substringFirstRearIgnoreCase(str, prefix) : str;
    }

    public static String removeSuffix(String str, String suffix) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.endsWith(str, suffix) ? LdiSrl.substringLastFront(str, suffix) : str;
    }

    public static String removeSuffixIgnoreCase(String str, String suffix) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.endsWithIgnoreCase(str, suffix) ? LdiSrl.substringLastFrontIgnoreCase(str, suffix) : str;
    }

    public static String rfill(String str, int size) {
        return LdiSrl.doFill(str, size, false, Character.valueOf(' '));
    }

    public static String rfill(String str, int size, Character addedChar) {
        return LdiSrl.doFill(str, size, false, addedChar);
    }

    public static String lfill(String str, int size) {
        return LdiSrl.doFill(str, size, true, Character.valueOf(' '));
    }

    public static String lfill(String str, int size, Character addedChar) {
        return LdiSrl.doFill(str, size, true, addedChar);
    }

    protected static String doFill(String str, int size, boolean left, Character addedChar) {
        LdiSrl.assertStringNotNull(str);
        if (str.length() >= size) {
            return str;
        }
        int addSize = size - str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < addSize; ++i) {
            sb.append(addedChar);
        }
        if (left) {
            return sb + str;
        }
        return str + sb;
    }

    public static boolean isQuotedAnything(String str, String quotation) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertQuotationNotNull(quotation);
        return LdiSrl.isQuotedAnything(str, quotation, quotation);
    }

    public static boolean isQuotedAnything(String str, String beginMark, String endMark) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertBeginMarkNotNull(beginMark);
        LdiSrl.assertEndMarkNotNull(endMark);
        return str.length() > 1 && str.startsWith(beginMark) && str.endsWith(endMark);
    }

    public static boolean isQuotedDouble(String str) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.isQuotedAnything(str, "\"");
    }

    public static boolean isQuotedSingle(String str) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.isQuotedAnything(str, "'");
    }

    public static String quoteAnything(String str, String quotation) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertQuotationNotNull(quotation);
        return LdiSrl.quoteAnything(str, quotation, quotation);
    }

    public static String quoteAnything(String str, String beginMark, String endMark) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertBeginMarkNotNull(beginMark);
        LdiSrl.assertEndMarkNotNull(endMark);
        return beginMark + str + endMark;
    }

    public static String quoteDouble(String str) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.quoteAnything(str, "\"");
    }

    public static String quoteSingle(String str) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.quoteAnything(str, "'");
    }

    public static String unquoteAnything(String str, String quotation) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertQuotationNotNull(quotation);
        return LdiSrl.unquoteAnything(str, quotation, quotation);
    }

    public static String unquoteAnything(String str, String beginMark, String endMark) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertBeginMarkNotNull(beginMark);
        LdiSrl.assertEndMarkNotNull(endMark);
        if (!LdiSrl.isQuotedAnything(str, beginMark, endMark)) {
            return str;
        }
        str = LdiSrl.substring(str, beginMark.length());
        str = LdiSrl.substring(str, 0, str.length() - endMark.length());
        return str;
    }

    public static String unquoteDouble(String str) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.unquoteAnything(str, "\"");
    }

    public static String unquoteSingle(String str) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.unquoteAnything(str, "'");
    }

    public static final List<DelimiterInfo> extractDelimiterList(String str, String delimiter) {
        int beginIndex;
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertDelimiterNotNull(delimiter);
        ArrayList<DelimiterInfo> delimiterList = new ArrayList<DelimiterInfo>();
        DelimiterInfo previous = null;
        String rear = str;
        while ((beginIndex = rear.indexOf(delimiter)) >= 0) {
            DelimiterInfo info = new DelimiterInfo();
            info.setBaseString(str);
            info.setDelimiter(delimiter);
            int absoluteIndex = (previous != null ? previous.getEndIndex() : 0) + beginIndex;
            info.setBeginIndex(absoluteIndex);
            info.setEndIndex(absoluteIndex + delimiter.length());
            if (previous != null) {
                info.setPrevious(previous);
                previous.setNext(info);
            }
            delimiterList.add(info);
            previous = info;
            rear = str.substring(info.getEndIndex());
        }
        return delimiterList;
    }

    public static <ELEMENT> String delimit(Collection<ELEMENT> list, Function<ELEMENT, String> oneArgInLambda, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (ELEMENT element : list) {
            if (index > 0) {
                sb.append(delimiter);
            }
            sb.append(oneArgInLambda.apply(element));
            ++index;
        }
        return sb.toString();
    }

    public static final ScopeInfo extractScopeFirst(String str, String beginMark, String endMark) {
        List<ScopeInfo> scopeList = LdiSrl.doExtractScopeList(str, beginMark, endMark, true);
        if (scopeList == null || scopeList.isEmpty()) {
            return null;
        }
        if (scopeList.size() > 1) {
            String msg = "This method should extract only one scope: " + scopeList;
            throw new IllegalStateException(msg);
        }
        return scopeList.get(0);
    }

    public static final ScopeInfo extractScopeLast(String str, String beginMark, String endMark) {
        List<ScopeInfo> scopeList = LdiSrl.doExtractScopeList(str, beginMark, endMark, false);
        if (scopeList == null || scopeList.isEmpty()) {
            return null;
        }
        return scopeList.get(scopeList.size() - 1);
    }

    public static final List<ScopeInfo> extractScopeList(String str, String beginMark, String endMark) {
        ArrayList scopeList = LdiSrl.doExtractScopeList(str, beginMark, endMark, false);
        return scopeList != null ? scopeList : new ArrayList();
    }

    protected static final List<ScopeInfo> doExtractScopeList(String str, String beginMark, String endMark, boolean firstOnly) {
        int endIndex;
        int beginIndex;
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertBeginMarkNotNull(beginMark);
        LdiSrl.assertEndMarkNotNull(endMark);
        ArrayList<ScopeInfo> resultList = null;
        ScopeInfo previous = null;
        String rear = str;
        while ((beginIndex = rear.indexOf(beginMark)) >= 0 && (rear = rear.substring(beginIndex)).length() > beginMark.length() && (endIndex = (rear = rear.substring(beginMark.length())).indexOf(endMark)) >= 0) {
            String scope = beginMark + rear.substring(0, endIndex + endMark.length());
            ScopeInfo info = new ScopeInfo();
            info.setBaseString(str);
            int absoluteIndex = (previous != null ? previous.getEndIndex() : 0) + beginIndex;
            info.setBeginIndex(absoluteIndex);
            info.setEndIndex(absoluteIndex + scope.length());
            info.setBeginMark(beginMark);
            info.setEndMark(endMark);
            info.setContent(LdiSrl.rtrim(LdiSrl.ltrim(scope, beginMark), endMark));
            info.setScope(scope);
            if (previous != null) {
                info.setPrevious(previous);
                previous.setNext(info);
            }
            if (resultList == null) {
                resultList = new ArrayList<ScopeInfo>();
            }
            resultList.add(info);
            if (previous == null && firstOnly) break;
            previous = info;
            rear = str.substring(info.getEndIndex());
        }
        return resultList;
    }

    public static final ScopeInfo extractScopeWide(String str, String beginMark, String endMark) {
        LdiSrl.assertStringNotNull(str);
        LdiSrl.assertBeginMarkNotNull(beginMark);
        LdiSrl.assertEndMarkNotNull(endMark);
        IndexOfInfo first = LdiSrl.indexOfFirst(str, beginMark);
        if (first == null) {
            return null;
        }
        IndexOfInfo last = LdiSrl.indexOfLast(str, endMark);
        if (last == null) {
            return null;
        }
        String content = str.substring(first.getIndex() + first.getDelimiter().length(), last.getIndex());
        ScopeInfo info = new ScopeInfo();
        info.setBaseString(str);
        info.setBeginIndex(first.getIndex());
        info.setEndIndex(last.getIndex() + endMark.length());
        info.setBeginMark(beginMark);
        info.setEndMark(endMark);
        info.setContent(content);
        info.setScope(beginMark + content + endMark);
        return info;
    }

    public static String removeScope(String str, String beginMark, String endMark) {
        LdiSrl.assertStringNotNull(str);
        StringBuilder sb = new StringBuilder();
        String rear = str;
        while (true) {
            int beginIndex;
            if ((beginIndex = rear.indexOf(beginMark)) < 0) {
                sb.append(rear);
                break;
            }
            int endIndex = rear.indexOf(endMark);
            if (endIndex < 0) {
                sb.append(rear);
                break;
            }
            if (beginIndex > endIndex) {
                int borderIndex = endIndex + endMark.length();
                sb.append(rear.substring(0, borderIndex));
                rear = rear.substring(borderIndex);
                continue;
            }
            sb.append(rear.substring(0, beginIndex));
            rear = rear.substring(endIndex + endMark.length());
        }
        return sb.toString();
    }

    public static String initCap(String str) {
        LdiSrl.assertStringNotNull(str);
        if (LdiSrl.is_Null_or_Empty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String initCapTrimmed(String str) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.initCap(str.trim());
    }

    public static String initUncap(String str) {
        LdiSrl.assertStringNotNull(str);
        if (LdiSrl.is_Null_or_Empty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String initUncapTrimmed(String str) {
        LdiSrl.assertStringNotNull(str);
        return LdiSrl.initUncap(str.trim());
    }

    public static String initBeansProp(String capitalizedName) {
        LdiSrl.assertObjectNotNull("capitalizedName", capitalizedName);
        if (LdiSrl.is_Null_or_TrimmedEmpty(capitalizedName)) {
            return capitalizedName;
        }
        if (LdiSrl.isInitTwoUpperCase(capitalizedName)) {
            return capitalizedName;
        }
        return LdiSrl.initUncap(capitalizedName);
    }

    public static boolean isInitLowerCase(String str) {
        LdiSrl.assertStringNotNull(str);
        if (LdiSrl.is_Null_or_Empty(str)) {
            return false;
        }
        return LdiSrl.isLowerCase(str.charAt(0));
    }

    public static boolean isInitTwoLowerCase(String str) {
        LdiSrl.assertStringNotNull(str);
        if (str.length() < 2) {
            return false;
        }
        return LdiSrl.isLowerCase(str.charAt(0), str.charAt(1));
    }

    public static boolean isInitUpperCase(String str) {
        LdiSrl.assertStringNotNull(str);
        if (LdiSrl.is_Null_or_Empty(str)) {
            return false;
        }
        return LdiSrl.isUpperCase(str.charAt(0));
    }

    public static boolean isInitTwoUpperCase(String str) {
        LdiSrl.assertStringNotNull(str);
        if (str.length() < 2) {
            return false;
        }
        return LdiSrl.isUpperCase(str.charAt(0), str.charAt(1));
    }

    public static String camelize(String decamelName) {
        LdiSrl.assertDecamelNameNotNull(decamelName);
        return LdiSrl.doCamelize(decamelName, "_");
    }

    public static String camelize(String decamelName, String ... delimiters) {
        LdiSrl.assertDecamelNameNotNull(decamelName);
        String name = decamelName;
        for (String delimiter : delimiters) {
            name = LdiSrl.doCamelize(name, delimiter);
        }
        return name;
    }

    protected static String doCamelize(String decamelName, String delimiter) {
        LdiSrl.assertDecamelNameNotNull(decamelName);
        LdiSrl.assertDelimiterNotNull(delimiter);
        if (LdiSrl.is_Null_or_TrimmedEmpty(decamelName)) {
            return decamelName;
        }
        StringBuilder sb = new StringBuilder();
        List<String> partList = LdiSrl.splitListTrimmed(decamelName, delimiter);
        for (String part : partList) {
            boolean allUpperCase = true;
            for (int i = 1; i < part.length(); ++i) {
                if (!LdiSrl.isLowerCase(part.charAt(i))) continue;
                allUpperCase = false;
            }
            if (allUpperCase) {
                part = part.toLowerCase();
            }
            sb.append(LdiSrl.initCap(part));
        }
        return sb.toString();
    }

    public static String decamelize(String camelName) {
        LdiSrl.assertCamelNameNotNull(camelName);
        return LdiSrl.doDecamelize(camelName, "_");
    }

    public static String decamelize(String camelName, String delimiter) {
        LdiSrl.assertCamelNameNotNull(camelName);
        LdiSrl.assertDelimiterNotNull(delimiter);
        return LdiSrl.doDecamelize(camelName, delimiter);
    }

    protected static String doDecamelize(String camelName, String delimiter) {
        LdiSrl.assertCamelNameNotNull(camelName);
        LdiSrl.assertDelimiterNotNull(delimiter);
        StringBuilder sb = new StringBuilder();
        List<String> splitList = LdiSrl.splitList(camelName, delimiter);
        for (String element : splitList) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(LdiSrl.actuallyDecamelize(element, delimiter));
        }
        String generated = sb.toString();
        return LdiSrl.replace(generated, delimiter + delimiter, delimiter);
    }

    protected static String actuallyDecamelize(String camelName, String delimiter) {
        if (LdiSrl.is_Null_or_TrimmedEmpty(camelName)) {
            return camelName;
        }
        if (camelName.length() == 1) {
            return camelName.toUpperCase();
        }
        if (LdiSrl.isAlphabetNumberHarfUpperAll(camelName)) {
            return camelName;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        for (int i = 1; i < camelName.length(); ++i) {
            char currentChar = camelName.charAt(i);
            if (!LdiSrl.isUpperCase(currentChar)) continue;
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(camelName.substring(pos, i).toUpperCase());
            pos = i;
        }
        if (sb.length() > 0) {
            sb.append(delimiter);
        }
        sb.append(camelName.substring(pos, camelName.length()).toUpperCase());
        return sb.toString();
    }

    public static String removeEmptyLine(String str) {
        LdiSrl.assertStringNotNull(str);
        StringBuilder sb = new StringBuilder();
        List<String> lineList = LdiSrl.splitList(str, "\n");
        for (String line : lineList) {
            if (LdiSrl.is_Null_or_TrimmedEmpty(line)) continue;
            sb.append(LdiSrl.removeCR(line)).append("\n");
        }
        String filtered = sb.toString();
        return filtered.substring(0, filtered.length() - "\n".length());
    }

    public static String removeBlockComment(String sql) {
        LdiSrl.assertSqlNotNull(sql);
        return LdiSrl.removeScope(sql, "/*", "*/");
    }

    public static String removeLineComment(String sql) {
        LdiSrl.assertSqlNotNull(sql);
        StringBuilder sb = new StringBuilder();
        List<String> lineList = LdiSrl.splitList(sql, "\n");
        for (String line : lineList) {
            if (line == null || (line = LdiSrl.removeCR(line)).trim().startsWith("--")) continue;
            List<DelimiterInfo> delimiterList = LdiSrl.extractDelimiterList(line, "--");
            int realIndex = -1;
            block1: for (DelimiterInfo delimiter : delimiterList) {
                List<ScopeInfo> scopeList = LdiSrl.extractScopeList(line, "/*", "*/");
                int delimiterIndex = delimiter.getBeginIndex();
                for (ScopeInfo scope : scopeList) {
                    if (scope.isBeforeScope(delimiterIndex)) break;
                    if (!scope.isInScope(delimiterIndex)) continue;
                    continue block1;
                }
                realIndex = delimiterIndex;
            }
            if (realIndex >= 0) {
                line = line.substring(0, realIndex);
            }
            sb.append(line).append("\n");
        }
        String filtered = sb.toString();
        return filtered.substring(0, filtered.length() - "\n".length());
    }

    protected static String removeCR(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\r", "");
    }

    public static String indent(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String indent(int size, String str) {
        List<String> lineList = LdiSrl.splitList(LdiSrl.removeCR(str), "\n");
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String element : lineList) {
            if (index > 0) {
                sb.append("\n");
            }
            sb.append(LdiSrl.indent(size)).append(element);
            ++index;
        }
        return sb.toString();
    }

    public static boolean isAlphabetHarfAll(String str) {
        return LdiSrl.isAnyCharAll(str, _alphabetHarfCharSet);
    }

    public static boolean isAlphabetHarfLowerAll(String str) {
        return LdiSrl.isAnyCharAll(str, _alphabetHarfLowerCharSet);
    }

    public static boolean isAlphabetHarfUpperAll(String str) {
        return LdiSrl.isAnyCharAll(str, _alphabetHarfUpperCharSet);
    }

    public static boolean isNumberHarfAll(String str) {
        return LdiSrl.isAnyCharAll(str, _numberHarfCharSet);
    }

    public static boolean isAlphabetNumberHarfAll(String str) {
        return LdiSrl.isAnyCharAll(str, _alphabetHarfNumberHarfCharSet);
    }

    public static boolean isAlphabetNumberHarfAllOr(String str, Character ... addedChars) {
        HashSet<Character> charSet = new HashSet<Character>(_alphabetHarfNumberHarfCharSet);
        for (Character ch : addedChars) {
            charSet.add(ch);
        }
        return LdiSrl.isAnyCharAll(str, charSet);
    }

    public static boolean isAlphabetNumberHarfLowerAll(String str) {
        return LdiSrl.isAnyCharAll(str, _alphabetNumberHarfLowerCharSet);
    }

    public static boolean isAlphabetNumberHarfUpperAll(String str) {
        return LdiSrl.isAnyCharAll(str, _alphabetNumberHarfUpperCharSet);
    }

    protected static boolean isAnyCharAll(String str, Set<Character> charSet) {
        if (LdiSrl.is_Null_or_Empty(str)) {
            return false;
        }
        char[] chAry = str.toCharArray();
        for (int i = 0; i < chAry.length; ++i) {
            char ch = chAry[i];
            if (charSet.contains(Character.valueOf(ch))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isLowerCase(char ch) {
        return Character.isLowerCase(ch);
    }

    protected static boolean isLowerCase(char ch1, char ch2) {
        return LdiSrl.isLowerCase(ch1) && LdiSrl.isLowerCase(ch2);
    }

    public static boolean isLowerCaseAll(String str) {
        LdiSrl.assertStringNotNull(str);
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (LdiSrl.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCaseAny(String str) {
        LdiSrl.assertStringNotNull(str);
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!LdiSrl.isLowerCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected static boolean isUpperCase(char ch) {
        return Character.isUpperCase(ch);
    }

    protected static boolean isUpperCase(char ch1, char ch2) {
        return LdiSrl.isUpperCase(ch1) && LdiSrl.isUpperCase(ch2);
    }

    public static boolean isUpperCaseAll(String str) {
        LdiSrl.assertStringNotNull(str);
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (LdiSrl.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCaseAny(String str) {
        LdiSrl.assertStringNotNull(str);
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!LdiSrl.isUpperCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected static void assertStringNotNull(String str) {
        LdiSrl.assertObjectNotNull("str", str);
    }

    protected static void assertStringListNotNull(Collection<String> strList) {
        LdiSrl.assertObjectNotNull("strList", strList);
    }

    protected static void assertElementNotNull(String element) {
        LdiSrl.assertObjectNotNull("element", element);
    }

    protected static void assertElementVaryingNotNull(String[] elements) {
        LdiSrl.assertObjectNotNull("elements", elements);
    }

    protected static void assertKeywordNotNull(String keyword) {
        LdiSrl.assertObjectNotNull("keyword", keyword);
    }

    protected static void assertKeywordVaryingNotNull(String[] keywords) {
        LdiSrl.assertObjectNotNull("keywords", keywords);
    }

    protected static void assertPrefixNotNull(String prefix) {
        LdiSrl.assertObjectNotNull("prefix", prefix);
    }

    protected static void assertSuffixNotNull(String suffix) {
        LdiSrl.assertObjectNotNull("suffix", suffix);
    }

    protected static void assertFromToMapNotNull(Map<String, String> fromToMap) {
        LdiSrl.assertObjectNotNull("fromToMap", fromToMap);
    }

    protected static void assertDelimiterNotNull(String delimiter) {
        LdiSrl.assertObjectNotNull("delimiter", delimiter);
    }

    protected static void assertFromStringNotNull(String fromStr) {
        LdiSrl.assertObjectNotNull("fromStr", fromStr);
    }

    protected static void assertToStringNotNull(String toStr) {
        LdiSrl.assertObjectNotNull("toStr", toStr);
    }

    protected static void assertQuotationNotNull(String quotation) {
        LdiSrl.assertObjectNotNull("quotation", quotation);
    }

    protected static void assertBeginMarkNotNull(String beginMark) {
        LdiSrl.assertObjectNotNull("beginMark", beginMark);
    }

    protected static void assertEndMarkNotNull(String endMark) {
        LdiSrl.assertObjectNotNull("endMark", endMark);
    }

    protected static void assertDecamelNameNotNull(String decamelName) {
        LdiSrl.assertObjectNotNull("decamelName", decamelName);
    }

    protected static void assertCamelNameNotNull(String camelName) {
        LdiSrl.assertObjectNotNull("camelName", camelName);
    }

    protected static void assertSqlNotNull(String sql) {
        LdiSrl.assertObjectNotNull("sql", sql);
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected static void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        LdiSrl.assertObjectNotNull("variableName", variableName);
        LdiSrl.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        char[] chAry;
        HashSet<Character> setupSet = new HashSet<Character>();
        StringBuilder sb = new StringBuilder();
        sb.append(HARF_LOWER_ALPHABET);
        sb.append(sb.toString().toUpperCase());
        for (char ch : chAry = sb.toString().toCharArray()) {
            setupSet.add(Character.valueOf(ch));
        }
        _alphabetHarfCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        sb = new StringBuilder();
        sb.append(HARF_LOWER_ALPHABET);
        for (char ch : chAry = sb.toString().toCharArray()) {
            setupSet.add(Character.valueOf(ch));
        }
        _alphabetHarfLowerCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        sb = new StringBuilder();
        sb.append(HARF_LOWER_ALPHABET.toUpperCase());
        for (char ch : chAry = sb.toString().toCharArray()) {
            setupSet.add(Character.valueOf(ch));
        }
        _alphabetHarfUpperCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        String chStr = HARF_NUMBER;
        for (char ch : chAry = HARF_NUMBER.toCharArray()) {
            setupSet.add(Character.valueOf(ch));
        }
        _numberHarfCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        setupSet.addAll(_alphabetHarfCharSet);
        setupSet.addAll(_numberHarfCharSet);
        _alphabetHarfNumberHarfCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        setupSet.addAll(_alphabetHarfLowerCharSet);
        setupSet.addAll(_numberHarfCharSet);
        _alphabetNumberHarfLowerCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        setupSet.addAll(_alphabetHarfUpperCharSet);
        setupSet.addAll(_numberHarfCharSet);
        _alphabetNumberHarfUpperCharSet = Collections.unmodifiableSet(setupSet);
    }

    public static class ScopeInfo {
        protected String _baseString;
        protected int _beginIndex;
        protected int _endIndex;
        protected String beginMark;
        protected String endMark;
        protected String _content;
        protected String _scope;
        protected ScopeInfo _previous;
        protected ScopeInfo _next;

        public boolean isBeforeScope(int index) {
            return index < this._beginIndex;
        }

        public boolean isInScope(int index) {
            return index >= this._beginIndex && index <= this._endIndex;
        }

        public String replaceContentOnBaseString(String toStr) {
            List<ScopeInfo> scopeList = this.takeScopeList();
            StringBuilder sb = new StringBuilder();
            for (ScopeInfo scope : scopeList) {
                sb.append(scope.substringInterspaceToPrevious());
                sb.append(scope.getBeginMark());
                sb.append(toStr);
                sb.append(scope.getEndMark());
                if (scope.getNext() != null) continue;
                sb.append(scope.substringInterspaceToNext());
            }
            return sb.toString();
        }

        public String replaceContentOnBaseString(String fromStr, String toStr) {
            List<ScopeInfo> scopeList = this.takeScopeList();
            StringBuilder sb = new StringBuilder();
            for (ScopeInfo scope : scopeList) {
                sb.append(scope.substringInterspaceToPrevious());
                sb.append(scope.getBeginMark());
                sb.append(LdiSrl.replace(scope.getContent(), fromStr, toStr));
                sb.append(scope.getEndMark());
                if (scope.getNext() != null) continue;
                sb.append(scope.substringInterspaceToNext());
            }
            return sb.toString();
        }

        public String replaceInterspaceOnBaseString(String fromStr, String toStr) {
            List<ScopeInfo> scopeList = this.takeScopeList();
            StringBuilder sb = new StringBuilder();
            for (ScopeInfo scope : scopeList) {
                sb.append(LdiSrl.replace(scope.substringInterspaceToPrevious(), fromStr, toStr));
                sb.append(scope.getScope());
                if (scope.getNext() != null) continue;
                sb.append(LdiSrl.replace(scope.substringInterspaceToNext(), fromStr, toStr));
            }
            return sb.toString();
        }

        protected List<ScopeInfo> takeScopeList() {
            ScopeInfo next;
            ScopeInfo previous;
            ScopeInfo scope = this;
            while ((previous = scope.getPrevious()) != null) {
                scope = previous;
            }
            ArrayList<ScopeInfo> scopeList = new ArrayList<ScopeInfo>();
            scopeList.add(scope);
            while ((next = scope.getNext()) != null) {
                scope = next;
                scopeList.add(next);
            }
            return scopeList;
        }

        public String substringInterspaceToPrevious() {
            int previousEndIndex = -1;
            if (this._previous != null) {
                previousEndIndex = this._previous.getEndIndex();
            }
            if (previousEndIndex >= 0) {
                return this._baseString.substring(previousEndIndex, this._beginIndex);
            }
            return this._baseString.substring(0, this._beginIndex);
        }

        public String substringInterspaceToNext() {
            int nextBeginIndex = -1;
            if (this._next != null) {
                nextBeginIndex = this._next.getBeginIndex();
            }
            if (nextBeginIndex >= 0) {
                return this._baseString.substring(this._endIndex, nextBeginIndex);
            }
            return this._baseString.substring(this._endIndex);
        }

        public String substringScopeToPrevious() {
            int previousBeginIndex = -1;
            if (this._previous != null) {
                previousBeginIndex = this._previous.getBeginIndex();
            }
            if (previousBeginIndex >= 0) {
                return this._baseString.substring(previousBeginIndex, this._endIndex);
            }
            return this._baseString.substring(0, this._endIndex);
        }

        public String substringScopeToNext() {
            int nextEndIndex = -1;
            if (this._next != null) {
                nextEndIndex = this._next.getEndIndex();
            }
            if (nextEndIndex >= 0) {
                return this._baseString.substring(this._beginIndex, nextEndIndex);
            }
            return this._baseString.substring(this._beginIndex);
        }

        public String toString() {
            return this._scope + ":(" + this._beginIndex + ", " + this._endIndex + ")";
        }

        public String getBaseString() {
            return this._baseString;
        }

        public void setBaseString(String baseString) {
            this._baseString = baseString;
        }

        public int getBeginIndex() {
            return this._beginIndex;
        }

        public void setBeginIndex(int beginIndex) {
            this._beginIndex = beginIndex;
        }

        public int getEndIndex() {
            return this._endIndex;
        }

        public void setEndIndex(int endIndex) {
            this._endIndex = endIndex;
        }

        public String getBeginMark() {
            return this.beginMark;
        }

        public void setBeginMark(String beginMark) {
            this.beginMark = beginMark;
        }

        public String getEndMark() {
            return this.endMark;
        }

        public void setEndMark(String endMark) {
            this.endMark = endMark;
        }

        public String getContent() {
            return this._content;
        }

        public void setContent(String content) {
            this._content = content;
        }

        public String getScope() {
            return this._scope;
        }

        public void setScope(String scope) {
            this._scope = scope;
        }

        public ScopeInfo getPrevious() {
            return this._previous;
        }

        public void setPrevious(ScopeInfo previous) {
            this._previous = previous;
        }

        public ScopeInfo getNext() {
            return this._next;
        }

        public void setNext(ScopeInfo next) {
            this._next = next;
        }
    }

    public static class DelimiterInfo {
        protected String _baseString;
        protected int _beginIndex;
        protected int _endIndex;
        protected String _delimiter;
        protected DelimiterInfo _previous;
        protected DelimiterInfo _next;

        public String substringInterspaceToPrevious() {
            int previousIndex = -1;
            if (this._previous != null) {
                previousIndex = this._previous.getBeginIndex();
            }
            if (previousIndex >= 0) {
                return this._baseString.substring(previousIndex + this._previous.getDelimiter().length(), this._beginIndex);
            }
            return this._baseString.substring(0, this._beginIndex);
        }

        public String substringInterspaceToNext() {
            int nextIndex = -1;
            if (this._next != null) {
                nextIndex = this._next.getBeginIndex();
            }
            if (nextIndex >= 0) {
                return this._baseString.substring(this._endIndex, nextIndex);
            }
            return this._baseString.substring(this._endIndex);
        }

        public String toString() {
            return this._delimiter + ":(" + this._beginIndex + ", " + this._endIndex + ")";
        }

        public String getBaseString() {
            return this._baseString;
        }

        public void setBaseString(String baseStr) {
            this._baseString = baseStr;
        }

        public int getBeginIndex() {
            return this._beginIndex;
        }

        public void setBeginIndex(int beginIndex) {
            this._beginIndex = beginIndex;
        }

        public int getEndIndex() {
            return this._endIndex;
        }

        public void setEndIndex(int endIndex) {
            this._endIndex = endIndex;
        }

        public String getDelimiter() {
            return this._delimiter;
        }

        public void setDelimiter(String delimiter) {
            this._delimiter = delimiter;
        }

        public DelimiterInfo getPrevious() {
            return this._previous;
        }

        public void setPrevious(DelimiterInfo previous) {
            this._previous = previous;
        }

        public DelimiterInfo getNext() {
            return this._next;
        }

        public void setNext(DelimiterInfo next) {
            this._next = next;
        }
    }

    protected static enum KeywordType {
        CONTAIN,
        PREFIX,
        SUFFIX;

    }

    protected static enum ListElementContainsType {
        EQUAL,
        KEYWORD,
        PREFIX,
        SUFFIX;

    }

    public static class IndexOfInfo {
        protected String _baseString;
        protected int _index;
        protected String _delimiter;

        public String substringFront() {
            return this._baseString.substring(0, this.getIndex());
        }

        public String substringFrontTrimmed() {
            return this.substringFront().trim();
        }

        public String substringRear() {
            return this._baseString.substring(this.getRearIndex());
        }

        public String substringRearTrimmed() {
            return this.substringRear().trim();
        }

        public int getRearIndex() {
            return this._index + this._delimiter.length();
        }

        public String getBaseString() {
            return this._baseString;
        }

        public void setBaseString(String baseStr) {
            this._baseString = baseStr;
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int index) {
            this._index = index;
        }

        public String getDelimiter() {
            return this._delimiter;
        }

        public void setDelimiter(String delimiter) {
            this._delimiter = delimiter;
        }
    }
}

