/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import org.laxture.sbp.internal.PluginResourceResolver;
import org.laxture.sbp.spring.boot.SbpPluginStateChangedEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.context.ApplicationListener;
import org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.resource.EncodedResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.VersionResourceResolver;

public class PluginResourceHandlerRegistrationCustomizer
implements WebMvcAutoConfiguration.ResourceHandlerRegistrationCustomizer,
ApplicationListener<SbpPluginStateChangedEvent> {
    private static final String DEFAULT_CACHE_NAME = "sbp-resource-chain-cache";
    @Autowired
    private WebProperties webProperties;
    private Cache sbpResourceCache;

    public void customize(ResourceHandlerRegistration registration) {
        WebProperties.Resources resourcesProperties;
        if (this.sbpResourceCache == null) {
            this.sbpResourceCache = new ConcurrentMapCache(DEFAULT_CACHE_NAME);
        }
        if ((resourcesProperties = this.webProperties.getResources()) == null) {
            resourcesProperties = new WebProperties.Resources();
        }
        WebProperties.Resources.Chain properties = resourcesProperties.getChain();
        ResourceChainRegistration chain = registration.resourceChain(properties.isCache(), this.sbpResourceCache);
        chain.addResolver((ResourceResolver)new PluginResourceResolver());
        WebProperties.Resources.Chain.Strategy strategy = properties.getStrategy();
        if (properties.isCompressed()) {
            chain.addResolver((ResourceResolver)new EncodedResourceResolver());
        }
        if (strategy.getFixed().isEnabled() || strategy.getContent().isEnabled()) {
            chain.addResolver(this.getVersionResourceResolver(strategy));
        }
    }

    private ResourceResolver getVersionResourceResolver(WebProperties.Resources.Chain.Strategy properties) {
        VersionResourceResolver resolver = new VersionResourceResolver();
        if (properties.getFixed().isEnabled()) {
            String version = properties.getFixed().getVersion();
            String[] paths = properties.getFixed().getPaths();
            resolver.addFixedVersionStrategy(version, paths);
        }
        if (properties.getContent().isEnabled()) {
            String[] paths = properties.getContent().getPaths();
            resolver.addContentVersionStrategy(paths);
        }
        return resolver;
    }

    public void onApplicationEvent(SbpPluginStateChangedEvent event) {
        if (this.sbpResourceCache == null) {
            return;
        }
        this.sbpResourceCache.clear();
    }
}

