/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.internal;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.laxture.sbp.SpringBootPlugin;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PluginRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    public void detectHandlerMethods(Object controller) {
        super.detectHandlerMethods(controller);
    }

    public void registerControllers(SpringBootPlugin springBootPlugin) {
        this.getControllerBeans(springBootPlugin).forEach(bean -> this.registerController(springBootPlugin, bean));
    }

    private void registerController(SpringBootPlugin springBootPlugin, Object controller) {
        String beanName = controller.getClass().getName();
        this.unregisterController(springBootPlugin.getMainApplicationContext(), controller);
        springBootPlugin.registerBeanToMainContext(beanName, controller);
        this.detectHandlerMethods(controller);
    }

    public void unregisterControllers(SpringBootPlugin springBootPlugin) {
        this.getControllerBeans(springBootPlugin).forEach(bean -> this.unregisterController(springBootPlugin.getMainApplicationContext(), bean));
    }

    public Set<Object> getControllerBeans(SpringBootPlugin springBootPlugin) {
        LinkedHashSet<Object> beans = new LinkedHashSet<Object>();
        GenericApplicationContext applicationContext = springBootPlugin.getApplicationContext();
        Set sharedBeanNames = (Set)applicationContext.getBean("sharedBeanNames");
        beans.addAll(applicationContext.getBeansWithAnnotation(Controller.class).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
        beans.addAll(applicationContext.getBeansWithAnnotation(RestController.class).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
        return beans;
    }

    public void unregisterController(GenericApplicationContext mainCtx, Object controller) {
        new HashMap<RequestMappingInfo, HandlerMethod>(this.getHandlerMethods()).forEach((mapping, handlerMethod) -> {
            if (controller == handlerMethod.getBean()) {
                super.unregisterMapping(mapping);
            }
        });
        SpringBootPlugin.unregisterBeanFromMainContext(mainCtx, controller);
    }
}

