/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.laxture.sbp.SpringBootPluginManager;
import org.laxture.sbp.internal.PluginRequestMappingHandlerMapping;
import org.laxture.sbp.internal.SpringExtensionFactory;
import org.laxture.sbp.spring.boot.SbpPluginRestartedEvent;
import org.laxture.sbp.spring.boot.SbpPluginStartedEvent;
import org.laxture.sbp.spring.boot.SbpPluginStoppedEvent;
import org.laxture.sbp.spring.boot.SpringBootstrap;
import org.laxture.spring.util.ApplicationContextProvider;
import org.pf4j.Plugin;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;

public abstract class SpringBootPlugin
extends Plugin {
    private final SpringBootstrap springBootstrap = this.createSpringBootstrap();
    private ApplicationContext applicationContext;

    public SpringBootPlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    private PluginRequestMappingHandlerMapping getMainRequestMapping() {
        return (PluginRequestMappingHandlerMapping)((Object)this.getMainApplicationContext().getBean("requestMappingHandlerMapping"));
    }

    public void releaseResource() {
    }

    public void start() {
        if (this.getWrapper().getPluginState() == PluginState.STARTED) {
            return;
        }
        long startTs = System.currentTimeMillis();
        this.log.debug("Starting plugin {} ......", (Object)this.getWrapper().getPluginId());
        this.applicationContext = this.springBootstrap.run(new String[0]);
        this.getMainRequestMapping().registerControllers(this);
        Set extensionClassNames = this.getWrapper().getPluginManager().getExtensionClassNames(this.getWrapper().getPluginId());
        for (String extensionClassName : extensionClassNames) {
            try {
                this.log.debug("Register extension <{}> to main ApplicationContext", (Object)extensionClassName);
                Class<?> extensionClass = this.getWrapper().getPluginClassLoader().loadClass(extensionClassName);
                SpringExtensionFactory extensionFactory = (SpringExtensionFactory)this.getWrapper().getPluginManager().getExtensionFactory();
                Object bean = extensionFactory.create(extensionClass);
                String beanName = extensionFactory.getExtensionBeanName(extensionClass);
                this.registerBeanToMainContext(beanName, bean);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        ApplicationContextProvider.registerApplicationContext((ApplicationContext)this.applicationContext);
        this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginStartedEvent(this.applicationContext));
        if (this.getPluginManager().isMainApplicationStarted()) {
            this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginRestartedEvent(this.applicationContext));
        }
        this.log.debug("Plugin {} is started in {}ms", (Object)this.getWrapper().getPluginId(), (Object)(System.currentTimeMillis() - startTs));
    }

    public void stop() {
        if (this.getWrapper().getPluginState() != PluginState.STARTED) {
            return;
        }
        this.log.debug("Stopping plugin {} ......", (Object)this.getWrapper().getPluginId());
        this.releaseResource();
        Set extensionClassNames = this.getWrapper().getPluginManager().getExtensionClassNames(this.getWrapper().getPluginId());
        for (String extensionClassName : extensionClassNames) {
            try {
                this.log.debug("Register extension <{}> to main ApplicationContext", (Object)extensionClassName);
                Class<?> extensionClass = this.getWrapper().getPluginClassLoader().loadClass(extensionClassName);
                SpringExtensionFactory extensionFactory = (SpringExtensionFactory)this.getWrapper().getPluginManager().getExtensionFactory();
                String beanName = extensionFactory.getExtensionBeanName(extensionClass);
                this.unregisterBeanFromMainContext(beanName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        this.getMainRequestMapping().unregisterControllers(this);
        this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginStoppedEvent(this.applicationContext));
        ApplicationContextProvider.unregisterApplicationContext((ApplicationContext)this.applicationContext);
        ((ConfigurableApplicationContext)this.applicationContext).close();
        this.log.debug("Plugin {} is stopped", (Object)this.getWrapper().getPluginId());
    }

    protected abstract SpringBootstrap createSpringBootstrap();

    public GenericApplicationContext getApplicationContext() {
        return (GenericApplicationContext)this.applicationContext;
    }

    public SpringBootPluginManager getPluginManager() {
        return (SpringBootPluginManager)this.getWrapper().getPluginManager();
    }

    public GenericApplicationContext getMainApplicationContext() {
        return (GenericApplicationContext)this.getPluginManager().getMainApplicationContext();
    }

    public void registerBeanToMainContext(String beanName, Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        beanName = StringUtils.isEmpty((CharSequence)beanName) ? bean.getClass().getName() : beanName;
        this.getMainApplicationContext().getBeanFactory().registerSingleton(beanName, bean);
    }

    public void unregisterBeanFromMainContext(String beanName) {
        Assert.notNull((Object)beanName, (String)"bean must not be null");
        ((AbstractAutowireCapableBeanFactory)this.getMainApplicationContext().getBeanFactory()).destroySingleton(beanName);
    }

    public void unregisterBeanFromMainContext(Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        String beanName = bean.getClass().getName();
        ((AbstractAutowireCapableBeanFactory)this.getMainApplicationContext().getBeanFactory()).destroySingleton(beanName);
    }
}

