/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.laxture.sbp.internal.SpringExtensionFactory;
import org.laxture.sbp.spring.boot.PluginStartingError;
import org.laxture.sbp.spring.boot.SbpPluginStateChangedEvent;
import org.pf4j.DefaultPluginManager;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginState;
import org.pf4j.PluginStateEvent;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class SpringBootPluginManager
extends DefaultPluginManager
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPluginManager.class);
    private boolean mainApplicationStarted;
    private ApplicationContext mainApplicationContext;
    public Map<String, Object> presetProperties = new HashMap<String, Object>();
    private boolean autoStartPlugin = true;
    private String[] profiles;
    private PluginRepository pluginRepository;
    private final Map<String, PluginStartingError> startingErrors = new HashMap<String, PluginStartingError>();

    public SpringBootPluginManager() {
    }

    public SpringBootPluginManager(Path pluginsRoot) {
        super(pluginsRoot);
    }

    protected ExtensionFactory createExtensionFactory() {
        return new SpringExtensionFactory(this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mainApplicationContext = applicationContext;
    }

    public PluginDescriptorFinder getPluginDescriptorFinder() {
        return super.getPluginDescriptorFinder();
    }

    protected PluginRepository createPluginRepository() {
        this.pluginRepository = super.createPluginRepository();
        return this.pluginRepository;
    }

    public PluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    public void setAutoStartPlugin(boolean autoStartPlugin) {
        this.autoStartPlugin = autoStartPlugin;
    }

    public boolean isAutoStartPlugin() {
        return this.autoStartPlugin;
    }

    public void setMainApplicationStarted(boolean mainApplicationStarted) {
        this.mainApplicationStarted = mainApplicationStarted;
    }

    public void setProfiles(String[] profiles) {
        this.profiles = profiles;
    }

    public String[] getProfiles() {
        return this.profiles;
    }

    public void presetProperties(Map<String, Object> presetProperties) {
        this.presetProperties.putAll(presetProperties);
    }

    public void presetProperties(String name, Object value) {
        this.presetProperties.put(name, value);
    }

    public Map<String, Object> getPresetProperties() {
        return this.presetProperties;
    }

    public ApplicationContext getMainApplicationContext() {
        return this.mainApplicationContext;
    }

    public boolean isMainApplicationStarted() {
        return this.mainApplicationStarted;
    }

    @PostConstruct
    public void init() {
        this.loadPlugins();
    }

    public PluginStartingError getPluginStartingError(String pluginId) {
        return this.startingErrors.get(pluginId);
    }

    private void doStartPlugins() {
        this.startingErrors.clear();
        long ts = System.currentTimeMillis();
        for (PluginWrapper pluginWrapper : this.resolvedPlugins) {
            PluginState pluginState = pluginWrapper.getPluginState();
            if (PluginState.DISABLED == pluginState || PluginState.STARTED == pluginState) continue;
            try {
                pluginWrapper.getPlugin().start();
                pluginWrapper.setPluginState(PluginState.STARTED);
                this.startedPlugins.add(pluginWrapper);
                this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                this.startingErrors.put(pluginWrapper.getPluginId(), PluginStartingError.of(pluginWrapper.getPluginId(), e.getMessage(), e.toString()));
            }
        }
        log.info("[SBP] {} plugins are started in {}ms. {} failed", new Object[]{this.getPlugins().size(), System.currentTimeMillis() - ts, this.startingErrors.size()});
    }

    private void doStopPlugins() {
        this.startingErrors.clear();
        Collections.reverse(this.startedPlugins);
        Iterator itr = this.startedPlugins.iterator();
        while (itr.hasNext()) {
            PluginWrapper pluginWrapper = (PluginWrapper)itr.next();
            PluginState pluginState = pluginWrapper.getPluginState();
            if (PluginState.STARTED != pluginState) continue;
            try {
                log.info("Stop plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
                pluginWrapper.getPlugin().stop();
                pluginWrapper.setPluginState(PluginState.STOPPED);
                itr.remove();
                this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
            }
            catch (PluginRuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.startingErrors.put(pluginWrapper.getPluginId(), PluginStartingError.of(pluginWrapper.getPluginId(), e.getMessage(), e.toString()));
            }
        }
    }

    private PluginState doStartPlugin(String pluginId, boolean sendEvent) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        try {
            PluginState pluginState = super.startPlugin(pluginId);
            if (sendEvent) {
                this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent(this.mainApplicationContext));
            }
            return pluginState;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.startingErrors.put(plugin.getPluginId(), PluginStartingError.of(plugin.getPluginId(), e.getMessage(), e.toString()));
            return plugin.getPluginState();
        }
    }

    private PluginState doStopPlugin(String pluginId, boolean sendEvent) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        try {
            PluginState pluginState = super.stopPlugin(pluginId);
            if (sendEvent) {
                this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent(this.mainApplicationContext));
            }
            return pluginState;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.startingErrors.put(plugin.getPluginId(), PluginStartingError.of(plugin.getPluginId(), e.getMessage(), e.toString()));
            return plugin.getPluginState();
        }
    }

    public void startPlugins() {
        this.doStartPlugins();
        this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent(this.mainApplicationContext));
    }

    public PluginState startPlugin(String pluginId) {
        return this.doStartPlugin(pluginId, true);
    }

    public void stopPlugins() {
        this.doStopPlugins();
        this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent(this.mainApplicationContext));
    }

    public PluginState stopPlugin(String pluginId) {
        return this.doStopPlugin(pluginId, true);
    }

    public void restartPlugins() {
        this.doStopPlugins();
        this.startPlugins();
    }

    public PluginState restartPlugin(String pluginId) {
        PluginState pluginState = this.doStopPlugin(pluginId, false);
        if (pluginState != PluginState.STARTED) {
            this.doStartPlugin(pluginId, false);
        }
        this.doStartPlugin(pluginId, false);
        this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent(this.mainApplicationContext));
        return pluginState;
    }

    public void reloadPlugins(boolean restartStartedOnly) {
        this.doStopPlugins();
        ArrayList startedPluginIds = new ArrayList();
        this.getPlugins().forEach(plugin -> {
            if (plugin.getPluginState() == PluginState.STARTED) {
                startedPluginIds.add(plugin.getPluginId());
            }
            this.unloadPlugin(plugin.getPluginId());
        });
        this.loadPlugins();
        if (restartStartedOnly) {
            startedPluginIds.forEach(pluginId -> {
                if (this.getPlugin((String)pluginId) != null) {
                    this.doStartPlugin((String)pluginId, false);
                }
            });
            this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent(this.mainApplicationContext));
        } else {
            this.startPlugins();
        }
    }

    public PluginState reloadPlugins(String pluginId) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        this.doStopPlugin(pluginId, false);
        this.unloadPlugin(pluginId);
        try {
            this.loadPlugin(plugin.getPluginPath());
        }
        catch (Exception ex) {
            return null;
        }
        return this.doStartPlugin(pluginId, true);
    }
}

