/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.pf4j.PluginClassLoader;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SpringBootPluginClassLoader
extends PluginClassLoader {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPluginClassLoader.class);
    private List<String> pluginFirstClasses;
    private List<String> pluginOnlyResources;

    public SpringBootPluginClassLoader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader parent) {
        super(pluginManager, pluginDescriptor, parent, true);
    }

    public void setPluginFirstClasses(@NonNull List<String> pluginFirstClasses) {
        if (pluginFirstClasses == null) {
            throw new NullPointerException("pluginFirstClasses is marked non-null but is null");
        }
        this.pluginFirstClasses = pluginFirstClasses.stream().map(pluginFirstClass -> pluginFirstClass.replaceAll(".", "[$0]").replace("[*]", ".*?").replace("[?]", ".?")).collect(Collectors.toList());
    }

    public void setPluginOnlyResources(@NonNull List<String> pluginOnlyResources) {
        if (pluginOnlyResources == null) {
            throw new NullPointerException("pluginOnlyResources is marked non-null but is null");
        }
        this.pluginOnlyResources = pluginOnlyResources.stream().map(pluginFirstClass -> pluginFirstClass.replaceAll(".", "[$0]").replace("[*]", ".*?").replace("[?]", ".?")).collect(Collectors.toList());
    }

    public URL getResource(String name) {
        if (name.endsWith(".class")) {
            return super.getResource(name);
        }
        URL url = this.findResource(name);
        if (url != null) {
            log.trace("Found resource '{}' in plugin classpath", (Object)name);
            return url;
        }
        log.trace("Couldn't find resource '{}' in plugin classpath. Delegating to parent", (Object)name);
        return super.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.isPluginOnlyResources(name) ? this.findResources(name) : super.getResources(name);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            if (this.isPluginFirstClass(className)) {
                try {
                    return this.loadClassFromPlugin(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.loadClassFromDependencies(className);
        }
    }

    private boolean isPluginFirstClass(String name) {
        if (this.pluginFirstClasses == null || this.pluginFirstClasses.size() <= 0) {
            return false;
        }
        for (String pluginFirstClass : this.pluginFirstClasses) {
            if (!name.matches(pluginFirstClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isPluginOnlyResources(String name) {
        if (this.pluginOnlyResources == null || this.pluginOnlyResources.size() <= 0) {
            return false;
        }
        for (String pluginOnlyResource : this.pluginOnlyResources) {
            if (!name.matches(pluginOnlyResource)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassFromPlugin(String className) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            log.trace("Received request to load class '{}'", (Object)className);
            Class loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                log.trace("Found loaded class '{}'", (Object)className);
                return loadedClass;
            }
            try {
                loadedClass = this.findClass(className);
                log.trace("Found class '{}' in plugin classpath", (Object)className);
                return loadedClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.loadClassFromDependencies(className);
            }
        }
    }

    private Class<?> loadClassFromDependencies(String className) throws ClassNotFoundException {
        try {
            Method loadClassFromDependenciesMethod = ReflectionUtils.findMethod(((Object)((Object)this)).getClass().getSuperclass(), (String)"loadClassFromDependencies", (Class[])new Class[]{String.class});
            loadClassFromDependenciesMethod.setAccessible(true);
            Class loadedClass = (Class)loadClassFromDependenciesMethod.invoke((Object)this, className);
            if (loadedClass != null) {
                log.trace("Found class '{}' in dependencies", (Object)className);
                return loadedClass;
            }
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(className);
        }
        throw new ClassNotFoundException(className);
    }
}

