/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.laxture.sbp.SpringBootPluginManager;
import org.laxture.sbp.internal.PluginRequestMappingAdapter;
import org.laxture.sbp.internal.SpringExtensionFactory;
import org.laxture.sbp.internal.webmvc.PluginRequestMappingHandlerMapping;
import org.laxture.sbp.spring.boot.SbpPluginRestartedEvent;
import org.laxture.sbp.spring.boot.SbpPluginStartedEvent;
import org.laxture.sbp.spring.boot.SbpPluginStoppedEvent;
import org.laxture.sbp.spring.boot.SpringBootstrap;
import org.laxture.spring.util.ApplicationContextProvider;
import org.pf4j.Plugin;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.server.RouterFunction;

public abstract class SpringBootPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPlugin.class);
    private final SpringBootstrap springBootstrap;
    private ApplicationContext applicationContext;
    private final Set<String> injectedExtensionNames = new HashSet<String>();

    public SpringBootPlugin(PluginWrapper wrapper) {
        super(wrapper);
        this.springBootstrap = this.createSpringBootstrap();
    }

    private PluginRequestMappingAdapter getMainRequestMapping() {
        return (PluginRequestMappingAdapter)this.getMainApplicationContext().getBean("requestMappingHandlerMapping");
    }

    public void releaseAdditionalResources() {
    }

    public void start() {
        if (this.getWrapper().getPluginState() == PluginState.STARTED) {
            return;
        }
        long startTs = System.currentTimeMillis();
        log.debug("Starting plugin {} ......", (Object)this.getWrapper().getPluginId());
        this.applicationContext = this.springBootstrap.run(new String[0]);
        this.getMainRequestMapping().registerControllers(this);
        this.getMainRequestMapping().registerRouterFunction(this);
        Set extensionClassNames = this.getWrapper().getPluginManager().getExtensionClassNames(this.getWrapper().getPluginId());
        for (String extensionClassName : extensionClassNames) {
            try {
                log.debug("Register extension <{}> to main ApplicationContext", (Object)extensionClassName);
                Class<?> extensionClass = this.getWrapper().getPluginClassLoader().loadClass(extensionClassName);
                SpringExtensionFactory extensionFactory = (SpringExtensionFactory)this.getWrapper().getPluginManager().getExtensionFactory();
                Object bean = extensionFactory.create(extensionClass);
                String beanName = extensionFactory.getExtensionBeanName(extensionClass);
                this.registerBeanToMainContext(beanName, bean);
                this.injectedExtensionNames.add(beanName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        ApplicationContextProvider.registerApplicationContext((ApplicationContext)this.applicationContext);
        this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginStartedEvent(this.applicationContext));
        if (this.getPluginManager().isMainApplicationStarted()) {
            this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginRestartedEvent(this.applicationContext));
        }
        log.debug("Plugin {} is started in {}ms", (Object)this.getWrapper().getPluginId(), (Object)(System.currentTimeMillis() - startTs));
    }

    public void stop() {
        if (this.getWrapper().getPluginState() != PluginState.STARTED) {
            return;
        }
        log.debug("Stopping plugin {} ......", (Object)this.getWrapper().getPluginId());
        this.releaseAdditionalResources();
        for (String extensionName : this.injectedExtensionNames) {
            log.debug("Unregister extension <{}> to main ApplicationContext", (Object)extensionName);
            this.unregisterBeanFromMainContext(extensionName);
        }
        this.getMainRequestMapping().unregisterControllers(this);
        this.getMainRequestMapping().unregisterRouterFunction(this);
        this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginStoppedEvent(this.applicationContext));
        ApplicationContextProvider.unregisterApplicationContext((ApplicationContext)this.applicationContext);
        this.injectedExtensionNames.clear();
        ((ConfigurableApplicationContext)this.applicationContext).close();
        log.debug("Plugin {} is stopped", (Object)this.getWrapper().getPluginId());
    }

    public static void releaseLegacyResources(PluginWrapper plugin, GenericApplicationContext mainAppCtx) {
        try {
            Set extensionClassNames = plugin.getPluginManager().getExtensionClassNames(plugin.getPluginId());
            for (String extensionClassName : extensionClassNames) {
                Class<?> extensionClass = plugin.getPluginClassLoader().loadClass(extensionClassName);
                SpringExtensionFactory extensionFactory = (SpringExtensionFactory)plugin.getPluginManager().getExtensionFactory();
                String beanName = extensionFactory.getExtensionBeanName(extensionClass);
                if (StringUtils.isEmpty((CharSequence)beanName)) continue;
                SpringBootPlugin.unregisterBeanFromMainContext(mainAppCtx, beanName);
            }
            PluginRequestMappingHandlerMapping requestMapping = (PluginRequestMappingHandlerMapping)mainAppCtx.getBean("requestMappingHandlerMapping");
            Stream.concat(Stream.concat(Stream.concat(mainAppCtx.getBeansOfType(Controller.class).values().stream(), mainAppCtx.getBeansWithAnnotation(RestController.class).values().stream()), mainAppCtx.getBeansOfType(org.springframework.web.servlet.function.RouterFunction.class).values().stream()), mainAppCtx.getBeansOfType(RouterFunction.class).values().stream()).filter(bean -> bean.getClass().getClassLoader() == plugin.getPluginClassLoader()).forEach(bean -> SpringBootPlugin.unregisterBeanFromMainContext(mainAppCtx, bean));
        }
        catch (Exception e) {
            log.trace("Release registered resources failed. " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract SpringBootstrap createSpringBootstrap();

    public GenericApplicationContext getApplicationContext() {
        return (GenericApplicationContext)this.applicationContext;
    }

    public SpringBootPluginManager getPluginManager() {
        return (SpringBootPluginManager)this.getWrapper().getPluginManager();
    }

    public GenericApplicationContext getMainApplicationContext() {
        return (GenericApplicationContext)this.getPluginManager().getMainApplicationContext();
    }

    public void registerBeanToMainContext(String beanName, Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        beanName = StringUtils.isEmpty((CharSequence)beanName) ? bean.getClass().getName() : beanName;
        this.getMainApplicationContext().getBeanFactory().registerSingleton(beanName, bean);
    }

    public void unregisterBeanFromMainContext(String beanName) {
        SpringBootPlugin.unregisterBeanFromMainContext(this.getMainApplicationContext(), beanName);
        Assert.notNull((Object)beanName, (String)"bean must not be null");
        ((AbstractAutowireCapableBeanFactory)this.getMainApplicationContext().getBeanFactory()).destroySingleton(beanName);
    }

    public void unregisterBeanFromMainContext(Object bean) {
        SpringBootPlugin.unregisterBeanFromMainContext(this.getMainApplicationContext(), bean);
    }

    public static void unregisterBeanFromMainContext(GenericApplicationContext mainCtx, String beanName) {
        Assert.notNull((Object)beanName, (String)"bean must not be null");
        ((AbstractAutowireCapableBeanFactory)mainCtx.getBeanFactory()).destroySingleton(beanName);
    }

    public static void unregisterBeanFromMainContext(GenericApplicationContext mainCtx, Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        String beanName = bean.getClass().getName();
        ((AbstractAutowireCapableBeanFactory)mainCtx.getBeanFactory()).destroySingleton(beanName);
    }
}

