/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.laxture.sbp.SpringBootPlugin;
import org.springframework.beans.BeansException;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public interface PluginRequestMappingAdapter {
    public void registerController(SpringBootPlugin var1, Object var2);

    public void unregisterController(SpringBootPlugin var1, Object var2);

    default public void registerControllers(SpringBootPlugin springBootPlugin) {
        this.getControllerBeans(springBootPlugin).forEach(bean -> this.registerController(springBootPlugin, bean));
    }

    default public void unregisterControllers(SpringBootPlugin springBootPlugin) {
        this.getControllerBeans(springBootPlugin).forEach(bean -> this.unregisterController(springBootPlugin, bean));
    }

    default public Set<Object> getControllerBeans(SpringBootPlugin springBootPlugin) {
        LinkedHashSet<Object> beans = new LinkedHashSet<Object>();
        GenericApplicationContext applicationContext = springBootPlugin.getApplicationContext();
        Set sharedBeanNames = (Set)applicationContext.getBean("sharedBeanNames");
        beans.addAll(applicationContext.getBeansWithAnnotation(Controller.class).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
        beans.addAll(applicationContext.getBeansWithAnnotation(RestController.class).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
        return beans;
    }

    public Class<?> getRouterFunctionClass();

    default public void registerRouterFunction(SpringBootPlugin springBootPlugin) {
        this.getRouterFunctionBeans(springBootPlugin).forEach(bean -> {
            String beanName = bean.getClass().getName();
            springBootPlugin.unregisterBeanFromMainContext(bean);
            springBootPlugin.registerBeanToMainContext(beanName, bean);
        });
        this.initRouterFunctions(springBootPlugin);
    }

    default public void unregisterRouterFunction(SpringBootPlugin springBootPlugin) {
        this.getRouterFunctionBeans(springBootPlugin).forEach(springBootPlugin::unregisterBeanFromMainContext);
        this.initRouterFunctions(springBootPlugin);
    }

    default public Set<Object> getRouterFunctionBeans(SpringBootPlugin springBootPlugin) {
        GenericApplicationContext applicationContext = springBootPlugin.getApplicationContext();
        Set sharedBeanNames = (Set)applicationContext.getBean("sharedBeanNames");
        return applicationContext.getBeansOfType(this.getRouterFunctionClass()).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    default public void initRouterFunctions(SpringBootPlugin springBootPlugin) {
        try {
            Method initMethod;
            Object mapping = springBootPlugin.getMainApplicationContext().getBean("routerFunctionMapping");
            try {
                initMethod = mapping.getClass().getDeclaredMethod("initRouterFunctions", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            initMethod.setAccessible(true);
            initMethod.invoke(mapping, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException | BeansException throwable) {
            // empty catch block
        }
    }
}

