/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.laxture.sbp.SpringBootPlugin;
import org.laxture.sbp.internal.SpringExtensionFactory;
import org.laxture.sbp.spring.boot.PluginStartingError;
import org.laxture.sbp.spring.boot.SbpPluginStateChangedEvent;
import org.pf4j.DefaultPluginManager;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginState;
import org.pf4j.PluginStateEvent;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.GenericApplicationContext;

public class SpringBootPluginManager
extends DefaultPluginManager
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPluginManager.class);
    private boolean mainApplicationStarted;
    private GenericApplicationContext mainApplicationContext;
    public Map<String, Object> presetProperties = new HashMap<String, Object>();
    private boolean autoStartPlugin = true;
    private String[] profiles;
    private PluginRepository pluginRepository;
    private final Map<String, PluginStartingError> startingErrors = new HashMap<String, PluginStartingError>();
    private ReentrantLock loadingLock = new ReentrantLock();

    public SpringBootPluginManager() {
    }

    public SpringBootPluginManager(Path pluginsRoot) {
        super(new Path[]{pluginsRoot});
    }

    protected ExtensionFactory createExtensionFactory() {
        return new SpringExtensionFactory(this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mainApplicationContext = (GenericApplicationContext)applicationContext;
    }

    public PluginDescriptorFinder getPluginDescriptorFinder() {
        return super.getPluginDescriptorFinder();
    }

    protected PluginRepository createPluginRepository() {
        this.pluginRepository = super.createPluginRepository();
        return this.pluginRepository;
    }

    public PluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    public void setAutoStartPlugin(boolean autoStartPlugin) {
        this.autoStartPlugin = autoStartPlugin;
    }

    public boolean isAutoStartPlugin() {
        return this.autoStartPlugin;
    }

    public void setMainApplicationStarted(boolean mainApplicationStarted) {
        this.mainApplicationStarted = mainApplicationStarted;
    }

    public void setProfiles(String[] profiles) {
        this.profiles = profiles;
    }

    public String[] getProfiles() {
        return this.profiles;
    }

    public void presetProperties(Map<String, Object> presetProperties) {
        this.presetProperties.putAll(presetProperties);
    }

    public void presetProperties(String name, Object value) {
        this.presetProperties.put(name, value);
    }

    public Map<String, Object> getPresetProperties() {
        return this.presetProperties;
    }

    public ApplicationContext getMainApplicationContext() {
        return this.mainApplicationContext;
    }

    public boolean isMainApplicationStarted() {
        return this.mainApplicationStarted;
    }

    public void afterPropertiesSet() {
        if (this.autoStartPlugin) {
            this.loadingLock.lock();
        }
        this.loadPlugins();
    }

    public PluginStartingError getPluginStartingError(String pluginId) {
        return this.startingErrors.get(pluginId);
    }

    public boolean isLoading() {
        return this.loadingLock.isLocked();
    }

    public void releaseLoadingLock() {
        this.loadingLock.unlock();
    }

    private void doStartPlugins() {
        this.loadingLock.lock();
        long ts = System.currentTimeMillis();
        for (PluginWrapper pluginWrapper : this.resolvedPlugins) {
            PluginState pluginState = pluginWrapper.getPluginState();
            if (PluginState.DISABLED == pluginState || PluginState.STARTED == pluginState) continue;
            if (pluginWrapper.getPlugin() == null) {
                this.loadingLock.unlock();
                throw new IllegalArgumentException("pluginId " + pluginWrapper.getPluginId() + " doesn't existed.");
            }
            try {
                pluginWrapper.getPlugin().start();
                pluginWrapper.setPluginState(PluginState.STARTED);
                this.startedPlugins.add(pluginWrapper);
                this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                this.startingErrors.put(pluginWrapper.getPluginId(), PluginStartingError.of(pluginWrapper.getPluginId(), e.getMessage(), e.toString()));
                SpringBootPlugin.releaseLegacyResources(pluginWrapper, this.mainApplicationContext);
            }
        }
        log.info("[SBP] {} plugins are started in {}ms. {} failed", new Object[]{this.getPlugins(PluginState.STARTED).size(), System.currentTimeMillis() - ts, this.startingErrors.size()});
    }

    private void doStopPlugins() {
        this.startingErrors.clear();
        Collections.reverse(this.startedPlugins);
        Iterator itr = this.startedPlugins.iterator();
        while (itr.hasNext()) {
            PluginWrapper pluginWrapper = (PluginWrapper)itr.next();
            PluginState pluginState = pluginWrapper.getPluginState();
            if (PluginState.STARTED != pluginState) continue;
            try {
                log.info("Stop plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
                pluginWrapper.getPlugin().stop();
                pluginWrapper.setPluginState(PluginState.STOPPED);
                itr.remove();
                SpringBootPlugin.releaseLegacyResources(pluginWrapper, this.mainApplicationContext);
                this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
            }
            catch (PluginRuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.startingErrors.put(pluginWrapper.getPluginId(), PluginStartingError.of(pluginWrapper.getPluginId(), e.getMessage(), e.toString()));
            }
        }
    }

    private PluginState doStartPlugin(String pluginId, boolean sendEvent) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        PluginState previousState = plugin.getPluginState();
        try {
            PluginState pluginState = super.startPlugin(pluginId);
            if (sendEvent && previousState != pluginState) {
                this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
            }
            return pluginState;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.startingErrors.put(plugin.getPluginId(), PluginStartingError.of(plugin.getPluginId(), e.getMessage(), e.toString()));
            SpringBootPlugin.releaseLegacyResources(plugin, this.mainApplicationContext);
            return plugin.getPluginState();
        }
    }

    private PluginState doStopPlugin(String pluginId, boolean sendEvent) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        if (plugin == null) {
            throw new IllegalArgumentException("pluginId " + pluginId + " doesn't existed.");
        }
        PluginState previousState = plugin.getPluginState();
        try {
            PluginState pluginState = super.stopPlugin(pluginId);
            SpringBootPlugin.releaseLegacyResources(plugin, this.mainApplicationContext);
            if (sendEvent && previousState != pluginState) {
                this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
            }
            return pluginState;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.startingErrors.put(plugin.getPluginId(), PluginStartingError.of(plugin.getPluginId(), e.getMessage(), e.toString()));
            return plugin.getPluginState();
        }
    }

    public void startPlugins() {
        try {
            this.doStartPlugins();
            this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public PluginState startPlugin(String pluginId) {
        try {
            this.loadingLock.lock();
            PluginState pluginState = this.doStartPlugin(pluginId, true);
            return pluginState;
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public void stopPlugins() {
        try {
            this.loadingLock.lock();
            this.doStopPlugins();
            this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public PluginState stopPlugin(String pluginId) {
        try {
            this.loadingLock.lock();
            PluginState pluginState = this.doStopPlugin(pluginId, true);
            return pluginState;
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public void restartPlugins() {
        try {
            this.loadingLock.lock();
            this.doStopPlugins();
            this.doStartPlugins();
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginState restartPlugin(String pluginId) {
        try {
            this.loadingLock.lock();
            PluginState pluginState = this.doStopPlugin(pluginId, false);
            if (pluginState != PluginState.STARTED) {
                this.doStartPlugin(pluginId, false);
            }
            this.doStartPlugin(pluginId, false);
            this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
            PluginState pluginState2 = pluginState;
            return pluginState2;
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public void reloadPlugins(boolean restartStartedOnly) {
        try {
            this.loadingLock.lock();
            this.doStopPlugins();
            ArrayList startedPluginIds = new ArrayList();
            this.getPlugins().forEach(plugin -> {
                if (plugin.getPluginState() == PluginState.STARTED) {
                    startedPluginIds.add(plugin.getPluginId());
                }
                this.unloadPlugin(plugin.getPluginId());
            });
            this.loadPlugins();
            if (restartStartedOnly) {
                startedPluginIds.forEach(pluginId -> {
                    if (this.getPlugin((String)pluginId) != null) {
                        this.doStartPlugin((String)pluginId, false);
                    }
                });
                this.mainApplicationContext.publishEvent((ApplicationEvent)new SbpPluginStateChangedEvent((ApplicationContext)this.mainApplicationContext));
            } else {
                this.startPlugins();
            }
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginState reloadPlugins(String pluginId) {
        try {
            this.loadingLock.lock();
            PluginWrapper plugin = this.getPlugin(pluginId);
            this.doStopPlugin(pluginId, false);
            this.unloadPlugin(pluginId, false);
            try {
                this.loadPlugin(plugin.getPluginPath());
            }
            catch (Exception ex) {
                PluginState pluginState = null;
                this.loadingLock.unlock();
                return pluginState;
            }
            PluginState pluginState = this.doStartPlugin(pluginId, true);
            return pluginState;
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public ReentrantLock getLoadingLock() {
        return this.loadingLock;
    }
}

