/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.laxture.sbp.SpringBootPlugin;
import org.springframework.beans.BeansException;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public interface PluginRequestMappingAdapter {
    public void registerController(SpringBootPlugin var1, String var2, Object var3);

    public void unregisterController(SpringBootPlugin var1, Object var2);

    default public void registerControllers(SpringBootPlugin springBootPlugin) {
        this.getControllerBeans(springBootPlugin).forEach((beanName, bean) -> this.registerController(springBootPlugin, (String)beanName, bean));
    }

    default public void unregisterControllers(SpringBootPlugin springBootPlugin) {
        this.getControllerBeans(springBootPlugin).forEach((beanName, bean) -> this.unregisterController(springBootPlugin, bean));
    }

    default public Map<String, Object> getControllerBeans(SpringBootPlugin springBootPlugin) {
        LinkedHashMap<String, Object> beans = new LinkedHashMap<String, Object>();
        GenericApplicationContext applicationContext = springBootPlugin.getApplicationContext();
        Set sharedBeanNames = (Set)applicationContext.getBean("sharedBeanNames");
        beans.putAll(applicationContext.getBeansWithAnnotation(Controller.class).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        beans.putAll(applicationContext.getBeansWithAnnotation(RestController.class).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return beans;
    }

    public Class<?> getRouterFunctionClass();

    default public void registerRouterFunction(SpringBootPlugin springBootPlugin) {
        this.getRouterFunctionBeans(springBootPlugin).forEach((beanName, bean) -> {
            springBootPlugin.unregisterBeanFromMainContext((String)beanName);
            springBootPlugin.registerBeanToMainContext((String)beanName, bean);
        });
        this.initRouterFunctions(springBootPlugin);
    }

    default public void unregisterRouterFunction(SpringBootPlugin springBootPlugin) {
        this.getRouterFunctionBeans(springBootPlugin).forEach((beanName, bean) -> springBootPlugin.unregisterBeanFromMainContext((String)beanName));
        this.initRouterFunctions(springBootPlugin);
    }

    default public Map<String, Object> getRouterFunctionBeans(SpringBootPlugin springBootPlugin) {
        GenericApplicationContext applicationContext = springBootPlugin.getApplicationContext();
        Set sharedBeanNames = (Set)applicationContext.getBean("sharedBeanNames");
        return applicationContext.getBeansOfType(this.getRouterFunctionClass()).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public void initRouterFunctions(SpringBootPlugin springBootPlugin) {
        try {
            Method initMethod;
            Object mapping = springBootPlugin.getMainApplicationContext().getBean("routerFunctionMapping");
            try {
                initMethod = mapping.getClass().getDeclaredMethod("initRouterFunctions", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            initMethod.setAccessible(true);
            initMethod.invoke(mapping, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException | BeansException throwable) {
            // empty catch block
        }
    }
}

