/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.internal.webflux;

import java.io.IOException;
import java.util.Arrays;
import org.laxture.spring.util.ApplicationContextProvider;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.resource.PathResourceResolver;
import reactor.core.publisher.Mono;

public class PluginResourceResolver
extends PathResourceResolver {
    @Autowired
    @Lazy
    private PluginManager pluginManager;

    protected Mono<Resource> getResource(String resourcePath, Resource location) {
        if (!(location instanceof ClassPathResource)) {
            return null;
        }
        ClassPathResource classPathLocation = (ClassPathResource)location;
        if (this.pluginManager == null) {
            this.pluginManager = (PluginManager)ApplicationContextProvider.getBean(PluginManager.class);
        }
        try {
            for (PluginWrapper plugin : this.pluginManager.getPlugins(PluginState.STARTED)) {
                ClassPathResource pluginLocation = new ClassPathResource(classPathLocation.getPath(), plugin.getPluginClassLoader());
                Resource resource = pluginLocation.createRelative(resourcePath);
                if (!resource.isReadable()) continue;
                if (this.checkResource(resource, (Resource)pluginLocation)) {
                    return Mono.just((Object)resource);
                }
                if (!this.logger.isWarnEnabled()) continue;
                Resource[] allowedLocations = this.getAllowedLocations();
                this.logger.warn((Object)("Resource path \"" + resourcePath + "\" was successfully resolved but resource \"" + resource.getURL() + "\" is neither under the current location \"" + location.getURL() + "\" nor under any of the allowed locations " + (allowedLocations != null ? Arrays.asList(allowedLocations) : "[]")));
            }
        }
        catch (IOException ex) {
            return Mono.error((Throwable)ex);
        }
        return super.getResource(resourcePath, location);
    }
}

