/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import lombok.NonNull;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import org.springframework.beans.factory.BeanFactory;

public class BeanUtil {
    private BeanUtil() {
    }

    public static Field getField(@NonNull Class<?> clazz, @NonNull String fieldName) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getFieldValue(@NonNull Object target, @NonNull String path) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String[] fieldPath = path.split("\\.");
        ArrayList<Object> obj = target;
        for (int i = 0; i < fieldPath.length && obj != null; ++i) {
            if ("*".equals(fieldPath[i])) {
                if (obj instanceof Map) {
                    obj = ((Map)((Object)obj)).values();
                    continue;
                }
                if (obj instanceof Collection) continue;
                return null;
            }
            if (obj instanceof Collection) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object v : obj) {
                    Object value = BeanUtil.getFieldValue(v, v.getClass(), fieldPath[i]);
                    values.add(value);
                }
                obj = values;
                continue;
            }
            obj = BeanUtil.getFieldValue(obj, obj.getClass(), fieldPath[i]);
        }
        return (T)obj;
    }

    public static Class<?> getFieldClass(@NonNull Object target, @NonNull String fieldName) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        try {
            return target.getClass().getDeclaredField(fieldName).getType();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getFieldValue(@NonNull Object target, @NonNull Class<?> clazz, @NonNull String fieldName) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return ((Map)target).get(fieldName);
        }
        try {
            Field field = target instanceof Class ? ((Class)target).getDeclaredField(fieldName) : clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                return target instanceof Class ? BeanUtil.getFieldValue(((Class)target).getSuperclass(), clazz, fieldName) : BeanUtil.getFieldValue(target, clazz.getSuperclass(), fieldName);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setFieldValue(@NonNull Object target, @NonNull String fieldName, Object value) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        BeanUtil.setFieldValue(target, target.getClass(), fieldName, value);
    }

    private static void setFieldValue(@NonNull Object target, @NonNull Class clazz, @NonNull String fieldName, Object value) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        try {
            Field field = target instanceof Class ? ((Class)target).getDeclaredField(fieldName) : clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                BeanUtil.setFieldValue(target, clazz.getSuperclass(), fieldName, value);
            }
            throw new RuntimeException("Set field " + fieldName + " failed.", nsfe);
        }
        catch (Exception e) {
            throw new RuntimeException("Set field " + fieldName + " failed.", e);
        }
    }

    public static <T extends Serializable> T deepClone(@NonNull T o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(o);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            return (T)((Serializable)o.getClass().cast(in.readObject()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy Object " + o.getClass().getName(), e);
        }
    }

    public static Method getDeclaredMethod(@NonNull Class<?> clazz, @NonNull String methodName, Class<?> ... parameterTypes) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        Method method = null;
        for (Class<?> clz = clazz; clz != Object.class; clz = clz.getSuperclass()) {
            try {
                method = parameterTypes.length > 0 ? clz.getDeclaredMethod(methodName, parameterTypes) : clz.getDeclaredMethod(methodName, new Class[0]);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method getMethod(@NonNull Class<?> clazz, @NonNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        try {
            method = parameterTypes.length > 0 ? clazz.getMethod(methodName, parameterTypes) : clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static <R, O> R callMethod(O object, @NonNull String methodName, Object ... parameters) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        Class<?> clazz = object.getClass();
        return BeanUtil.callMethod(clazz, object, methodName, parameters);
    }

    public static <R> R callMethod(Class<?> clazz, Object object, @NonNull String methodName, Object ... parameters) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        if (object == null) {
            return null;
        }
        Method method = parameters.length == 0 ? BeanUtil.getMethod(clazz, methodName, new Class[0]) : BeanUtil.getMethod(clazz, methodName, (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new));
        if (method == null) {
            method = parameters.length == 0 ? BeanUtil.getDeclaredMethod(clazz, methodName, new Class[0]) : BeanUtil.getDeclaredMethod(clazz, methodName, (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new));
        }
        if (method == null) {
            return null;
        }
        try {
            return (R)method.invoke(object, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static String getBeanName(BeanFactory beanFactory, Object bean) {
        String beanName = null;
        Map beans = (Map)BeanUtil.getFieldValue(beanFactory, "disposableBeans");
        if (beans != null) {
            beanName = beans.entrySet().stream().filter(entry -> entry.getValue() == bean).findAny().map(Map.Entry::getKey).orElse(null);
        }
        if (beanName == null && (beans = (Map)BeanUtil.getFieldValue(beanFactory, "singletonObjects")) != null) {
            beanName = beans.entrySet().stream().filter(entry -> entry.getValue() == bean).findAny().map(Map.Entry::getKey).orElse(null);
        }
        return beanName;
    }

    public static <T> T createProxy(Class<T> clazz, T source, BiFunction<T, DynamicType.Builder<T>, DynamicType.Builder<T>> customizer) {
        try {
            DynamicType.Builder<T> builder = new ByteBuddy().subclass(clazz).suffix("_sbp_proxy").unsealed();
            builder = customizer.apply(source, builder);
            return builder.make().load(source.getClass().getClassLoader()).getLoaded().newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static <T> T createProxy(T source, BiFunction<T, DynamicType.Builder<T>, DynamicType.Builder<T>> customizer) {
        return (T)BeanUtil.createProxy(source.getClass(), source, customizer);
    }
}

