/*
 * Decompiled with CFR 0.152.
 */
package org.skr;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.skr.common.util.JsonUtil;
import org.skr.config.GeneralExceptionHandler;
import org.skr.security.SkrSecurityProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
@EnableConfigurationProperties
@Import(value={SkrSecurityProperties.class, GeneralExceptionHandler.class})
public class SkrConfig {
    @Bean
    @ConditionalOnMissingBean
    public KeyGenerator keyGenerator() {
        return (target, method, params) -> {
            String targetClass = method.getDeclaringClass().getName();
            String methodPrefix = targetClass + "\u2206" + method.getName() + "\u2206";
            if (params.length == 0) {
                return methodPrefix + SimpleKey.EMPTY;
            }
            return methodPrefix + Arrays.stream(params).map(param -> {
                if (param == null) {
                    return "null";
                }
                if (param.getClass().isArray()) {
                    return "array";
                }
                return param.toString();
            }).collect(Collectors.joining("\u2206"));
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder() {
        return JsonUtil.newObjectMapperBuilder();
    }
}

