/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.skr.common.exception.ErrorInfo;

public abstract class BaseException
extends RuntimeException {
    private static final long serialVersionUID = 2846815275271113791L;
    public static final int TOP_STACK = 10;

    public BaseException() {
    }

    public BaseException(String message) {
        super(message);
    }

    public BaseException(String message, Throwable cause) {
        super(message, cause);
    }

    public ErrorInfo getErrorInfo() {
        return ErrorInfo.INTERNAL_SERVER_ERROR;
    }

    private static List<StackTraceElement> getTopStackTraceElement(Throwable cause) {
        ArrayList<StackTraceElement> topStack = new ArrayList<StackTraceElement>(10);
        for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
            if (stackTraceElement.getLineNumber() <= 0) continue;
            topStack.add(stackTraceElement);
            if (topStack.size() >= 10) break;
        }
        return topStack;
    }

    public static String getStackTrace(Throwable cause) {
        List<StackTraceElement> stack = BaseException.getTopStackTraceElement(cause);
        return stack.stream().map(element -> {
            String fullClassName = element.getClassName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            return String.format("%s:%s(%s)", className, element.getMethodName(), element.getLineNumber());
        }).collect(Collectors.joining("\n"));
    }
}

