/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.exception;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.rits.cloning.Cloner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.skr.common.util.Checker;
import org.skr.config.json.StringValuedEnum;

public class ErrorInfo {
    @NotNull
    private int code;
    @NotNull
    private String msg;
    private ErrorLevel level = ErrorLevel.ERROR;
    private Object[] args;
    private String exception;
    private Map<String, Object> extra;
    private boolean shared = true;
    public static final ErrorInfo OK = ErrorInfo.of(0, null);
    public static final ErrorInfo INTERNAL_SERVER_ERROR = ErrorInfo.of(1001, "%s", ErrorLevel.FATAL);
    public static final ErrorInfo ENTITY_NOT_FOUND = ErrorInfo.of(1002, "Entity %s(%s) not found.");
    public static final ErrorInfo DELETION_RESTRICTED = ErrorInfo.of(1003, "Deletion %s(%s)restricted.");
    public static final ErrorInfo INVALID_SUBMITTED_DATA = ErrorInfo.of(1004, "Invalid submitted data. %s");
    public static final ErrorInfo INVALID_SERVER_DATA = ErrorInfo.of(1005, "Invalid server data. %s");
    public static final ErrorInfo SAVE_DATA_FAILED = ErrorInfo.of(1006, "Save data failed.");
    public static final ErrorInfo DUPLICATED_ENTITY = ErrorInfo.of(1007, "Duplicated entity %s(%s).");
    public static final ErrorInfo CLASS_NOT_FOUND = ErrorInfo.of(1008, "Class %s not found.", ErrorLevel.FATAL);
    public static final ErrorInfo REQUIRED_PROPERTY_NOT_SET = ErrorInfo.of(1009, "Required property %s is not set.", ErrorLevel.FATAL);
    public static final ErrorInfo INCOMPATIBLE_TYPE = ErrorInfo.of(1010, "Except type %s but %s is given.", ErrorLevel.FATAL);
    public static final ErrorInfo NOT_NULLABLE = ErrorInfo.of(1011, "%s could not be null.", ErrorLevel.FATAL);
    public static final ErrorInfo ILLEGAL_DATA = ErrorInfo.of(1012, "Illegal data %s.");
    public static final ErrorInfo CONSTRUCTOR_NOT_FOUND = ErrorInfo.of(1013, "Required constructor is not found for class %s.");
    public static final ErrorInfo METHOD_NOT_FOUND = ErrorInfo.of(1014, "Method %s is not found for class %s.", ErrorLevel.FATAL);
    public static final ErrorInfo FIELD_NOT_FOUND = ErrorInfo.of(1015, "Field %s is not found for class %s.", ErrorLevel.FATAL);
    public static final ErrorInfo AUTHENTICATION_REQUIRED = ErrorInfo.of(1100, "Authentication required.");
    public static final ErrorInfo NOT_AUTHENTICATED = ErrorInfo.of(1101, "Account %s is not authenticated.");
    public static final ErrorInfo ACCESS_TOKEN_EXPIRED = ErrorInfo.of(1102, "Access token is expired.");
    public static final ErrorInfo ACCESS_TOKEN_BROKEN = ErrorInfo.of(1103, "Access token is broken.");
    public static final ErrorInfo ACCESS_TOKEN_NOT_PROVIDED = ErrorInfo.of(1104, "Access token is not provided.");
    public static final ErrorInfo REFRESH_TOKEN_EXPIRED = ErrorInfo.of(1105, "Refresh token is expired.");
    public static final ErrorInfo REFRESH_TOKEN_BROKEN = ErrorInfo.of(1106, "Refresh token is broken.");
    public static final ErrorInfo PERMISSION_DENIED = ErrorInfo.of(1107, "Permission Denied.");
    public static final ErrorInfo PERMISSION_LIMITED = ErrorInfo.of(1108, "Vip Level is not satisfied.", ErrorLevel.FATAL);
    public static final ErrorInfo PERMISSION_NOT_FOUND = ErrorInfo.of(1109, "Permission %s not found.", ErrorLevel.FATAL);
    public static final ErrorInfo PERMISSION_REGISTERED = ErrorInfo.of(1200, "Permission %s has been registered to realm %s", ErrorLevel.FATAL);
    public static final ErrorInfo END_POINT_REGISTERED = ErrorInfo.of(1201, "EndPoint %s has been registered to realm %s", ErrorLevel.FATAL);
    public static final ErrorInfo PERMISSION_REVOKE_FAILED = ErrorInfo.of(1202, "Permission %s is enabled in realm %s. You have to re-register this realm without this permission to disable it first.", ErrorLevel.FATAL);
    public static final ErrorInfo END_POINT_REVOKE_FAILED = ErrorInfo.of(1203, "EndPoint %s is enabled in realm %s. You have to re-register this realm without this permission to disable it first.", ErrorLevel.FATAL);

    public static ErrorInfo of(int code, String msg) {
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.code = code;
        errorInfo.msg = msg;
        return errorInfo;
    }

    public static ErrorInfo of(int code, String msg, ErrorLevel level) {
        ErrorInfo errorInfo = ErrorInfo.of(code, msg);
        errorInfo.level = level;
        return errorInfo;
    }

    private static ErrorInfo getOrCopy(@NonNull ErrorInfo target) {
        ErrorInfo errorInfo;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (target.shared) {
            errorInfo = (ErrorInfo)Cloner.shared().shallowClone((Object)target);
            errorInfo.shared = false;
        } else {
            errorInfo = target;
        }
        return errorInfo;
    }

    public ErrorInfo exception(Throwable ex) {
        ErrorInfo errorInfo = ErrorInfo.getOrCopy(this);
        errorInfo.exception = ex.getLocalizedMessage();
        return errorInfo;
    }

    public ErrorInfo msgArgs(Object ... args) {
        ErrorInfo errorInfo = ErrorInfo.getOrCopy(this);
        errorInfo.args = args;
        return errorInfo;
    }

    public ErrorInfo extra(String key, Object value) {
        ErrorInfo errorInfo = ErrorInfo.getOrCopy(this);
        if (errorInfo.extra == null) {
            errorInfo.extra = new HashMap<String, Object>();
        }
        errorInfo.extra.put(key, value);
        return errorInfo;
    }

    @JsonProperty(value="ec")
    public int getCode() {
        return this.code;
    }

    @JsonProperty(value="msg")
    public String getMsg() {
        return !Checker.isEmpty(this.args) ? String.format(this.msg, this.args) : this.msg;
    }

    @JsonProperty(value="elv")
    public ErrorLevel getLevel() {
        return this.level;
    }

    @JsonProperty(value="ex")
    public String getException() {
        return this.exception;
    }

    @JsonProperty(value="extra")
    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public <T> T getExtra(String key) {
        if (Checker.isEmpty(this.extra)) {
            return null;
        }
        return (T)this.extra.get(key);
    }

    public static ErrorLevel worstErrorLevel(List<ErrorInfo> errors) {
        if (Checker.isEmpty(errors)) {
            return null;
        }
        return errors.stream().map(ErrorInfo::getLevel).filter(level -> level == ErrorLevel.FATAL).findAny().orElse(errors.stream().map(ErrorInfo::getLevel).filter(level -> level == ErrorLevel.ERROR).findAny().orElse(ErrorLevel.WARNING));
    }

    public String toString() {
        return "ErrorInfo(code=" + this.getCode() + ", msg=" + this.getMsg() + ", level=" + this.getLevel() + ", args=" + Arrays.deepToString(this.args) + ", exception=" + this.getException() + ", extra=" + this.getExtra() + ", shared=" + this.shared + ")";
    }

    public static enum ErrorLevel implements StringValuedEnum
    {
        WARNING("warn"),
        ERROR("error"),
        FATAL("fatal");

        private final String value;

        private ErrorLevel(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ErrorLevel parse(String value) {
            for (ErrorLevel item : ErrorLevel.values()) {
                if (!Objects.equals(item.value(), value)) continue;
                return item;
            }
            return FATAL;
        }
    }
}

