/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.Assert;

public class BeanUtil {
    public static <E> void copyFields(E source, E target, String ... ignoreFields) {
        BeanUtil.copyIncludeOrExcludeFields(source, target, false, (String[])ArrayUtils.addAll((Object[])ignoreFields, (Object[])new String[]{"id", "uid", "createdBy", "createdAt", "updatedBy", "updatedAt"}));
    }

    public static <E> void copySpecifiedFields(E source, E target, String ... specifiedFields) {
        BeanUtil.copyIncludeOrExcludeFields(source, target, true, specifiedFields);
    }

    public static <E> void copyIncludeOrExcludeFields(E source, E target, boolean isInclude, String ... fields) {
        Assert.notNull(source, (String)"Source must not be null");
        Assert.notNull(target, (String)"Target must not be null");
        if (source == target) {
            return;
        }
        for (Field field : source.getClass().getFields()) {
            try {
                Field targetField;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isPrivate(field.getModifiers()) || Modifier.isProtected(field.getModifiers()) || isInclude && ArrayUtils.indexOf((Object[])fields, (Object)field.getName()) < 0 || !isInclude && ArrayUtils.indexOf((Object[])fields, (Object)field.getName()) >= 0) continue;
                try {
                    targetField = target.getClass().getField(field.getName());
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Collection srcCollection = (Collection)field.get(source);
                    Collection targetCollection = (Collection)targetField.get(target);
                    if (srcCollection == null && targetCollection == null) continue;
                    if (srcCollection == null) {
                        targetCollection.clear();
                        continue;
                    }
                    if (targetCollection == null) {
                        targetField.set(target, srcCollection);
                        continue;
                    }
                    try {
                        targetCollection.clear();
                        targetCollection.addAll(srcCollection);
                    }
                    catch (UnsupportedOperationException e) {
                        targetField.set(target, srcCollection);
                    }
                    continue;
                }
                targetField.set(target, field.get(source));
            }
            catch (Exception e) {
                throw new RuntimeException("Copy field " + field.getName() + " failed.", e);
            }
        }
    }

    public static <T> T getFieldValue(Object target, String fieldName) {
        return (T)BeanUtil.getFieldValue(target, target.getClass(), fieldName);
    }

    public static Class getFieldClass(Object target, String fieldName) {
        try {
            return target.getClass().getDeclaredField(fieldName).getType();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getFieldValue(Object target, Class clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                return BeanUtil.getFieldValue(target, clazz.getSuperclass(), fieldName);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        BeanUtil.setFieldValue(target, target.getClass(), fieldName, value);
    }

    private static void setFieldValue(Object target, Class clazz, String fieldName, Object value) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                BeanUtil.setFieldValue(target, clazz.getSuperclass(), fieldName, value);
            }
            throw new RuntimeException("Set field " + fieldName + " failed.", nsfe);
        }
        catch (Exception e) {
            throw new RuntimeException("Set field " + fieldName + " failed.", e);
        }
    }

    public static <T extends Serializable> T deepClone(T o) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(o);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            return (T)((Serializable)o.getClass().cast(in.readObject()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy Object " + o.getClass().getName(), e);
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class ... parameterTypes) {
        Method method;
        try {
            method = parameterTypes.length > 0 ? clazz.getDeclaredMethod(methodName, parameterTypes) : clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class ... parameterTypes) {
        Method method;
        try {
            method = parameterTypes.length > 0 ? clazz.getMethod(methodName, parameterTypes) : clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }
}

