/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Stream;
import org.laxture.spring.util.ApplicationContextProvider;
import org.skr.config.json.IntValuedEnum;
import org.skr.config.json.IntValuedEnumSerializer;
import org.skr.config.json.StreamSerializer;
import org.skr.config.json.StringValuedEnum;
import org.skr.config.json.StringValuedEnumSerializer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class JsonUtil {
    public static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = (ObjectMapper)ApplicationContextProvider.getBean(ObjectMapper.class);
        if (objectMapper == null) {
            objectMapper = JsonUtil.newObjectMapperBuilder().build();
        }
        return objectMapper;
    }

    public static Jackson2ObjectMapperBuilder newObjectMapperBuilder() {
        return new Jackson2ObjectMapperBuilder().serializationInclusion(JsonInclude.Include.NON_NULL).modulesToInstall(new Module[]{JsonUtil.getDefaultModule(), new Jdk8Module(), new JavaTimeModule()}).featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.PUBLIC_ONLY).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY).visibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.NONE);
    }

    public static SimpleModule getDefaultModule() {
        return new SimpleModule().addSerializer(IntValuedEnum.class, (JsonSerializer)new IntValuedEnumSerializer()).addSerializer(StringValuedEnum.class, (JsonSerializer)new StringValuedEnumSerializer()).addSerializer(Stream.class, (JsonSerializer)new StreamSerializer());
    }

    public static <T> T fromJson(Class<?> type, String json) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), type, json);
    }

    public static <T> T fromJson(TypeReference<T> type, String json) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), type, json);
    }

    public static <T> T fromJson(JavaType javaType, String json) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), javaType, json);
    }

    public static <T> T fromJson(Class<?> type, JsonNode jsonNode) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), type, jsonNode);
    }

    public static <T> T fromJson(TypeReference<T> type, JsonNode jsonNode) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), type, jsonNode);
    }

    public static <T> T fromJson(JavaType javaType, JsonNode jsonNode) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), javaType, jsonNode);
    }

    public static String toJson(Object obj, Class<?> jsonViewClazz) {
        return JsonUtil.toJson(JsonUtil.getObjectMapper(), obj, jsonViewClazz);
    }

    public static String toJson(Object obj) {
        return JsonUtil.toJson(JsonUtil.getObjectMapper(), obj);
    }

    public static JsonNode toJsonNode(Object obj) {
        return JsonUtil.toJsonNode(JsonUtil.getObjectMapper(), obj);
    }

    public static <T> T fromJson(ObjectMapper objectMapper, Class<?> type, String json) {
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Deserialize json text failed. " + json, e);
        }
    }

    public static <T> T fromJson(ObjectMapper objectMapper, TypeReference<T> type, String json) {
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Deserialize json text failed. " + json, e);
        }
    }

    public static <T> T fromJson(ObjectMapper objectMapper, JavaType javaType, String json) {
        try {
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException("Deserialize json text failed. " + json, e);
        }
    }

    public static <T> T fromJson(ObjectMapper objectMapper, Class<?> type, JsonNode jsonNode) {
        return (T)objectMapper.convertValue((Object)jsonNode, type);
    }

    public static <T> T fromJson(ObjectMapper objectMapper, TypeReference<T> type, JsonNode jsonNode) {
        return (T)objectMapper.convertValue((Object)jsonNode, type);
    }

    public static <T> T fromJson(ObjectMapper objectMapper, JavaType javaType, JsonNode jsonNode) {
        return (T)objectMapper.convertValue((Object)jsonNode, javaType);
    }

    public static String toJson(ObjectMapper objectMapper, Object obj, Class<?> jsonViewClazz) {
        try {
            return objectMapper.writerWithView(jsonViewClazz).writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialize object<" + obj.getClass().getName() + "> to json failed.", e);
        }
    }

    public static String toJson(ObjectMapper objectMapper, Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialize object<" + obj.getClass().getName() + "> to json failed.", e);
        }
    }

    public static JsonNode toJsonNode(ObjectMapper objectMapper, Object obj) {
        try {
            return objectMapper.valueToTree(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialize object<" + obj.getClass().getName() + "> to json failed.", e);
        }
    }

    public static JavaType getJavaType(Class<?> clazz) {
        return JsonUtil.getObjectMapper().getSerializationConfig().getTypeFactory().constructType(clazz);
    }

    public static JavaType getCollectionJavaType(Class<? extends Collection> collectionClass, Class<?> elementClass) {
        return JsonUtil.getObjectMapper().getSerializationConfig().getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }
}

