/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;

public class JwtUtil {
    public static String encode(String subject, long expiration, String secret) {
        JWTCreator.Builder builder = JWT.create().withSubject(subject);
        if (expiration > 0L) {
            builder.withExpiresAt(new Date(System.currentTimeMillis() + expiration * 60L * 1000L));
        }
        return builder.sign(Algorithm.HMAC512((byte[])secret.getBytes()));
    }

    public static String decode(String token, String secret) {
        DecodedJWT decoded = JWT.require((Algorithm)Algorithm.HMAC512((byte[])secret.getBytes())).build().verify(token);
        if (decoded == null) {
            return null;
        }
        return decoded.getSubject();
    }
}

