/*
 * Decompiled with CFR 0.152.
 */
package org.skr.config;

import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.skr.common.exception.AuthException;
import org.skr.common.exception.BizException;
import org.skr.common.exception.ErrorInfo;
import org.skr.common.exception.PermissionException;
import org.skr.common.exception.UnvarnishedFeignException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Order(value=-2147483648)
@ControllerAdvice
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        Object standerBody = Optional.ofNullable(body).orElse(ErrorInfo.INTERNAL_SERVER_ERROR.msgArgs(ex.getMessage()));
        return super.handleExceptionInternal(ex, standerBody, headers, status, request);
    }

    @ExceptionHandler(value={BizException.class})
    public ResponseEntity<Object> handleException(BizException ex, WebRequest request) {
        return this.handleExceptionInternal(ex, ex.getErrorInfo(), new HttpHeaders(), HttpStatus.UNPROCESSABLE_ENTITY, request);
    }

    @ExceptionHandler(value={AuthException.class})
    public ResponseEntity<Object> handleException(AuthException ex, WebRequest request) {
        return this.handleExceptionInternal((Exception)((Object)ex), ex.getErrorInfo(), new HttpHeaders(), HttpStatus.UNAUTHORIZED, request);
    }

    @ExceptionHandler(value={PermissionException.class})
    public ResponseEntity<Object> handleException(PermissionException ex, WebRequest request) {
        return this.handleExceptionInternal((Exception)((Object)ex), ex.getErrorInfo(), new HttpHeaders(), HttpStatus.FORBIDDEN, request);
    }

    @ExceptionHandler(value={UnvarnishedFeignException.class})
    public ResponseEntity<Object> handleException(UnvarnishedFeignException ex, WebRequest request) {
        return this.handleExceptionInternal(ex, ex.getErrorInfo(), new HttpHeaders(), HttpStatus.valueOf((int)ex.getResponseStatus()), request);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleUncaughtException(Exception ex, WebRequest request) {
        log.error(ExceptionUtils.getStackTrace((Throwable)ex));
        return this.handleExceptionInternal(ex, ErrorInfo.INTERNAL_SERVER_ERROR.msgArgs(ex.getMessage()).exception(ex), new HttpHeaders(), HttpStatus.INTERNAL_SERVER_ERROR, request);
    }
}

