/*
 * Decompiled with CFR 0.152.
 */
package org.skr.registry.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.skr.registry.EndPointRegistry;
import org.skr.registry.PermissionRegistry;
import org.skr.registry.RealmRegistry;
import org.skr.registry.SiteEntry;
import org.springframework.stereotype.Service;

@Service
public interface RegistryService<Realm extends RealmRegistry, Permission extends PermissionRegistry, EndPoint extends EndPointRegistry> {
    public Realm getRealm(String var1);

    public Realm registerRealm(@NotNull Realm var1, @NotNull List<Permission> var2, @NotNull List<EndPoint> var3);

    public void unregisterRealm(Realm var1);

    public Permission getPermission(String var1);

    public EndPoint getEndPoint(String var1);

    public void revokePermission(String var1);

    public void revokeEndPoint(String var1);

    default public List<SiteEntry> buildSiteMap(List<EndPoint> endPoints) {
        ArrayList<SiteEntry> siteMap = new ArrayList<SiteEntry>();
        endPoints.sort(Comparator.comparing(EndPointRegistry::getBreadcrumb));
        endPoints.forEach(endPoint -> {
            String[] breadcrumbPath = endPoint.getBreadcrumb().split("\\.");
            List<SiteEntry> matchingLevel = siteMap;
            SiteEntry[] matchedSiteEntries = new SiteEntry[breadcrumbPath.length];
            for (int i = 0; i < breadcrumbPath.length; ++i) {
                String pathNode = breadcrumbPath[i];
                Optional<SiteEntry> matchedSiteEntry = matchingLevel.stream().filter(siteEntry -> Objects.equals(siteEntry.breadcrumb, pathNode)).findAny();
                if (matchedSiteEntry.isPresent()) {
                    matchedSiteEntries[i] = matchedSiteEntry.get();
                    matchingLevel = matchedSiteEntry.get().siteEntries;
                    continue;
                }
                for (int j = i; j < breadcrumbPath.length; ++j) {
                    matchedSiteEntries[j] = null;
                }
                break;
            }
            for (int k = 0; k < breadcrumbPath.length; ++k) {
                if (matchedSiteEntries[k] != null) continue;
                SiteEntry newSiteEntry = new SiteEntry();
                newSiteEntry.breadcrumb = breadcrumbPath[k];
                if (k == breadcrumbPath.length - 1) {
                    newSiteEntry.endPoint = endPoint;
                }
                matchedSiteEntries[k] = newSiteEntry;
                if (k == 0) {
                    siteMap.add(newSiteEntry);
                    continue;
                }
                matchedSiteEntries[k - 1].siteEntries.add(newSiteEntry);
            }
        });
        return siteMap;
    }
}

