/*
 * Decompiled with CFR 0.152.
 */
package org.skr.security;

import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import java.util.Collections;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.skr.common.exception.AuthException;
import org.skr.common.exception.ConfException;
import org.skr.common.exception.ErrorInfo;
import org.skr.common.util.Checker;
import org.skr.common.util.JsonUtil;
import org.skr.common.util.JwtUtil;
import org.skr.common.util.tuple.Tuple2;
import org.skr.security.JwtPrincipal;
import org.skr.security.SkrSecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class JwtAuthentication {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthentication.class);

    public static void authenticate(String accessToken, SkrSecurityProperties properties) {
        try {
            if (Checker.isEmpty(accessToken)) {
                throw new AuthException(ErrorInfo.ACCESS_TOKEN_NOT_PROVIDED);
            }
            Authentication authentication = JwtAuthentication.getAuthentication(accessToken, properties);
            if (!authentication.isAuthenticated()) {
                throw new AuthException(ErrorInfo.AUTHENTICATION_REQUIRED);
            }
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (TokenExpiredException ex) {
            throw new AuthException(ErrorInfo.ACCESS_TOKEN_EXPIRED);
        }
        catch (JWTVerificationException ex) {
            throw new AuthException(ErrorInfo.ACCESS_TOKEN_BROKEN);
        }
        catch (Exception ex) {
            log.error(ExceptionUtils.getStackTrace((Throwable)ex));
            throw new AuthException(ErrorInfo.AUTHENTICATION_REQUIRED);
        }
    }

    public static Authentication getAuthentication(String accessToken, SkrSecurityProperties properties) {
        String secret;
        String prefix;
        if (accessToken.startsWith(properties.getAccessToken().getPrefix())) {
            prefix = properties.getAccessToken().getPrefix();
            secret = properties.getAccessToken().getSecret();
        } else if (accessToken.startsWith(properties.getRobotToken().getPrefix())) {
            prefix = properties.getRobotToken().getPrefix();
            secret = properties.getRobotToken().getSecret();
        } else if (accessToken.startsWith(properties.getTrainToken().getPrefix())) {
            prefix = properties.getTrainToken().getPrefix();
            secret = properties.getTrainToken().getSecret();
        } else {
            throw new AuthException(ErrorInfo.AUTHENTICATION_REQUIRED);
        }
        if (properties.getJwtPrincipalClass() == null) {
            throw new ConfException(ErrorInfo.REQUIRED_PROPERTY_NOT_SET.msgArgs("spring.skr.security.jwtPrincipalClass"));
        }
        return Optional.of(accessToken).map(token -> token.replace(prefix, "")).map(token -> new Tuple2<String, String>(JwtUtil.decode(token, secret), (String)token)).map(decodedTuple -> {
            JwtPrincipal principal = (JwtPrincipal)JsonUtil.fromJson(properties.getJwtPrincipalClass(), (String)decodedTuple._0);
            if (Checker.isTrue(principal.isRobot())) {
                principal.setApiTrainJwtToken(accessToken);
            } else {
                principal.setApiTrainJwtToken(properties.getTrainToken().getPrefix() + JwtUtil.encode(JsonUtil.toJson(principal), properties.getTrainToken().getExpiration(), properties.getTrainToken().getSecret()));
            }
            return new JwtAuthenticationToken(principal);
        }).orElse(null);
    }

    public static class JwtAuthenticationToken
    extends AbstractAuthenticationToken {
        private final JwtPrincipal principal;

        public JwtAuthenticationToken(@NotNull JwtPrincipal principal) {
            super(Collections.emptyList());
            if (principal == null) {
                throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
            }
            this.principal = principal;
            this.setAuthenticated(true);
        }

        public Object getCredentials() {
            return "";
        }

        public Object getPrincipal() {
            return this.principal;
        }
    }
}

