/*
 * Decompiled with CFR 0.152.
 */
package org.skr.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public interface JwtPrincipal {
    @NotNull
    public String getUsername();

    public Boolean isRobot();

    @JsonIgnore
    public String getApiTrainJwtToken();

    public void setApiTrainJwtToken(String var1);

    public static JwtPrincipal getCurrentPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        JwtPrincipal user = null;
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof JwtPrincipal) {
            user = (JwtPrincipal)authentication.getPrincipal();
        }
        return user;
    }
}

