/*
 * Decompiled with CFR 0.152.
 */
package org.skr.security;

import java.util.List;
import org.skr.config.YamlPropertyLoaderFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:security.yml"}, factory=YamlPropertyLoaderFactory.class)
@ConfigurationProperties(prefix="spring.skr.security")
public class SkrSecurityProperties {
    private boolean appEnabled = true;
    private boolean permissionCheckEnabled = true;
    private boolean renewRefreshToken = false;
    private boolean configCors = false;
    private Class jwtPrincipalClass;
    private List<String> skipUrls;
    private Token loginToken = new Token();
    private Token accessToken = new Token();
    private Token refreshToken = new Token();
    private Token robotToken = new Token();
    private Token trainToken = new Token();

    public boolean isAppEnabled() {
        return this.appEnabled;
    }

    public boolean isPermissionCheckEnabled() {
        return this.permissionCheckEnabled;
    }

    public boolean isRenewRefreshToken() {
        return this.renewRefreshToken;
    }

    public boolean isConfigCors() {
        return this.configCors;
    }

    public Class getJwtPrincipalClass() {
        return this.jwtPrincipalClass;
    }

    public List<String> getSkipUrls() {
        return this.skipUrls;
    }

    public Token getLoginToken() {
        return this.loginToken;
    }

    public Token getAccessToken() {
        return this.accessToken;
    }

    public Token getRefreshToken() {
        return this.refreshToken;
    }

    public Token getRobotToken() {
        return this.robotToken;
    }

    public Token getTrainToken() {
        return this.trainToken;
    }

    public void setAppEnabled(boolean appEnabled) {
        this.appEnabled = appEnabled;
    }

    public void setPermissionCheckEnabled(boolean permissionCheckEnabled) {
        this.permissionCheckEnabled = permissionCheckEnabled;
    }

    public void setRenewRefreshToken(boolean renewRefreshToken) {
        this.renewRefreshToken = renewRefreshToken;
    }

    public void setConfigCors(boolean configCors) {
        this.configCors = configCors;
    }

    public void setJwtPrincipalClass(Class jwtPrincipalClass) {
        this.jwtPrincipalClass = jwtPrincipalClass;
    }

    public void setSkipUrls(List<String> skipUrls) {
        this.skipUrls = skipUrls;
    }

    public void setLoginToken(Token loginToken) {
        this.loginToken = loginToken;
    }

    public void setAccessToken(Token accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshToken(Token refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setRobotToken(Token robotToken) {
        this.robotToken = robotToken;
    }

    public void setTrainToken(Token trainToken) {
        this.trainToken = trainToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkrSecurityProperties)) {
            return false;
        }
        SkrSecurityProperties other = (SkrSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAppEnabled() != other.isAppEnabled()) {
            return false;
        }
        if (this.isPermissionCheckEnabled() != other.isPermissionCheckEnabled()) {
            return false;
        }
        if (this.isRenewRefreshToken() != other.isRenewRefreshToken()) {
            return false;
        }
        if (this.isConfigCors() != other.isConfigCors()) {
            return false;
        }
        Class this$jwtPrincipalClass = this.getJwtPrincipalClass();
        Class other$jwtPrincipalClass = other.getJwtPrincipalClass();
        if (this$jwtPrincipalClass == null ? other$jwtPrincipalClass != null : !this$jwtPrincipalClass.equals(other$jwtPrincipalClass)) {
            return false;
        }
        List<String> this$skipUrls = this.getSkipUrls();
        List<String> other$skipUrls = other.getSkipUrls();
        if (this$skipUrls == null ? other$skipUrls != null : !((Object)this$skipUrls).equals(other$skipUrls)) {
            return false;
        }
        Token this$loginToken = this.getLoginToken();
        Token other$loginToken = other.getLoginToken();
        if (this$loginToken == null ? other$loginToken != null : !((Object)this$loginToken).equals(other$loginToken)) {
            return false;
        }
        Token this$accessToken = this.getAccessToken();
        Token other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !((Object)this$accessToken).equals(other$accessToken)) {
            return false;
        }
        Token this$refreshToken = this.getRefreshToken();
        Token other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !((Object)this$refreshToken).equals(other$refreshToken)) {
            return false;
        }
        Token this$robotToken = this.getRobotToken();
        Token other$robotToken = other.getRobotToken();
        if (this$robotToken == null ? other$robotToken != null : !((Object)this$robotToken).equals(other$robotToken)) {
            return false;
        }
        Token this$trainToken = this.getTrainToken();
        Token other$trainToken = other.getTrainToken();
        return !(this$trainToken == null ? other$trainToken != null : !((Object)this$trainToken).equals(other$trainToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SkrSecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAppEnabled() ? 79 : 97);
        result = result * 59 + (this.isPermissionCheckEnabled() ? 79 : 97);
        result = result * 59 + (this.isRenewRefreshToken() ? 79 : 97);
        result = result * 59 + (this.isConfigCors() ? 79 : 97);
        Class $jwtPrincipalClass = this.getJwtPrincipalClass();
        result = result * 59 + ($jwtPrincipalClass == null ? 43 : $jwtPrincipalClass.hashCode());
        List<String> $skipUrls = this.getSkipUrls();
        result = result * 59 + ($skipUrls == null ? 43 : ((Object)$skipUrls).hashCode());
        Token $loginToken = this.getLoginToken();
        result = result * 59 + ($loginToken == null ? 43 : ((Object)$loginToken).hashCode());
        Token $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : ((Object)$accessToken).hashCode());
        Token $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : ((Object)$refreshToken).hashCode());
        Token $robotToken = this.getRobotToken();
        result = result * 59 + ($robotToken == null ? 43 : ((Object)$robotToken).hashCode());
        Token $trainToken = this.getTrainToken();
        result = result * 59 + ($trainToken == null ? 43 : ((Object)$trainToken).hashCode());
        return result;
    }

    public String toString() {
        return "SkrSecurityProperties(appEnabled=" + this.isAppEnabled() + ", permissionCheckEnabled=" + this.isPermissionCheckEnabled() + ", renewRefreshToken=" + this.isRenewRefreshToken() + ", configCors=" + this.isConfigCors() + ", jwtPrincipalClass=" + this.getJwtPrincipalClass() + ", skipUrls=" + this.getSkipUrls() + ", loginToken=" + this.getLoginToken() + ", accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", robotToken=" + this.getRobotToken() + ", trainToken=" + this.getTrainToken() + ")";
    }

    public static class Token {
        private String secret = "skr";
        private long expiration = 0L;
        private String prefix = "";
        private String header;
        private String username;

        public String getSecret() {
            return this.secret;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getHeader() {
            return this.header;
        }

        public String getUsername() {
            return this.username;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public void setExpiration(long expiration) {
            this.expiration = expiration;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token other = (Token)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
                return false;
            }
            if (this.getExpiration() != other.getExpiration()) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            String this$header = this.getHeader();
            String other$header = other.getHeader();
            if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            return !(this$username == null ? other$username != null : !this$username.equals(other$username));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Token;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            long $expiration = this.getExpiration();
            result = result * 59 + (int)($expiration >>> 32 ^ $expiration);
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            String $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            return result;
        }

        public String toString() {
            return "SkrSecurityProperties.Token(secret=" + this.getSecret() + ", expiration=" + this.getExpiration() + ", prefix=" + this.getPrefix() + ", header=" + this.getHeader() + ", username=" + this.getUsername() + ")";
        }
    }
}

