/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.exception;

import feign.Response;
import feign.Util;
import java.io.Reader;
import org.skr.common.exception.BaseException;
import org.skr.common.exception.ErrorInfo;
import org.skr.common.util.Checker;
import org.skr.common.util.JsonUtil;

public class UnvarnishedFeignException
extends BaseException {
    private ErrorInfo errorInfo;
    private int responseStatus;

    private UnvarnishedFeignException() {
    }

    public UnvarnishedFeignException(String message) {
        super(message);
    }

    public UnvarnishedFeignException(String message, Throwable cause) {
        super(message, cause);
    }

    public static UnvarnishedFeignException build(String methodKey, Response response) {
        UnvarnishedFeignException exception;
        int responseStatus = response.status();
        ErrorInfo errorInfo = null;
        try {
            String errorJson;
            if (response.body() != null && Checker.isEmpty((CharSequence)(errorInfo = (ErrorInfo)JsonUtil.fromJson(ErrorInfo.class, errorJson = Util.toString((Reader)response.body().asReader()))).getExtra("failedRpc"))) {
                errorInfo.extra("failedRpc", methodKey);
            }
            exception = new UnvarnishedFeignException(errorInfo.getMessage());
        }
        catch (Exception ex) {
            errorInfo = ErrorInfo.INTERNAL_SERVER_ERROR.msgArgs(ex.getLocalizedMessage());
            exception = new UnvarnishedFeignException(errorInfo.getMessage(), ex);
        }
        exception.responseStatus = responseStatus;
        exception.errorInfo = errorInfo;
        return exception;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }
}

