/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.skr.common.util.Checker;
import org.springframework.util.Assert;

public class BeanUtil {
    public static Map<Class<?>, Class<?>> PRIMITIVE_TYPES = Map.of(Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Void.class, Void.TYPE);

    public static boolean isPrimitive(Object val) {
        if (val == null) {
            return false;
        }
        return BeanUtil.isPrimitive(val.getClass());
    }

    public static boolean isPrimitive(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return PRIMITIVE_TYPES.containsKey(clazz) || PRIMITIVE_TYPES.containsValue(clazz) || String.class.isAssignableFrom(clazz);
    }

    public static Class<?> getCollectionParameterizeType(@NonNull Parameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        if (!Collection.class.isAssignableFrom(parameter.getType())) {
            return null;
        }
        if (!(parameter.getParameterizedType() instanceof ParameterizedType)) {
            return null;
        }
        Type parameterizedType = ((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0];
        return parameterizedType instanceof Class ? (Class)parameterizedType : null;
    }

    public static <E> void copyFields(@NonNull E source, @NonNull E target) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        BeanUtil.copyFields(source, target, false, false, new String[0]);
    }

    public static <E> void copyFieldsExcluding(@NonNull E source, @NonNull E target, String ... fields) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        BeanUtil.copyFields(source, target, false, false, fields);
    }

    public static <E> void copyFieldsIncluding(@NonNull E source, @NonNull E target, String ... fields) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        BeanUtil.copyFields(source, target, false, true, fields);
    }

    public static <E> void copyFields(@NonNull E source, @NonNull E target, boolean ignoreNullField, boolean includeOrExclude, String ... fields) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Assert.notNull(source, (String)"Source must not be null");
        Assert.notNull(target, (String)"Target must not be null");
        if (source == target) {
            return;
        }
        for (Field sourceField : source.getClass().getFields()) {
            try {
                Field targetField;
                if (Modifier.isStatic(sourceField.getModifiers()) || Modifier.isPrivate(sourceField.getModifiers()) || Modifier.isProtected(sourceField.getModifiers()) || includeOrExclude && ArrayUtils.indexOf((Object[])fields, (Object)sourceField.getName()) < 0 || !includeOrExclude && ArrayUtils.indexOf((Object[])fields, (Object)sourceField.getName()) >= 0) continue;
                try {
                    targetField = target.getClass().getField(sourceField.getName());
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                if (ignoreNullField && targetField.get(source) == null) continue;
                if (Collection.class.isAssignableFrom(sourceField.getType())) {
                    Collection targetCollection;
                    Collection srcCollection = (Collection)sourceField.get(source);
                    try {
                        targetCollection = (Collection)targetField.get(target);
                    }
                    catch (ClassCastException ex) {
                        continue;
                    }
                    if (srcCollection == null && targetCollection == null) continue;
                    if (srcCollection == null) {
                        targetCollection.clear();
                        continue;
                    }
                    if (targetCollection == null) {
                        targetField.set(target, srcCollection);
                        continue;
                    }
                    try {
                        targetCollection.clear();
                        targetCollection.addAll(srcCollection);
                    }
                    catch (UnsupportedOperationException e) {
                        targetField.set(target, srcCollection);
                    }
                    continue;
                }
                if (Map.class.isAssignableFrom(sourceField.getType())) {
                    Map targetMap;
                    Map srcMap = (Map)sourceField.get(source);
                    try {
                        targetMap = (Map)targetField.get(target);
                    }
                    catch (ClassCastException ex) {
                        continue;
                    }
                    if (srcMap == null && targetMap == null) continue;
                    if (srcMap == null) {
                        targetMap.clear();
                        continue;
                    }
                    if (targetMap == null) {
                        targetField.set(target, srcMap);
                        continue;
                    }
                    try {
                        targetMap.clear();
                        targetMap.putAll(srcMap);
                    }
                    catch (UnsupportedOperationException e) {
                        targetField.set(target, srcMap);
                    }
                    continue;
                }
                targetField.set(target, sourceField.get(source));
            }
            catch (Exception e) {
                throw new RuntimeException("Copy field " + sourceField.getName() + " failed.", e);
            }
        }
    }

    public static <T> T getFieldValue(@NotNull Object target, @NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String[] fieldPath = path.split("\\.");
        ArrayList<Object> obj = target;
        for (int i = 0; i < fieldPath.length && obj != null; ++i) {
            if ("*".equals(fieldPath[i])) {
                if (obj instanceof Map) {
                    obj = ((Map)((Object)obj)).values();
                    continue;
                }
                if (obj instanceof Collection) continue;
                return null;
            }
            if (obj instanceof Collection) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object v : obj) {
                    Object value = BeanUtil.getFieldValue(v, v.getClass(), fieldPath[i]);
                    values.add(value);
                }
                obj = values;
                continue;
            }
            obj = BeanUtil.getFieldValue(obj, obj.getClass(), fieldPath[i]);
        }
        return (T)obj;
    }

    public static Class<?> getFieldClass(@NonNull Object target, @NonNull String fieldName) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        try {
            return target.getClass().getDeclaredField(fieldName).getType();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getFieldValue(@NonNull Object target, @NonNull Class<?> clazz, @NonNull String fieldName) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return ((Map)target).get(fieldName);
        }
        try {
            Field field = target instanceof Class ? ((Class)target).getDeclaredField(fieldName) : clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                return target instanceof Class ? BeanUtil.getFieldValue(((Class)target).getSuperclass(), clazz, fieldName) : BeanUtil.getFieldValue(target, clazz.getSuperclass(), fieldName);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setFieldValue(@NonNull Object target, @NonNull String fieldName, Object value) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        BeanUtil.setFieldValue(target, target.getClass(), fieldName, value);
    }

    private static void setFieldValue(@NonNull Object target, @NonNull Class clazz, @NonNull String fieldName, Object value) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        try {
            Field field = target instanceof Class ? ((Class)target).getDeclaredField(fieldName) : clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                BeanUtil.setFieldValue(target, clazz.getSuperclass(), fieldName, value);
            }
            throw new RuntimeException("Set field " + fieldName + " failed.", nsfe);
        }
        catch (Exception e) {
            throw new RuntimeException("Set field " + fieldName + " failed.", e);
        }
    }

    public static <T extends Serializable> T deepClone(@NonNull T o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(o);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            return (T)((Serializable)o.getClass().cast(in.readObject()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy Object " + o.getClass().getName(), e);
        }
    }

    public static Method getDeclaredMethod(@NonNull Class<?> clazz, @NonNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        try {
            method = parameterTypes.length > 0 ? clazz.getDeclaredMethod(methodName, parameterTypes) : clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method getMethod(@NonNull Class<?> clazz, @NonNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        try {
            method = parameterTypes.length > 0 ? clazz.getMethod(methodName, parameterTypes) : clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static <R, O> R callMethod(O object, @NonNull String methodName, Object ... parameters) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        Class<?> clazz = object.getClass();
        return BeanUtil.callMethod(clazz, object, methodName, parameters);
    }

    public static <R> R callMethod(Class<?> clazz, Object object, @NonNull String methodName, Object ... parameters) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        if (object == null) {
            return null;
        }
        Method method = Checker.isEmpty(parameters) ? BeanUtil.getMethod(clazz, methodName, new Class[0]) : BeanUtil.getMethod(clazz, methodName, (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new));
        if (method == null) {
            method = Checker.isEmpty(parameters) ? BeanUtil.getDeclaredMethod(clazz, methodName, new Class[0]) : BeanUtil.getDeclaredMethod(clazz, methodName, (Class[])Arrays.stream(parameters).map(Object::getClass).toArray(Class[]::new));
        }
        if (method == null) {
            return null;
        }
        try {
            return (R)method.invoke(object, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }
}

