/*
 * Decompiled with CFR 0.152.
 */
package org.skr.config;

import java.util.Optional;
import org.skr.SkrProperties;
import org.skr.common.exception.BaseException;
import org.skr.common.exception.ErrorInfo;
import org.skr.common.util.Checker;
import org.springframework.beans.factory.annotation.Autowired;

public class ExceptionFormatter {
    @Autowired
    private SkrProperties skrProperties;

    public ErrorInfo convert(Throwable ex) {
        return this.convert(ex, null);
    }

    public ErrorInfo convert(Throwable ex, ErrorInfo templateErrorInfo) {
        return this.convert(ex, templateErrorInfo, this.skrProperties.isDebug());
    }

    public ErrorInfo convert(Throwable ex, ErrorInfo templateErrorInfo, boolean debug) {
        ErrorInfo errorInfo = this.handleSpecificException(ex, this.skrProperties.isDebug());
        if (errorInfo == null) {
            errorInfo = Optional.ofNullable(templateErrorInfo).orElse(ErrorInfo.INTERNAL_SERVER_ERROR);
            if (debug) {
                String errorMessage = ex.getMessage();
                if (Checker.isEmpty(errorMessage)) {
                    errorMessage = ex.getClass().getSimpleName();
                }
                errorInfo = errorInfo.msgArgs(errorMessage);
            }
        }
        if (debug && Checker.isEmpty(errorInfo.getException())) {
            errorInfo = errorInfo.exception(ex);
        }
        return errorInfo;
    }

    protected ErrorInfo handleSpecificException(Throwable ex, boolean debug) {
        if (ex instanceof BaseException) {
            return ((BaseException)ex).getErrorInfo();
        }
        return null;
    }
}

