/*
 * Decompiled with CFR 0.152.
 */
package org.skr.config.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Hashtable;
import java.util.Map;

public class ExtendableLocalDateTimeDeserializer
extends LocalDateTimeDeserializer {
    public static final String FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_TIMESTAMP = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMAT_COMPACT = "yyyyMMddHHmmss";
    public static final ExtendableLocalDateTimeDeserializer INSTANCE = new ExtendableLocalDateTimeDeserializer();
    private Map<String, DateTimeFormatter> formatters = new Hashtable<String, DateTimeFormatter>();

    private ExtendableLocalDateTimeDeserializer() {
        super(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        this.registerFormatter(FORMAT_DEFAULT, DateTimeFormatter.ofPattern(FORMAT_DEFAULT));
        this.registerFormatter(FORMAT_TIMESTAMP, DateTimeFormatter.ofPattern(FORMAT_TIMESTAMP));
        this.registerFormatter(FORMAT_COMPACT, DateTimeFormatter.ofPattern(FORMAT_COMPACT));
    }

    public void registerFormatter(String name, DateTimeFormatter formatter) {
        this.formatters.put(name, formatter);
    }

    public void unregisterFormatter(String name) {
        this.formatters.remove(name);
    }

    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        try {
            return super.deserialize(parser, context);
        }
        catch (JsonMappingException | DateTimeException ex) {
            if (parser.hasTokenId(6)) {
                String string = parser.getText().trim();
                for (DateTimeFormatter formatter : this.formatters.values()) {
                    try {
                        return LocalDateTime.parse(string, formatter);
                    }
                    catch (DateTimeException dateTimeException) {
                    }
                }
            }
            throw ex;
        }
    }
}

